/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.patch.PatchPropertiesConfig;
import java.io.Serializable;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;

public class SolarisPatchObj
implements Serializable {
    private String patchName = "";
    private Vector packages = null;
    private Vector obsoletes = null;
    private Vector requires = null;
    private Vector incompatibles = null;
    private boolean backUpFiles = true;
    private boolean uncondInstall = false;
    private String backOutDir = "";
    private String patchDirName = "";
    private String patchFileName = "";
    private String description = "";
    private String architecture = "";
    private String solRelease = "";
    private String sunOSRelease = "";
    private CIMDateTime releaseDate;
    private CIMDateTime installDate;
    private int targetOS = 30;
    private PatchPropertiesConfig ppc = null;
    private String nobackSwitch = "-d";
    private String uncondSwitch = "-u";
    private String backoutSwitch = "-B";
    private static String patchaddCommand = "/usr/sbin/patchadd";

    public String getPatchName() {
        return this.patchName;
    }

    public void setPatchName(String patchName) {
        this.patchName = patchName;
    }

    public String getPatchDirName() {
        return this.patchDirName;
    }

    public void setPatchDirName(String patchDirName) {
        this.patchDirName = patchDirName;
    }

    public String getPatchFileName() {
        return this.patchFileName;
    }

    public void setPatchFileName(String patchFileName) {
        this.patchFileName = patchFileName;
    }

    public Vector getObsoletes() {
        return this.obsoletes;
    }

    public void setObsoletes(Vector obsoletes) {
        this.obsoletes = obsoletes;
    }

    public Vector getRequires() {
        return this.requires;
    }

    public void setRequires(Vector requires) {
        this.requires = requires;
    }

    public Vector getIncompatibles() {
        return this.incompatibles;
    }

    public void setIncompatibles(Vector incompatibles) {
        this.incompatibles = incompatibles;
    }

    public Vector getPackages() {
        return this.packages;
    }

    public void setPackages(Vector packages) {
        this.packages = packages;
    }

    public boolean getBackUpFiles() {
        return this.backUpFiles;
    }

    public void setBackUpFiles(boolean backUpFiles) {
        this.backUpFiles = backUpFiles;
    }

    public boolean getUncondInstall() {
        return this.uncondInstall;
    }

    public void setUncondInstall(boolean uncondInstall) {
        this.uncondInstall = uncondInstall;
    }

    public String getBackoutDir() {
        return this.backOutDir;
    }

    public void setBackoutDir(String backOutDir) {
        this.backOutDir = backOutDir;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getSolRelease() {
        return this.solRelease;
    }

    public void setSolRelease(String solRelease) {
        this.solRelease = solRelease;
    }

    public String getSunOSRelease() {
        return this.sunOSRelease;
    }

    public void setSunOSRelease(String sunOSRelease) {
        this.sunOSRelease = sunOSRelease;
    }

    public CIMDateTime getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(CIMDateTime releaseDate) {
        this.releaseDate = releaseDate;
    }

    public CIMDateTime getInstallDate() {
        return this.installDate;
    }

    public void setInstallDate(CIMDateTime installDate) {
        this.installDate = installDate;
    }

    public int getTargetOS() {
        return this.targetOS;
    }

    public void setTargetOS(int targetOS) {
        this.targetOS = targetOS;
    }

    public PatchPropertiesConfig getPatchPropertiesConfig() {
        return this.ppc;
    }

    public void setPatchPropertiesConfig(PatchPropertiesConfig ppc) {
        this.ppc = ppc;
    }

    public String[] patchAddCmd() {
        String tmpPatch;
        Vector<String> patchaddVec = new Vector<String>();
        patchaddVec.addElement(patchaddCommand);
        if (!this.backUpFiles) {
            patchaddVec.addElement(this.nobackSwitch);
        }
        if (this.uncondInstall) {
            patchaddVec.addElement(this.uncondSwitch);
        }
        if (this.backOutDir != null && this.backOutDir.trim().length() != 0) {
            patchaddVec.addElement(this.backoutSwitch);
            patchaddVec.addElement(this.backOutDir);
        }
        if (this.patchName != null && this.patchName.trim().length() != 0) {
            tmpPatch = this.patchDirName;
            if (!tmpPatch.endsWith("/")) {
                tmpPatch = tmpPatch.concat("/");
            }
        } else {
            return null;
        }
        tmpPatch = tmpPatch.concat(this.patchName);
        patchaddVec.addElement(tmpPatch);
        Object[] patchaddArr = new String[patchaddVec.size()];
        patchaddVec.copyInto(patchaddArr);
        return patchaddArr;
    }

    public String toString() {
        String retStr = "\n\t";
        retStr = retStr + "patchName: " + this.patchName + "\n\t";
        retStr = retStr + "obsoletes: " + this.obsoletes.toString() + "\n\t";
        retStr = retStr + "requires: " + this.requires.toString() + "\n\t";
        retStr = retStr + "incompatibles: " + this.incompatibles.toString() + "\n\t";
        retStr = retStr + "packages: " + this.packages.toString() + "\n\t";
        retStr = retStr + "backoutDir: " + this.backOutDir + "\n\t";
        retStr = retStr + "targetOS: " + this.targetOS + "\n\t";
        retStr = retStr + "synopsis: " + this.description + "\n\t";
        retStr = retStr + "architecture: " + this.architecture + "\n\t";
        retStr = retStr + "solaris release: " + this.solRelease + "\n\t";
        retStr = retStr + "sunOS release: " + this.sunOSRelease + "\n\t";
        retStr = this.releaseDate != null ? retStr + "releaseDate: " + this.releaseDate.toString() + "\n\t" : retStr + "releaseDate: " + null + "\n\t";
        retStr = this.installDate != null ? retStr + "installDate: " + this.installDate.toString() + "\n\t" : retStr + "installDate: " + null + "\n\t";
        retStr = retStr + this.ppc.toString();
        return retStr;
    }
}

