/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.model.NonFatalException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.server.FileSystemPatchServiceProviderException;
import com.sun.patchpro.server.ServerPatchServiceProviderException;
import com.sun.patchpro.util.NoResultException;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.PatchProEventMonitor;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.client.Debug;

public class PPro
implements PatchProListener {
    boolean done = false;
    protected PatchPro model = null;
    protected Thread monitorThread = null;
    protected ReadOnlyHost host;
    protected PatchProEventMonitor eventMonitor;
    protected Vector patchListVec = new Vector();
    protected String targetDir = new String();
    protected static ProviderUtility provUtil;
    protected Throwable fatalProblem;
    protected Vector nonfatalProblems = new Vector();
    private static int PPENumExcep;
    private static String[] EXMIndex;

    protected void init() throws PatchException {
        PatchException pe;
        block9: {
            pe = null;
            try {
                this.model = new PatchProAccessor().getPatchPro();
            }
            catch (PatchProException ppe) {
                Throwable tObj = ppe.getTargetException();
                if (tObj != null) {
                    try {
                        throw tObj;
                    }
                    catch (ServerPatchServiceProviderException nex) {
                        int rCode = nex.getReasonCode();
                        pe = rCode >= 0 && rCode < PPENumExcep ? new PatchException(EXMIndex[rCode]) : new PatchException(EXMIndex[0]);
                        break block9;
                    }
                    catch (FileSystemPatchServiceProviderException nex) {
                        pe = new PatchException(EXMIndex[0]);
                        break block9;
                    }
                    catch (Throwable tt) {
                        pe = new PatchException(EXMIndex[0]);
                        break block9;
                    }
                }
                pe = new PatchException(EXMIndex[0]);
            }
        }
        if (pe != null) {
            if (provUtil != null) {
                provUtil.writeLog(2, (Exception)((Object)pe));
            }
            Debug.trace3((String)pe.getLocalizedMessage());
            throw pe;
        }
        this.monitorThread = null;
        this.eventMonitor = new PatchProEventMonitor(this.model);
        this.monitorThread = new Thread(this.eventMonitor);
        this.monitorThread.start();
        this.model.addListener((PatchProListener)this);
    }

    protected void cleanup() {
        if (this.model != null) {
            this.model.removeListener((PatchProListener)this);
        }
        PatchProProperties.freeInstance();
    }

    protected void analyzeHost() throws PatchException {
        this.prepForThread();
        Debug.trace3((String)"Before analyze host");
        this.model.analyzeHost();
        Debug.trace3((String)"After analyze host");
        this.waitForThread();
        Debug.trace3((String)"Before getHost");
        try {
            this.host = this.model.getHost();
        }
        catch (NoResultException nre) {
            this.cleanup();
            if (provUtil != null) {
                provUtil.writeLog(2, (Exception)((Object)nre));
            }
            throw new PatchException(nre.getLocalizedMessage());
        }
        Debug.trace3((String)"After getHost");
    }

    protected PatchList resolve(Vector patchIDList) throws PatchException {
        String list = new String();
        Enumeration e = patchIDList.elements();
        while (true) {
            list = list + (String)e.nextElement();
            if (!e.hasMoreElements()) break;
            list = list + ",";
        }
        PatchProProperties p = PatchProProperties.getInstance();
        p.setProperty("patchpro.patches.provided", list);
        PatchList rv = this.getNeededPatches();
        p.setProperty("patchpro.patches.provided", "");
        return rv;
    }

    protected void initializeDB() throws PatchException {
        this.prepForThread();
        Debug.trace3((String)"initializeDB");
        this.model.initializeDatabase();
        this.waitForThread();
        Debug.trace3((String)"initializeDB");
    }

    protected PatchList getNeededPatches() throws PatchException {
        PatchList patchList;
        this.prepForThread();
        Debug.trace3((String)"Before assessNeededPatches().");
        this.model.assessNeededPatches();
        this.waitForThread();
        Debug.trace3((String)"Before getNeededPatches().");
        try {
            patchList = this.model.getNeededPatches();
        }
        catch (NoResultException nre) {
            this.cleanup();
            if (provUtil != null) {
                provUtil.writeLog(2, (Exception)((Object)nre));
            }
            throw new PatchException(nre.getLocalizedMessage());
        }
        return patchList;
    }

    public void patchproProgress(PatchProEvent event) {
    }

    public void patchproDone(PatchProEvent event) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent event) {
        Object eventSource = event.getSource();
        if (eventSource instanceof PatchProModel) {
            Throwable t = ((PatchProModel)eventSource).getPatchProFailure();
            if (t instanceof NonFatalException) {
                if (!t.getLocalizedMessage().equals("Received a Manipulable event.")) {
                    this.nonfatalProblems.add(t.getLocalizedMessage());
                }
            } else {
                this.fatalProblem = ((PatchProModel)eventSource).getPatchProFailure();
            }
        } else {
            this.fatalProblem = new RuntimeException("Error: Event source not PatchProModel");
        }
    }

    protected void prepForThread() {
        this.done = false;
        this.fatalProblem = null;
    }

    protected void waitForThread() throws PatchException {
        while (!this.done) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.fatalProblem == null) {
            return;
        }
        if (this.fatalProblem instanceof RuntimeException) {
            throw (RuntimeException)this.fatalProblem;
        }
        if (this.fatalProblem instanceof PatchProException) {
            throw new PatchException(this.fatalProblem.toString());
        }
        throw new RuntimeException("Unexpected throwable " + this.fatalProblem.toString());
    }

    static {
        PPENumExcep = 9;
        EXMIndex = new String[]{"EXM_PP_UNKNOWN_ERR", "EXM_PP_KEYSTORE_LOC", "EXM_PP_CERTS_IMPORT", "EXM_PP_SERVER_UNKNOWN", "EXM_PP_SERVER_NOT_SSL", "EXM_PP_CERT_SN", "EXM_PP_CERT_REVOKED", "EXM_PP_UNKNOWN_ERR", "EXM_PP_MALFORMED_SRV_URL"};
    }
}

