/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.network;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.network.NetworkConfigData;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.client.CIMProviderException;

public class NetworkConfigInfo {
    private final String netconfig = "/usr/sbin/ifconfig ";
    private final int NUM_FIELDS = 8;
    Hashtable netConfigData = new Hashtable();
    private ProviderUtility provUtil = null;

    public NetworkConfigInfo(ProviderUtility provUtil) {
        this.provUtil = provUtil;
    }

    public Hashtable initData() throws Exception {
        try {
            int c;
            Process netstat = Runtime.getRuntime().exec("/usr/sbin/ifconfig -au");
            InputStream in_stat = netstat.getInputStream();
            StringBuffer str = new StringBuffer();
            while ((c = in_stat.read()) != -1) {
                str.append((char)c);
            }
            Vector interfaces = this.GetNetworkInterfaces(str.toString());
            if (interfaces == null) {
                return null;
            }
            this.NetworkInterfaceData(interfaces);
        }
        catch (IOException e) {
            this.provUtil.writeLog(2, (Exception)e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.toString());
        }
        return this.netConfigData;
    }

    private void NetworkInterfaceData(Vector interfaceVector) {
        try {
            int numInterfaces = 0;
            Process netstat = null;
            Runtime runtime = null;
            InputStream in_stat = null;
            String[] output = null;
            numInterfaces = interfaceVector.size();
            if (numInterfaces <= 0) {
                return;
            }
            output = new String[numInterfaces];
            for (int i = 0; i < numInterfaces; ++i) {
                int c;
                runtime = Runtime.getRuntime();
                netstat = runtime.exec("/usr/sbin/ifconfig " + interfaceVector.elementAt(i).toString());
                in_stat = netstat.getInputStream();
                StringBuffer str = new StringBuffer();
                while ((c = in_stat.read()) != -1) {
                    str.append((char)c);
                }
                output[i] = str.toString();
            }
            this.ParseInterfaceData(output, numInterfaces);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ParseInterfaceData(String[] output, int numDevices) {
        try {
            String[] values = new String[8];
            for (int i = 0; i < numDevices; ++i) {
                String temp;
                String tmp_str = output[i];
                StringTokenizer st = new StringTokenizer(tmp_str, ": ");
                values[0] = st.nextToken();
                st.nextToken("<");
                values[1] = st.nextToken(" ");
                while (st.hasMoreTokens() && (temp = st.nextToken(" \t")) != null) {
                    if (temp.equalsIgnoreCase("inet")) {
                        values[2] = st.nextToken(" \n");
                        continue;
                    }
                    if (temp.equalsIgnoreCase("netmask")) {
                        values[3] = st.nextToken("   \n");
                        continue;
                    }
                    if (temp.equalsIgnoreCase("broadcast")) {
                        values[4] = st.nextToken("   \n");
                        continue;
                    }
                    if (temp.equalsIgnoreCase("index")) {
                        values[5] = st.nextToken("   \n");
                        continue;
                    }
                    if (!temp.equalsIgnoreCase("mtu")) continue;
                    values[6] = st.nextToken(" \n");
                }
                values[7] = output[i];
                NetworkConfigData netData = new NetworkConfigData(values);
                this.netConfigData.put(values[0], netData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Vector GetNetworkInterfaces(String tmpStr) {
        Vector<String> result = new Vector<String>();
        StringTokenizer st = new StringTokenizer(tmpStr, "\n");
        String testFlag = "index";
        while (st.hasMoreTokens()) {
            int num;
            String subString = st.nextToken();
            if (subString.indexOf(testFlag, 0) <= -1 || (num = subString.indexOf(58, 0)) <= 0) continue;
            result.addElement(subString.substring(0, num));
        }
        return result;
    }
}

