/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.ether;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.ether.NetInfo;
import com.sun.wbem.utility.log.LogUtil;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.InstanceProvider;

public class Solaris_EthernetAdapter
implements InstanceProvider {
    private CIMOMHandle cimomhandle = null;
    private String DevID = null;
    private int lines = 0;
    private int num_lines = 0;
    private LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "EthernetAdapter";
    String[] errmsg = new String[]{"Not Supported"};
    String[] msg = new String[]{this.PROVIDER_NAME};

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("DeviceID")) continue;
                this.DevID = (String)cp.getValue().getValue();
            }
            CIMInstance ci = cc.newInstance();
            String macaddr = NetInfo.getMacAddr(this.DevID);
            String[] addr = this.parseMac(macaddr);
            String mtu = NetInfo.getDevInfo(this.DevID, "mtu");
            String[] info = new String[]{" ", " ", " ", " "};
            Vector<String> address = new Vector<String>();
            Vector<UnsignedInt16> capability = new Vector<UnsignedInt16>();
            Vector<String> capab_Desc = new Vector<String>();
            Vector<UnsignedInt16> Enabled_Cap = new Vector<UnsignedInt16>();
            Vector<String> OtherInfo = new Vector<String>();
            capability.addElement(new UnsignedInt16(0));
            capability.addElement(new UnsignedInt16(1));
            capability.addElement(new UnsignedInt16(2));
            capability.addElement(new UnsignedInt16(3));
            capability.addElement(new UnsignedInt16(4));
            capability.addElement(new UnsignedInt16(5));
            capab_Desc.addElement(new String("Unknown"));
            capab_Desc.addElement(new String("Other"));
            capab_Desc.addElement(new String("AlertOnLan"));
            capab_Desc.addElement(new String("WakeOnLan"));
            capab_Desc.addElement(new String("FailOver"));
            capab_Desc.addElement(new String("LoadBalancing"));
            address.addElement(new String(addr[0]));
            address.addElement(new String(addr[1]));
            address.addElement(new String(addr[2]));
            address.addElement(new String(addr[3]));
            address.addElement(new String(addr[4]));
            address.addElement(new String(addr[5]));
            Enabled_Cap.addElement(new UnsignedInt16(0));
            Enabled_Cap.addElement(new UnsignedInt16(1));
            Enabled_Cap.addElement(new UnsignedInt16(2));
            Enabled_Cap.addElement(new UnsignedInt16(3));
            Enabled_Cap.addElement(new UnsignedInt16(4));
            Enabled_Cap.addElement(new UnsignedInt16(5));
            info[0] = this.DevID;
            OtherInfo.addElement(new String(info[0]));
            ci.setProperty("NetworkAddresses", new CIMValue(new Vector(address)));
            ci.setProperty("MaxDataSize", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(mtu))));
            ci.setProperty("Capabilities", new CIMValue(new Vector(capability)));
            ci.setProperty("CapabilityDescriptions", new CIMValue(new Vector(capab_Desc)));
            ci.setProperty("EnabledCapabilities", new CIMValue(new Vector(Enabled_Cap)));
            long outpack = NetInfo.getKstat(this.DevID, "outPack");
            ci.setProperty("TotalPacketsTransmitted", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(outpack)))));
            long inpack = NetInfo.getKstat(this.DevID, "inPack");
            ci.setProperty("TotalPacketsReceived", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(inpack)))));
            ci.setProperty("AlignmentErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "alignErr"))));
            ci.setProperty("FCSErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "fcsErr"))));
            ci.setProperty("SingleCollisionFrames", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "collisions"))));
            ci.setProperty("SQETestErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "sqeErr"))));
            ci.setProperty("LateCollisions", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "rxlateCol"))));
            ci.setProperty("InternalMACTransmitErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "outErr"))));
            ci.setProperty("InternalMACReceiveErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "inErr"))));
            ci.setProperty("PermanentAddress", new CIMValue((Object)macaddr));
            long speed = NetInfo.getKstat(this.DevID, "speed");
            ci.setProperty("Speed", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(speed)))));
            ci.setProperty("MaxSpeed", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(speed)))));
            long octout = NetInfo.getKstat(this.DevID, "outOctets");
            ci.setProperty("OctetsTransmitted", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(octout)))));
            long octin = NetInfo.getKstat(this.DevID, "inOctets");
            ci.setProperty("OctetsReceived", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(octin)))));
            ci.setProperty("DeferredTransmissions", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "deferTX"))));
            ci.setProperty("OtherIdentifyingInfo", new CIMValue(new Vector(OtherInfo)));
            ci.setProperty("IdentifyingDescriptions", new CIMValue(new Vector(OtherInfo)));
            ci.setProperty("PowerManagementSupported", new CIMValue((Object)new Boolean("false")));
            Vector<UnsignedInt16> PowerCapable = new Vector<UnsignedInt16>();
            PowerCapable.addElement(new UnsignedInt16(1));
            ci.setProperty("PowerManagementCapabilities", new CIMValue(new Vector(PowerCapable)));
            String status = NetInfo.getDevInfo(this.DevID, "Available");
            ci.setProperty("Availability", new CIMValue((Object)new UnsignedInt16(Integer.parseInt(status))));
            ci.setProperty("StatusInfo", new CIMValue((Object)new UnsignedInt16(Integer.parseInt(status))));
            ci.setProperty("Description", new CIMValue((Object)NetInfo.getDevInfo(this.DevID, "status")));
            ci.setProperty("Name", new CIMValue((Object)this.DevID));
            if (status.equalsIgnoreCase("3")) {
                ci.setProperty("Status", new CIMValue((Object)"Running"));
            } else {
                ci.setProperty("Status", new CIMValue((Object)"Down"));
            }
            ci.setProperty("DeviceID", new CIMValue((Object)this.DevID));
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception ex) {
                // empty catch block
            }
            ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_EthernetAdapter"));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_10204", "LM_10205", this.msg, "Success", false, 0, 0);
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_10206", "LM_10207", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance of EthernetAdapter Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        try {
            Vector<CIMInstance> adapters = new Vector<CIMInstance>();
            NetInfo.createTmpFiles();
            this.num_lines = NetInfo.getNumInterfaces();
            this.lines = 0;
            while (this.lines < this.num_lines) {
                this.DevID = NetInfo.getDevID(this.lines);
                CIMInstance ci = cc.newInstance();
                String macaddr = NetInfo.getMacAddr(this.DevID);
                String[] addr = this.parseMac(macaddr);
                String mtu = NetInfo.getDevInfo(this.DevID, "mtu");
                String[] info = new String[]{" ", " ", " ", " "};
                Vector<String> address = new Vector<String>();
                Vector<UnsignedInt16> capability = new Vector<UnsignedInt16>();
                Vector<String> capab_Desc = new Vector<String>();
                Vector<UnsignedInt16> Enabled_Cap = new Vector<UnsignedInt16>();
                Vector<String> OtherInfo = new Vector<String>();
                capability.addElement(new UnsignedInt16(0));
                capability.addElement(new UnsignedInt16(1));
                capability.addElement(new UnsignedInt16(2));
                capability.addElement(new UnsignedInt16(3));
                capability.addElement(new UnsignedInt16(4));
                capability.addElement(new UnsignedInt16(5));
                capab_Desc.addElement(new String("Unknown"));
                capab_Desc.addElement(new String("Other"));
                capab_Desc.addElement(new String("AlertOnLan"));
                capab_Desc.addElement(new String("WakeOnLan"));
                capab_Desc.addElement(new String("FailOver"));
                capab_Desc.addElement(new String("LoadBalancing"));
                address.addElement(new String(addr[0]));
                address.addElement(new String(addr[1]));
                address.addElement(new String(addr[2]));
                address.addElement(new String(addr[3]));
                address.addElement(new String(addr[4]));
                address.addElement(new String(addr[5]));
                Enabled_Cap.addElement(new UnsignedInt16(0));
                Enabled_Cap.addElement(new UnsignedInt16(1));
                Enabled_Cap.addElement(new UnsignedInt16(2));
                Enabled_Cap.addElement(new UnsignedInt16(3));
                Enabled_Cap.addElement(new UnsignedInt16(4));
                Enabled_Cap.addElement(new UnsignedInt16(5));
                info[0] = this.DevID;
                OtherInfo.addElement(new String(info[0]));
                ci.setProperty("NetworkAddresses", new CIMValue(new Vector(address)));
                ci.setProperty("MaxDataSize", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(mtu))));
                ci.setProperty("Capabilities", new CIMValue(new Vector(capability)));
                ci.setProperty("CapabilityDescriptions", new CIMValue(new Vector(capab_Desc)));
                ci.setProperty("EnabledCapabilities", new CIMValue(new Vector(Enabled_Cap)));
                long outpack = NetInfo.getKstat(this.DevID, "outPack");
                ci.setProperty("TotalPacketsTransmitted", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(outpack)))));
                long inpack = NetInfo.getKstat(this.DevID, "inPack");
                ci.setProperty("TotalPacketsReceived", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(inpack)))));
                ci.setProperty("AlignmentErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "alignErr"))));
                ci.setProperty("FCSErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "fcsErr"))));
                ci.setProperty("SingleCollisionFrames", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "collisions"))));
                ci.setProperty("SQETestErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "sqeErr"))));
                ci.setProperty("LateCollisions", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "rxlateCol"))));
                ci.setProperty("InternalMACTransmitErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "outErr"))));
                ci.setProperty("InternalMACReceiveErrors", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "inErr"))));
                ci.setProperty("PermanentAddress", new CIMValue((Object)macaddr));
                long speed = NetInfo.getKstat(this.DevID, "speed");
                ci.setProperty("Speed", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(speed)))));
                ci.setProperty("MaxSpeed", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(speed)))));
                long octout = NetInfo.getKstat(this.DevID, "outOctets");
                ci.setProperty("OctetsTransmitted", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(octout)))));
                long octin = NetInfo.getKstat(this.DevID, "inOctets");
                ci.setProperty("OctetsReceived", new CIMValue((Object)new UnsignedInt64(new BigInteger(Long.toString(octin)))));
                ci.setProperty("DeferredTransmissions", new CIMValue((Object)new UnsignedInt32(NetInfo.getKstat(this.DevID, "deferTX"))));
                ci.setProperty("OtherIdentifyingInfo", new CIMValue(new Vector(OtherInfo)));
                ci.setProperty("IdentifyingDescriptions", new CIMValue(new Vector(OtherInfo)));
                ci.setProperty("PowerManagementSupported", new CIMValue((Object)new Boolean("false")));
                Vector<UnsignedInt16> PowerCapable = new Vector<UnsignedInt16>();
                PowerCapable.addElement(new UnsignedInt16(1));
                ci.setProperty("PowerManagementCapabilities", new CIMValue(new Vector(PowerCapable)));
                String status = NetInfo.getDevInfo(this.DevID, "Available");
                ci.setProperty("Availability", new CIMValue((Object)new UnsignedInt16(Integer.parseInt(status))));
                ci.setProperty("StatusInfo", new CIMValue((Object)new UnsignedInt16(Integer.parseInt(status))));
                ci.setProperty("Description", new CIMValue((Object)NetInfo.getDevInfo(this.DevID, "status")));
                ci.setProperty("Name", new CIMValue((Object)this.DevID));
                if (status.equalsIgnoreCase("3")) {
                    ci.setProperty("Status", new CIMValue((Object)"Running"));
                } else {
                    ci.setProperty("Status", new CIMValue((Object)"Down"));
                }
                ci.setProperty("DeviceID", new CIMValue((Object)this.DevID));
                ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_EthernetAdapter"));
                if (localOnly) {
                    ci = ci.localElements();
                }
                adapters.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                ++this.lines;
            }
            CIMInstance[] ciArray = new CIMInstance[adapters.size()];
            adapters.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_10206", "LM_10207", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"enumInstance of EthernetAdapter Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> adapters = new Vector<CIMObjectPath>();
        try {
            NetInfo.createTmpFiles();
            this.num_lines = NetInfo.getNumInterfaces();
            this.lines = 0;
            while (this.lines < this.num_lines) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                try {
                    this.DevID = NetInfo.getDevID(this.lines);
                    cop.addKey("DeviceID", new CIMValue((Object)this.DevID));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)"enumInstance of Ethernet Adapter Failed");
                }
                cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_EthernetAdapter"));
                adapters.addElement(cop);
                ++this.lines;
            }
            CIMObjectPath[] copArray = new CIMObjectPath[adapters.size()];
            adapters.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_10206", "LM_10207", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"enumInstance of Ethernet Adpater Failed");
        }
    }

    public String[] parseMac(String macaddr) {
        String buff = null;
        String[] addr = new String[]{"00", "00", "00", "00", "00", "00"};
        StringTokenizer colon = new StringTokenizer(macaddr, ":");
        int count = 0;
        buff = macaddr.replace(':', ' ');
        while (colon.hasMoreTokens()) {
            addr[count] = colon.nextToken();
            ++count;
        }
        return addr;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        return null;
    }
}

