/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.mozilla.jss.tests.ClassServer;
import org.mozilla.jss.tests.Constants;

public class JSSE_SSLServer
extends ClassServer {
    private static int DefaultServerPort;
    private static int port;
    private static String type;

    public JSSE_SSLServer(ServerSocket serverSocket) throws IOException {
        super(serverSocket);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 1) {
            System.out.println("USAGE: java JSSE_SSLServer port [TLS | SSLv3 [true]]");
            System.out.println("");
            System.out.println("If the second argument is TLS, it will start as a\nTLS server, otherwise, it will be started in SSLv3 mode.\nIf the third argument is true,it will require\nclient authentication as well.");
            System.exit(0);
        }
        if (stringArray.length >= 2) {
            port = Integer.parseInt(stringArray[0]);
            type = stringArray[1];
        }
        try {
            SSLServerSocketFactory sSLServerSocketFactory = JSSE_SSLServer.getServerSocketFactory(type);
            SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(port);
            sSLServerSocket.setSoTimeout(120000);
            if (System.getProperty("java.version").indexOf("1.4") != -1) {
                System.out.println("*** Using J2SE 1.4.x ***");
                sSLServerSocket.setEnabledCipherSuites(Constants.sslciphersarray_jdk142);
            } else {
                System.out.println("*** Using J2SE 1.5.x ***");
                sSLServerSocket.setEnabledCipherSuites(Constants.sslciphersarray_jdk150);
            }
            if (stringArray.length >= 3 && stringArray[2].equals("true")) {
                sSLServerSocket.setNeedClientAuth(true);
            }
            new JSSE_SSLServer(sSLServerSocket);
        }
        catch (IOException iOException) {
            System.out.println("Unable to start ClassServer: " + iOException.getMessage());
            iOException.printStackTrace();
            System.exit(1);
        }
        try {
            Thread.currentThread();
            Thread.sleep(12000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Thread Interrupted, exiting normally ...\n");
            System.exit(0);
        }
    }

    static SSLServerSocketFactory getServerSocketFactory(String string) {
        SSLContext sSLContext = null;
        KeyManagerFactory keyManagerFactory = null;
        KeyStore keyStore = null;
        char[] cArray = "netscape".toCharArray();
        SSLServerSocketFactory sSLServerSocketFactory = null;
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public boolean checkClientTrusted(X509Certificate[] x509CertificateArray) {
                return true;
            }

            public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
                return true;
            }

            public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
                return true;
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        if (string.equals("TLS")) {
            try {
                sSLContext = SSLContext.getInstance("TLS");
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(new FileInputStream("keystore.pfx"), cArray);
                keyManagerFactory.init(keyStore, cArray);
                sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
                sSLServerSocketFactory = sSLContext.getServerSocketFactory();
                return sSLServerSocketFactory;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        } else if (string.equals("SSLv3")) {
            try {
                sSLContext = SSLContext.getInstance("SSLv3");
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(new FileInputStream("keystore.pfx"), cArray);
                keyManagerFactory.init(keyStore, cArray);
                sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
                sSLServerSocketFactory = sSLContext.getServerSocketFactory();
                return sSLServerSocketFactory;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
        return null;
    }

    static {
        port = DefaultServerPort = 29753;
        type = "SSLv3";
    }
}

