/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.ssl.SSLSocket;

public class SSLTest {
    private Hashtable params = new Hashtable();
    private String[] defaults = new String[]{"port", "443", "host", "www.amazon.com", "remotehost", "www.amazon.com"};

    public static void main(String[] stringArray) {
        new SSLTest(stringArray);
    }

    private void initParams() {
        this.processArgs(this.defaults);
    }

    private void processArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            System.out.flush();
            this.params.put(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
    }

    private void dumpParams() {
        Enumeration enumeration = this.params.keys();
        System.out.println("Parameters:");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string + "=" + (String)this.params.get(string));
        }
    }

    public SSLTest(String[] stringArray) {
        try {
            this.initParams();
            this.processArgs(stringArray);
            this.dumpParams();
            CryptoManager.initialize(".");
            int n = new Integer((String)this.params.get("port"));
            Socket socket = new Socket((String)this.params.get("host"), n);
            SSLSocket sSLSocket = new SSLSocket(socket, (String)this.params.get("remotehost"), null, null);
            sSLSocket.setSoTimeout(5000);
            OutputStream outputStream = sSLSocket.getOutputStream();
            String string = "GET / HTTP/1.0\n\n";
            byte[] byArray = string.getBytes("8859_1");
            outputStream.write(byArray);
            InputStream inputStream = sSLSocket.getInputStream();
            int n2 = 0;
            byte[] byArray2 = new byte[256];
            while ((n2 = inputStream.read(byArray2)) != -1) {
                System.out.print(new String(byArray2, 0, n2, "UTF-8"));
            }
            sSLSocket.setKeepAlive(true);
            sSLSocket.setReceiveBufferSize(32000);
            sSLSocket.setSendBufferSize(8000);
            sSLSocket.setSoLinger(true, 10);
            sSLSocket.setTcpNoDelay(true);
            System.out.println("remote addr is " + sSLSocket.getInetAddress().toString());
            System.out.println("remote port is " + sSLSocket.getPort());
            System.out.println("local addr is " + sSLSocket.getLocalAddress().toString());
            System.out.println("local port is " + sSLSocket.getLocalPort());
            System.out.println("keepalive is " + sSLSocket.getKeepAlive());
            System.out.println("receive buffer size is " + sSLSocket.getReceiveBufferSize());
            System.out.println("send buffer size is " + sSLSocket.getSendBufferSize());
            System.out.println("solinger is " + sSLSocket.getSoLinger());
            System.out.println("sotimeout is " + sSLSocket.getSoTimeout());
            System.out.println("tcpNoDelay is " + sSLSocket.getTcpNoDelay());
            sSLSocket.shutdownInput();
            sSLSocket.shutdownOutput();
            sSLSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Runtime.getRuntime().gc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

