/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.spec.DSAParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.PrivateKeyProxy;
import org.mozilla.jss.util.Assert;

public class PK11PrivKey
extends PK11Key
implements PrivateKey {
    private PK11PrivKey() {
    }

    protected PK11PrivKey(byte[] byArray) {
        Assert._assert(byArray != null);
        this.keyProxy = new PrivateKeyProxy(byArray);
    }

    public native void verifyKeyIsOnToken(PK11Token var1) throws NoSuchItemOnTokenException;

    public native CryptoToken getOwningToken();

    public native byte[] getUniqueID() throws TokenException;

    public native KeyType getKeyType();

    public PrivateKey.Type getType() {
        KeyType keyType = this.getKeyType();
        if (keyType == KeyType.RSA) {
            return PrivateKey.Type.RSA;
        }
        Assert._assert(keyType == KeyType.DSA);
        return PrivateKey.Type.DSA;
    }

    public String getAlgorithm() {
        return this.getType().toString();
    }

    public native int getStrength();

    public static PK11PrivKey fromPrivateKeyInfo(PKCS8EncodedKeySpec pKCS8EncodedKeySpec, CryptoToken cryptoToken) throws TokenException {
        return PK11PrivKey.fromPrivateKeyInfo(pKCS8EncodedKeySpec.getEncoded(), cryptoToken);
    }

    public static PK11PrivKey fromPrivateKeyInfo(byte[] byArray, CryptoToken cryptoToken) throws TokenException {
        return PK11PrivKey.fromPrivateKeyInfo(byArray, cryptoToken, null);
    }

    public static native PK11PrivKey fromPrivateKeyInfo(byte[] var0, CryptoToken var1, byte[] var2) throws TokenException;

    protected DSAParameterSpec getDSAParams() throws TokenException {
        byte[][] byArray = this.getDSAParamsNative();
        return new DSAParameterSpec(new BigInteger(byArray[0]), new BigInteger(byArray[1]), new BigInteger(byArray[2]));
    }

    private native byte[][] getDSAParamsNative() throws TokenException;
}

