/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.SecretDecoderRing;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.SecretDecoderRing.Encoding;
import org.mozilla.jss.SecretDecoderRing.KeyManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.TokenException;

public class Encryptor {
    private CryptoToken token;
    private byte[] keyID;
    private SecretKey key;
    private EncryptionAlgorithm alg;
    private KeyManager keyManager;
    public static final EncryptionAlgorithm DEFAULT_ENCRYPTION_ALG = EncryptionAlgorithm.DES3_CBC;
    static final String PROVIDER = "Mozilla-JSS";
    static final String RNG_ALG = "pkcs11prng";

    public Encryptor(CryptoToken cryptoToken, byte[] byArray, EncryptionAlgorithm encryptionAlgorithm) throws TokenException, InvalidKeyException {
        this.token = cryptoToken;
        this.keyID = byArray;
        this.alg = encryptionAlgorithm;
        this.keyManager = new KeyManager(cryptoToken);
        this.key = this.keyManager.lookupKey(encryptionAlgorithm, byArray);
        if (this.key == null) {
            throw new InvalidKeyException("Key not found");
        }
    }

    public byte[] encrypt(byte[] byArray) throws CryptoManager.NotInitializedException, GeneralSecurityException, InvalidBERException {
        byte[] byArray2;
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getThreadToken();
        try {
            cryptoManager.setThreadToken(this.token);
            byte[] byArray3 = new byte[this.alg.getIVLength()];
            SecureRandom secureRandom = SecureRandom.getInstance(RNG_ALG, PROVIDER);
            secureRandom.nextBytes(byArray3);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(this.alg.toString(), PROVIDER);
            cipher.init(1, (Key)this.key, ivParameterSpec);
            byte[] byArray4 = Cipher.pad(byArray, this.alg.getBlockSize());
            byte[] byArray5 = cipher.doFinal(byArray4);
            Encoding encoding = new Encoding(this.keyID, byArray3, this.alg.toOID(), byArray5);
            byArray2 = ASN1Util.encode(encoding);
            Object var13_13 = null;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                throw new GeneralSecurityException(illegalStateException.toString());
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                cryptoManager.setThreadToken(cryptoToken);
                throw throwable;
            }
        }
        cryptoManager.setThreadToken(cryptoToken);
        return byArray2;
    }
}

