/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.BadPaddingException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.PBEParameter;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

public class EncryptedPrivateKeyInfo
implements ASN1Value {
    private AlgorithmIdentifier encryptionAlgorithm;
    private OCTET_STRING encryptedData;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();
    static /* synthetic */ Class class$org$mozilla$jss$crypto$IVParameterSpec;

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public OCTET_STRING getEncryptedData() {
        return this.encryptedData;
    }

    private EncryptedPrivateKeyInfo() {
    }

    public EncryptedPrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, OCTET_STRING oCTET_STRING) {
        if (algorithmIdentifier == null || oCTET_STRING == null) {
            throw new IllegalArgumentException("EncryptedPrivateKeyInfo parameter is null");
        }
        this.encryptionAlgorithm = algorithmIdentifier;
        this.encryptedData = oCTET_STRING;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(algorithmIdentifier);
        this.sequence.addElement(oCTET_STRING);
    }

    public static EncryptedPrivateKeyInfo createPBE(PBEAlgorithm pBEAlgorithm, Password password, byte[] byArray, int n, KeyGenerator.CharToByteConverter charToByteConverter, PrivateKeyInfo privateKeyInfo) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, CharConversionException {
        try {
            if (!(pBEAlgorithm instanceof PBEAlgorithm)) {
                throw new NoSuchAlgorithmException("Key generation algorithm is not a PBE algorithm");
            }
            PBEAlgorithm pBEAlgorithm2 = pBEAlgorithm;
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalCryptoToken();
            KeyGenerator keyGenerator = cryptoToken.getKeyGenerator(pBEAlgorithm);
            PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(password, byArray, n);
            if (charToByteConverter != null) {
                keyGenerator.setCharToByteConverter(charToByteConverter);
            }
            keyGenerator.initialize(pBEKeyGenParams);
            SymmetricKey symmetricKey = keyGenerator.generate();
            EncryptionAlgorithm encryptionAlgorithm = pBEAlgorithm2.getEncryptionAlg();
            IVParameterSpec iVParameterSpec = null;
            if (encryptionAlgorithm.getParameterClass().equals(class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptedPrivateKeyInfo.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec)) {
                iVParameterSpec = new IVParameterSpec(keyGenerator.generatePBE_IV());
            }
            Cipher cipher = cryptoToken.getCipherContext(encryptionAlgorithm);
            cipher.initEncrypt(symmetricKey, iVParameterSpec);
            byte[] byArray2 = cipher.doFinal(Cipher.pad(ASN1Util.encode(privateKeyInfo), encryptionAlgorithm.getBlockSize()));
            PBEParameter pBEParameter = new PBEParameter(byArray, n);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(pBEAlgorithm.toOID(), pBEParameter);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(algorithmIdentifier, new OCTET_STRING(byArray2));
            return encryptedPrivateKeyInfo;
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            Assert.notReached("IllegalBlockSizeException in EncryptedContentInfo.createPBE");
        }
        catch (BadPaddingException badPaddingException) {
            Assert.notReached("BadPaddingException in EncryptedContentInfo.createPBE");
        }
        return null;
    }

    public PrivateKeyInfo decrypt(Password password, KeyGenerator.CharToByteConverter charToByteConverter) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidBERException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, IllegalBlockSizeException, BadPaddingException, CharConversionException {
        Object object;
        PBEParameter pBEParameter;
        AlgorithmIdentifier algorithmIdentifier = this.encryptionAlgorithm;
        KeyGenAlgorithm keyGenAlgorithm = KeyGenAlgorithm.fromOID(algorithmIdentifier.getOID());
        if (!(keyGenAlgorithm instanceof PBEAlgorithm)) {
            throw new NoSuchAlgorithmException("KeyGenAlgorithm is not a PBE algorithm");
        }
        ASN1Value aSN1Value = algorithmIdentifier.getParameters();
        if (aSN1Value == null) {
            throw new InvalidAlgorithmParameterException("PBE algorithms require parameters");
        }
        if (aSN1Value instanceof PBEParameter) {
            pBEParameter = (PBEParameter)aSN1Value;
        } else {
            object = ASN1Util.encode(aSN1Value);
            pBEParameter = (PBEParameter)ASN1Util.decode(PBEParameter.getTemplate(), object);
        }
        object = new PBEKeyGenParams(password, pBEParameter.getSalt(), pBEParameter.getIterations());
        CryptoToken cryptoToken = CryptoManager.getInstance().getInternalCryptoToken();
        KeyGenerator keyGenerator = cryptoToken.getKeyGenerator(keyGenAlgorithm);
        if (charToByteConverter != null) {
            keyGenerator.setCharToByteConverter(charToByteConverter);
        }
        keyGenerator.initialize((AlgorithmParameterSpec)object);
        SymmetricKey symmetricKey = keyGenerator.generate();
        EncryptionAlgorithm encryptionAlgorithm = ((PBEAlgorithm)keyGenAlgorithm).getEncryptionAlg();
        IVParameterSpec iVParameterSpec = encryptionAlgorithm.getParameterClass().equals(class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptedPrivateKeyInfo.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec) ? new IVParameterSpec(keyGenerator.generatePBE_IV()) : null;
        Cipher cipher = cryptoToken.getCipherContext(encryptionAlgorithm);
        cipher.initDecrypt(symmetricKey, iVParameterSpec);
        byte[] byArray = Cipher.unPad(cipher.doFinal(this.encryptedData.toByteArray()));
        return (PrivateKeyInfo)ASN1Util.decode(PrivateKeyInfo.getTemplate(), byArray);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new EncryptedPrivateKeyInfo((AlgorithmIdentifier)sEQUENCE.elementAt(0), (OCTET_STRING)sEQUENCE.elementAt(1));
        }
    }
}

