/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.InvalidAlgorithmParameterException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.util.Password;

public class SymKeyGen {
    public static void main(String[] stringArray) {
        try {
            CryptoManager.initialize(".");
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalCryptoToken();
            KeyGenerator keyGenerator = cryptoToken.getKeyGenerator(KeyGenAlgorithm.DES);
            SymmetricKey symmetricKey = keyGenerator.generate();
            if (symmetricKey.getType() != SymmetricKey.DES) {
                throw new Exception("wrong algorithm");
            }
            if (!symmetricKey.getOwningToken().equals(cryptoToken)) {
                throw new Exception("wrong token");
            }
            if (symmetricKey.getStrength() != 56) {
                throw new Exception("wrong strength");
            }
            byte[] byArray = symmetricKey.getKeyData();
            if (byArray.length != 8) {
                throw new Exception("key data wrong length: " + byArray.length);
            }
            System.out.println("DES key is correct");
            IVParameterSpec iVParameterSpec = new IVParameterSpec(new byte[]{-1, 0, -1, 0, -1, 0, -1, 0});
            Cipher cipher = cryptoToken.getCipherContext(EncryptionAlgorithm.DES_CBC_PAD);
            cipher.initEncrypt(symmetricKey, iVParameterSpec);
            byte[] byArray2 = new byte[]{-1, 0};
            byte[] byArray3 = cipher.doFinal(byArray2);
            cipher.initDecrypt(symmetricKey, iVParameterSpec);
            byte[] byArray4 = cipher.doFinal(byArray3);
            if (byArray4.length != byArray2.length) {
                throw new Exception("Recovered plaintext has different length (" + byArray4.length + ") than original (" + byArray2.length + ")");
            }
            int n = 0;
            while (n < byArray4.length) {
                if (byArray2[n] != byArray4[n]) {
                    throw new Exception("Recovered plaintext differs from original at position " + n);
                }
                ++n;
            }
            System.out.println("DES encryption succeeded");
            keyGenerator = cryptoToken.getKeyGenerator(KeyGenAlgorithm.DES3);
            symmetricKey = keyGenerator.generate();
            if (symmetricKey.getType() != SymmetricKey.DES3) {
                throw new Exception("wrong algorithm");
            }
            if (!symmetricKey.getOwningToken().equals(cryptoToken)) {
                throw new Exception("wrong token");
            }
            if (symmetricKey.getStrength() != 168) {
                throw new Exception("wrong strength");
            }
            byArray = symmetricKey.getKeyData();
            if (byArray.length != 24) {
                throw new Exception("key data wrong length: " + byArray.length);
            }
            System.out.println("DES3 key is correct");
            keyGenerator = cryptoToken.getKeyGenerator(KeyGenAlgorithm.RC4);
            keyGenerator.initialize(128);
            symmetricKey = keyGenerator.generate();
            if (symmetricKey.getType() != SymmetricKey.RC4) {
                throw new Exception("wrong algorithm");
            }
            if (!symmetricKey.getOwningToken().equals(cryptoToken)) {
                throw new Exception("wrong token");
            }
            if (symmetricKey.getStrength() != 128) {
                throw new Exception("wrong strength");
            }
            byArray = symmetricKey.getKeyData();
            if (byArray.length != 16) {
                throw new Exception("key data wrong length: " + byArray.length);
            }
            System.out.println("RC4 key is correct");
            keyGenerator = cryptoToken.getKeyGenerator(PBEAlgorithm.PBE_MD5_DES_CBC);
            try {
                keyGenerator.initialize(56);
                throw new Exception("ERROR: Initializing PBE key with strength succeeded");
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                Password password = new Password("passwd".toCharArray());
                byte[] byArray5 = new byte[]{-1, 0, -1};
                PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(password, byArray5, 2);
                keyGenerator.initialize(pBEKeyGenParams);
                symmetricKey = keyGenerator.generate();
                if (symmetricKey.getType() != SymmetricKey.DES) {
                    throw new Exception("Wrong key type: " + symmetricKey.getType());
                }
                if (!symmetricKey.getOwningToken().equals(cryptoToken)) {
                    throw new Exception("wrong token");
                }
                if (symmetricKey.getStrength() != 56 && symmetricKey.getStrength() != 64) {
                    throw new Exception("wrong strength: " + symmetricKey.getStrength());
                }
                byArray = symmetricKey.getKeyData();
                if (byArray.length != 8) {
                    throw new Exception("key data wrong length: " + byArray.length);
                }
                System.out.println("PBE key is correct");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

