/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.KeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.tests.DSATestValues;
import org.mozilla.jss.tests.RSATestValues;
import org.mozilla.jss.tests.TestValues;
import org.mozilla.jss.util.ConsolePasswordCallback;

public class KeyFactoryTest {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.out.println("Usage: java KeyFactoryTest <dbdir>\n");
                System.exit(1);
            }
            CryptoManager.initialize(stringArray[0]);
            CryptoToken cryptoToken = CryptoManager.getInstance().getInternalKeyStorageToken();
            cryptoToken.login(new ConsolePasswordCallback());
            Provider[] providerArray = Security.getProviders();
            int n = 0;
            while (n < providerArray.length) {
                System.out.println("======");
                System.out.println(providerArray[n].getName());
                providerArray[n].list(System.out);
                System.out.println("======");
                ++n;
            }
            new KeyFactoryTest().doTest();
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public void doTest() throws Throwable {
        RSATestValues rSATestValues = new RSATestValues();
        DSATestValues dSATestValues = new DSATestValues();
        this.genPrivKeyFromSpec(rSATestValues);
        this.genPubKeyFromSpec(rSATestValues);
        this.genPubKeyFromSpec(dSATestValues);
    }

    public void genPrivKeyFromSpec(TestValues testValues) throws Throwable {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(testValues.keyGenAlg, testValues.provider);
        keyPairGenerator.initialize(512);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        KeyFactory keyFactory = KeyFactory.getInstance(testValues.keyGenAlg, testValues.provider);
        Object t = keyFactory.getKeySpec(keyPair.getPrivate(), testValues.privateKeySpecClass);
        KeyFactory keyFactory2 = KeyFactory.getInstance(testValues.keyGenAlg, "Mozilla-JSS");
        PrivateKey privateKey = keyFactory2.generatePrivate((KeySpec)t);
        this.signVerify(testValues.sigAlg, privateKey, "Mozilla-JSS", keyPair.getPublic(), testValues.provider);
        System.out.println("Successfully generated a " + testValues.keyGenAlg + " private key from a " + testValues.privateKeySpecClass.getName());
    }

    public void signVerify(String string, PrivateKey privateKey, String string2, PublicKey publicKey, String string3) throws Throwable {
        Signature signature = Signature.getInstance(string, string2);
        signature.initSign(privateKey);
        String string4 = "blah blah blah sign me";
        signature.update(string4.getBytes("UTF-8"));
        byte[] byArray = signature.sign();
        Signature signature2 = Signature.getInstance(string, string3);
        signature2.initVerify(publicKey);
        signature2.update(string4.getBytes("UTF-8"));
        if (!signature2.verify(byArray)) {
            throw new Exception("Private/public key mismatch: signing alg=" + string + ", signing provider=" + string2 + ", verifying provider = " + string3);
        }
    }

    public void genPubKeyFromSpec(TestValues testValues) throws Throwable {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(testValues.keyGenAlg, testValues.provider);
        keyPairGenerator.initialize(512);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        KeyFactory keyFactory = KeyFactory.getInstance(testValues.keyGenAlg, testValues.provider);
        Object t = keyFactory.getKeySpec(keyPair.getPublic(), testValues.publicKeySpecClass);
        KeyFactory keyFactory2 = KeyFactory.getInstance(testValues.keyGenAlg, "Mozilla-JSS");
        PublicKey publicKey = keyFactory2.generatePublic((KeySpec)t);
        this.signVerify(testValues.sigAlg, keyPair.getPrivate(), testValues.provider, publicKey, "Mozilla-JSS");
        System.out.println("Successfully generated a " + testValues.keyGenAlg + " public key from a " + testValues.publicKeySpecClass.getName());
    }
}

