/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.FilePasswordCallback;

public class JSS_SSLServer {
    private static Vector jssSupportedCiphers = new Vector();
    private static SSLServerSocket serverSock = null;
    private static SSLSocket sock = null;
    private String serverCertNick = null;
    private String serverHost = null;
    private boolean TestInetAddress = false;
    private boolean success = true;
    public static int port = 29750;
    public static String usage = "USAGE: java JSS_SSLServer . passwords server_name servercertnick [ true | false ]";

    public static void main(String[] stringArray) throws Exception {
        try {
            new JSS_SSLServer().doIt(stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.currentThread();
            Thread.sleep(12000L);
            sock.close();
            serverSock.close();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Thread Interrupted, exiting normally ...\n");
            System.exit(0);
        }
        catch (Exception exception) {}
    }

    public void doIt(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println(usage);
            System.exit(0);
        }
        CryptoManager.initialize(stringArray[0]);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
        FilePasswordCallback filePasswordCallback = new FilePasswordCallback(stringArray[1]);
        cryptoToken.login(filePasswordCallback);
        this.serverHost = stringArray[2];
        this.serverCertNick = stringArray[3];
        if (stringArray[4].equalsIgnoreCase("true")) {
            this.TestInetAddress = true;
        }
        SSLServerSocket.configServerSessionIDCache(10, 100, 100, null);
        int n = 65281;
        while (n <= 65287) {
            if (n != 65285) {
                SSLSocket.setCipherPreferenceDefault(n, true);
            }
            ++n;
        }
        int n2 = 0;
        while (Constants.jssCipherSuites[n2] != 0) {
            try {
                SSLSocket.setCipherPreferenceDefault(Constants.jssCipherSuites[n2], true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        if (Constants.debug_level >= 3) {
            System.out.println("Server about .... to create socket");
        }
        if (this.TestInetAddress) {
            if (Constants.debug_level >= 3) {
                System.out.println("the HostName " + this.serverHost + " the Inet Address " + InetAddress.getByName(this.serverHost));
            }
            serverSock = new SSLServerSocket(port, 5, InetAddress.getByName(this.serverHost), null, true);
        } else {
            if (Constants.debug_level >= 3) {
                System.out.println("Inet set to Null");
            }
            serverSock = new SSLServerSocket(port, 5, null, null, true);
        }
        if (Constants.debug_level >= 3) {
            System.out.println("Server created socket");
        }
        serverSock.setSoTimeout(120000);
        serverSock.requireClientAuth(true, true);
        serverSock.setServerCertNickname(this.serverCertNick);
        if (Constants.debug_level >= 3) {
            System.out.println("Server specified cert by nickname");
        }
        boolean bl = true;
        while (bl) {
            sock = (SSLSocket)serverSock.accept();
            sock.addHandshakeCompletedListener(new HandshakeListener("server", this));
            InputStream inputStream = sock.getInputStream();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                if (string.equals("null")) {
                    bl = false;
                } else if (string != null) {
                    jssSupportedCiphers.add(string);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
            }
            sock.close();
        }
        serverSock.close();
        System.out.println("Server exiting");
        System.out.println("---------------------------------------------------------");
        System.out.println("Summary of JSSE client to JSS server communication test :");
        System.out.println("---------------------------------------------------------");
        int n3 = 0;
        while (n3 < jssSupportedCiphers.size()) {
            System.out.println("[" + n3 + "]\t" + jssSupportedCiphers.elementAt(n3));
            ++n3;
        }
        System.out.println("---------------------------------------------------------");
        System.out.println("Please note that in JDK 5.0 the same set of ");
        System.out.println("ciphers are exercised for SSLv3 and TLS.");
        System.out.println("---------------------------------------------------------");
        System.out.flush();
        if (this.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SSLServer boss;

        public HandshakeListener(String string, JSS_SSLServer jSS_SSLServer) {
            this.who = string;
            this.boss = jSS_SSLServer;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
                if (Constants.debug_level >= 3) {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
        }
    }
}

