/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.TestCertApprovalCallback;
import org.mozilla.jss.ssl.TestClientCertificateSelectionCallback;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class JSS_SSLClient {
    private String clientCertNick = null;
    private String serverHost = null;
    private boolean TestCertCallBack = false;
    private boolean success = true;
    private int fCipher = -1;
    private int port = 29753;
    private String EOF = "test";
    private boolean handshakeCompleted = false;
    private CryptoManager cm = null;
    private CryptoToken tok = null;
    private PasswordCallback cb = null;
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private static String usage = "USAGE: java JSS_SSLClient <serverhost> <clientcertnick>";

    public JSS_SSLClient() {
        try {
            CryptoManager.initialize(this.fCertDbPath);
            this.cm = CryptoManager.getInstance();
            this.tok = this.cm.getInternalKeyStorageToken();
            this.cb = new FilePasswordCallback(this.fPasswordFile);
            this.tok.login(this.cb);
        }
        catch (Exception exception) {}
    }

    public void setCipher(int n) {
        this.fCipher = n;
    }

    public void setHostName(String string) {
        this.serverHost = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setPasswordFile(String string) {
        this.fPasswordFile = string;
    }

    public void setCertDbPath(String string) {
        this.fCertDbPath = string;
    }

    public void setTestCertCallback(boolean bl) {
        this.TestCertCallBack = bl;
    }

    public void setClientCertNick(String string) {
        this.clientCertNick = string;
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeCompleted;
    }

    public void setHandshakeCompleted() {
        this.handshakeCompleted = true;
    }

    public void clearHandshakeCompleted() {
        this.handshakeCompleted = false;
    }

    public void setEOF(String string) {
        this.EOF = string;
    }

    public void doIt() throws Exception {
        if (Constants.debug_level >= 3) {
            System.out.println("client about to connect...");
        }
        String string = InetAddress.getByName(this.serverHost).getHostAddress();
        if (Constants.debug_level >= 3) {
            System.out.println("the host " + this.serverHost + " and the address " + string);
        }
        TestCertApprovalCallback testCertApprovalCallback = new TestCertApprovalCallback();
        TestClientCertificateSelectionCallback testClientCertificateSelectionCallback = new TestClientCertificateSelectionCallback();
        SSLSocket sSLSocket = null;
        if (this.TestCertCallBack) {
            if (Constants.debug_level >= 3) {
                System.out.println("calling approvalCallBack");
            }
            sSLSocket = new SSLSocket(InetAddress.getByName(string), this.port, null, 0, (SSLCertificateApprovalCallback)new TestCertApprovalCallback(), null);
        } else {
            if (Constants.debug_level >= 3) {
                System.out.println("NOT calling approvalCallBack");
            }
            sSLSocket = new SSLSocket(InetAddress.getByName(string), this.port);
        }
        if (Constants.debug_level >= 3) {
            System.out.println("clientCertNick=" + this.clientCertNick);
        }
        sSLSocket.setClientCertNickname(this.clientCertNick);
        if (this.fCipher != -1) {
            sSLSocket.setCipherPreference(this.fCipher, true);
        }
        if (Constants.debug_level >= 3) {
            System.out.println("Client specified cert by nickname");
            System.out.println("client connected");
        }
        sSLSocket.setSoTimeout(30000);
        sSLSocket.addHandshakeCompletedListener(new HandshakeListener("client", this));
        sSLSocket.forceHandshake();
        if (Constants.debug_level >= 3) {
            System.out.println("client forced handshake");
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(sSLSocket.getOutputStream())));
        printWriter.println(this.EOF);
        printWriter.flush();
        if (printWriter.checkError()) {
            System.out.println("SSLSocketClient: java.io.PrintWriter error");
        }
        sSLSocket.close();
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static void main(String[] stringArray) {
        block21: {
            String string = "JSSCATestCert";
            String string2 = null;
            String string3 = "localhost";
            int n = 29753;
            String string4 = null;
            String string5 = null;
            String string6 = "USAGE:\njava org.mozilla.jss.tests.JSS_SSLClient <test cipher> <server host> <server port>\n <cert db path> <password file>";
            try {
                if (stringArray.length >= 1 && (string2 = stringArray[0]).toLowerCase().equals("-h")) {
                    System.out.println(string6);
                }
                if (stringArray.length >= 3) {
                    string3 = stringArray[1];
                    n = new Integer(stringArray[2]);
                }
                if (stringArray.length >= 5) {
                    string4 = stringArray[3];
                    string5 = stringArray[4];
                }
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JSS_SSLClient jSS_SSLClient = new JSS_SSLClient();
            try {
                if (!string3.equals("localhost")) {
                    jSS_SSLClient.setHostName(string3);
                }
                if (n != 29753) {
                    jSS_SSLClient.setPort(n);
                }
                jSS_SSLClient.setTestCertCallback(true);
                jSS_SSLClient.setClientCertNick(string);
                if (string4 != null) {
                    jSS_SSLClient.setCertDbPath(string4);
                }
                if (string5 != null) {
                    jSS_SSLClient.setPasswordFile(string5);
                }
                if (string2 != null) {
                    try {
                        jSS_SSLClient.setCipher(new Integer(string2));
                        jSS_SSLClient.setEOF(string2);
                        jSS_SSLClient.doIt();
                        while (!jSS_SSLClient.isHandshakeCompleted()) {
                        }
                        jSS_SSLClient.clearHandshakeCompleted();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jSS_SSLClient.setCipher(new Integer(string2));
                    jSS_SSLClient.setEOF("null");
                    jSS_SSLClient.doIt();
                    while (!jSS_SSLClient.isHandshakeCompleted()) {
                    }
                    jSS_SSLClient.clearHandshakeCompleted();
                    break block21;
                }
                int n2 = 0;
                while (n2 < Constants.jssCipherSuites.length) {
                    try {
                        jSS_SSLClient.setCipher(Constants.jssCipherSuites[n2]);
                        jSS_SSLClient.setEOF(new Integer(Constants.jssCipherSuites[n2]).toString());
                        jSS_SSLClient.doIt();
                        while (!jSS_SSLClient.isHandshakeCompleted()) {
                        }
                        jSS_SSLClient.clearHandshakeCompleted();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
                jSS_SSLClient.setCipher(1);
                jSS_SSLClient.setEOF("null");
                jSS_SSLClient.doIt();
                while (!jSS_SSLClient.isHandshakeCompleted()) {
                }
                jSS_SSLClient.clearHandshakeCompleted();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SSLClient boss;

        public HandshakeListener(String string, JSS_SSLClient jSS_SSLClient2) {
            this.who = string;
            this.boss = jSS_SSLClient2;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
                if (Constants.debug_level >= 3) {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
            JSS_SSLClient.this.setHandshakeCompleted();
        }
    }
}

