/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.Debug;

public class JCASigTest {
    public static void usage() {
        System.out.println("Usage: java org.mozilla.jss.tests.JCASigTest <dbdir> <passwordFile>");
    }

    public static void sigTest(String string, KeyPair keyPair) {
        block3: {
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
            try {
                Signature signature = Signature.getInstance(string);
                System.out.println("Created a signing context");
                Provider provider = signature.getProvider();
                System.out.println("The provider used for the signer " + provider.getName() + " and the algorithm was " + string);
                signature.initSign((PrivateKey)keyPair.getPrivate());
                System.out.println("initialized the signing operation");
                signature.update(byArray);
                System.out.println("updated signature with data");
                byte[] byArray2 = signature.sign();
                System.out.println("Successfully signed!");
                signature.initVerify(keyPair.getPublic());
                System.out.println("initialized verification");
                signature.update(byArray);
                System.out.println("updated verification with data");
                if (signature.verify(byArray2)) {
                    System.out.println("Signature Verified Successfully!");
                    break block3;
                }
                System.out.println("ERROR: Signature failed to verify.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            JCASigTest.usage();
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        try {
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(string);
            initializationValues.removeSunProvider = true;
            CryptoManager.initialize(initializationValues);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            cryptoManager.setPasswordCallback(new FilePasswordCallback(string2));
            Debug.setLevel(10);
            Provider[] providerArray = Security.getProviders();
            int n = 0;
            while (n < providerArray.length) {
                System.out.println("Provider " + n + ": " + providerArray[n].getName());
                ++n;
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Provider provider = keyPairGenerator.getProvider();
            System.out.println("The provider used to Generate the Keys was " + provider.getName());
            System.out.println("provider info " + provider.getInfo());
            JCASigTest.sigTest("MD5/RSA", keyPair);
            JCASigTest.sigTest("MD2/RSA", keyPair);
            JCASigTest.sigTest("SHA-1/RSA", keyPair);
            JCASigTest.sigTest("SHA-256/RSA", keyPair);
            JCASigTest.sigTest("SHA-384/RSA", keyPair);
            JCASigTest.sigTest("SHA-512/RSA", keyPair);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

