/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.Security;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.util.Debug;
import org.mozilla.jss.util.Password;
import sun.security.provider.Sun;

public class DigestTest {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.out.println("Usage: DigestTest <dbdir> <infile>");
                System.exit(0);
            }
            String string = stringArray[0];
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            byte[] byArray = new byte[fileInputStream.available()];
            int n = fileInputStream.read(byArray);
            System.out.println(n + " bytes to be digested");
            CryptoManager.initialize(string);
            Debug.setLevel(10);
            Security.addProvider(new Sun());
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1", "Mozilla-JSS");
            MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-1", "SUN");
            byte[] byArray2 = messageDigest.digest(byArray);
            byte[] byArray3 = messageDigest2.digest(byArray);
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                throw new Exception("ERROR: Sun and Mozilla give different SHA-1 hashes");
            }
            System.out.println("Sun and Mozilla give same SHA-1 hash");
            messageDigest = MessageDigest.getInstance("MD5", "Mozilla-JSS");
            messageDigest2 = MessageDigest.getInstance("MD5", "SUN");
            byArray2 = messageDigest.digest(byArray);
            byArray3 = messageDigest2.digest(byArray);
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                throw new Exception("ERROR: Sun and Mozilla give different MD5 hashes");
            }
            System.out.println("Sun and Mozilla give same MD5 hash");
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalCryptoToken();
            byte[] byArray4 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(new Password("password".toCharArray()), byArray4, 1);
            KeyGenerator keyGenerator = cryptoToken.getKeyGenerator(PBEAlgorithm.PBE_SHA1_DES3_CBC);
            keyGenerator.initialize(pBEKeyGenParams);
            SymmetricKey symmetricKey = keyGenerator.generate();
            JSSMessageDigest jSSMessageDigest = cryptoToken.getDigestContext(HMACAlgorithm.SHA1);
            jSSMessageDigest.initHMAC(symmetricKey);
            jSSMessageDigest.update(byArray);
            byte[] byArray5 = jSSMessageDigest.digest();
            if (byArray5.length != jSSMessageDigest.getOutputSize()) {
                throw new Exception("ERROR: digest output size is " + byArray5.length + ", should be " + jSSMessageDigest.getOutputSize());
            }
            System.out.println("digest output size is " + byArray5.length);
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

