/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import org.mozilla.jss.tests.Constants;

public abstract class ClassServer
implements Runnable {
    private ServerSocket server = null;
    private Vector supportedCiphers = new Vector();

    protected ClassServer(ServerSocket serverSocket) {
        this.server = serverSocket;
        this.newListener();
    }

    public void run() {
        Socket socket = null;
        boolean bl = true;
        while (bl) {
            try {
                socket = this.server.accept();
            }
            catch (Exception exception) {
                System.exit(1);
            }
            this.newListener();
            try {
                InputStream inputStream = socket.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                if (string.equals("null")) {
                    bl = false;
                } else if (string != null) {
                    this.supportedCiphers.add(string);
                }
                socket.close();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
            }
        }
        try {
            this.server.close();
        }
        catch (Exception exception) {
            System.exit(1);
        }
        System.out.println("Server exiting");
        System.out.println("--------------------------------------------------------");
        System.out.println("Summary of JSS client to JSSE server communication test :");
        System.out.println("--------------------------------------------------------");
        int n = 0;
        while (n < this.supportedCiphers.size()) {
            int n2 = 0;
            while (n2 < Constants.jssCipherSuites.length) {
                if (new Integer((String)this.supportedCiphers.elementAt(n)) == Constants.jssCipherSuites[n2]) {
                    System.out.println("[" + n + "]\t" + Constants.jssCipherNames[n2]);
                    System.out.flush();
                }
                ++n2;
            }
            ++n;
        }
        System.out.println("--------------------------------------------------------");
        System.out.flush();
        if (!bl) {
            System.exit(0);
        }
    }

    private void newListener() {
        new Thread(this).start();
    }
}

