/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.ClientHandshakeCB;
import org.mozilla.jss.ssl.PrintOutputStreamWriter;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.TestCertApprovalCallback;
import org.mozilla.jss.ssl.TestClientCertificateSelectionCallback;

public class SSLClient {
    boolean handshakeEventHappened = false;
    boolean doClientAuth = false;
    Hashtable args;
    PrintStream results;
    String versionStr;
    String[] argNames = new String[]{"filename", "port", "ipaddr", "hostname", "filesize", "status", "sessionKeySize", "sessionSecretSize", "cipher", "issuer", "subject", "certSerialNum"};
    String[] values = new String[]{"/index", "443", "", "trading.etrade.com", "1024", "2", "128", "128", "RC48", "CN=Hardcore Certificate Server II, OU=Hardcore, O=Netscape Communications Corporation, C=US", "CN=hbombsgi.mcom.com, OU=Hardcore, C=US", "00C3"};
    String okay = "okay";
    String failed = "FAILED";
    private static String htmlHeader = "SSL Client Tester";
    private static String htmlTail = "\n";
    static final int[] cipherSuites = new int[]{4, 10, 9, 3, 6, 1, 0};

    private boolean isInvalid(String string) {
        return string == null || string.equals("");
    }

    private String getArgument(String string) {
        return (String)this.args.get(string);
    }

    private String cmp(String string, String string2) {
        if (string == string2) {
            return this.okay;
        }
        if (string == null) {
            return this.failed;
        }
        if (string.equals(string2)) {
            return this.okay;
        }
        return this.failed;
    }

    private String cmp(String string, int n) {
        return this.cmp(string, new Integer(n).toString());
    }

    public void run(boolean bl) {
        try {
            String string;
            ClientHandshakeCB clientHandshakeCB = null;
            if (bl) {
                this.results.println(htmlHeader);
            }
            this.results.println("SSL Client Tester");
            this.results.println("$Id: SSLClient.java,v 1.7 2004/04/25 15:02:28 gerv%gerv.net Exp $ " + this.versionStr);
            String string2 = this.getArgument("filename");
            if (this.isInvalid(string2)) {
                string2 = "/index.html";
            }
            String string3 = "GET " + string2;
            String string4 = this.getArgument("port");
            int n = this.isInvalid(string4) ? 443 : Integer.valueOf(string4);
            String string5 = string = this.getArgument("ipaddr");
            String string6 = this.getArgument("clientauth");
            if (this.isInvalid(string6)) {
                this.doClientAuth = false;
            } else {
                boolean bl2 = this.doClientAuth = !(string6 = string6.toLowerCase()).equals("off") && !string6.equals("false") && !string6.equals("0");
            }
            if (this.isInvalid(string) && this.isInvalid(string5 = this.getArgument("hostname"))) {
                throw new Exception("hostname not specified");
            }
            this.results.println("Connecting to " + string5 + " on port " + n);
            TestCertApprovalCallback testCertApprovalCallback = new TestCertApprovalCallback();
            TestClientCertificateSelectionCallback testClientCertificateSelectionCallback = new TestClientCertificateSelectionCallback();
            Socket socket = new Socket(InetAddress.getByName(string5), n);
            SSLSocket sSLSocket = new SSLSocket(socket, string5, testCertApprovalCallback, testClientCertificateSelectionCallback);
            sSLSocket.forceHandshake();
            this.results.println("Connected.");
            clientHandshakeCB = new ClientHandshakeCB(this);
            sSLSocket.addHandshakeCompletedListener(clientHandshakeCB);
            OutputStream outputStream = sSLSocket.getOutputStream();
            PrintOutputStreamWriter printOutputStreamWriter = new PrintOutputStreamWriter(outputStream);
            this.results.println("Sending: " + string3 + " to " + string5 + ", " + n);
            printOutputStreamWriter.println(string3 + "\r");
            InputStream inputStream = sSLSocket.getInputStream();
            byte[] byArray = new byte[4096];
            int n2 = 0;
            int n3 = 0;
            String string7 = null;
            try {
                while (true) {
                    this.results.println("Calling Read.");
                    int n4 = inputStream.read(byArray, 0, byArray.length);
                    if (n4 == -1) {
                        this.results.println("EOF found.");
                        break;
                    }
                    if (n4 == 0) {
                        this.results.println("Zero bytes read?");
                        break;
                    }
                    ++n3;
                    if (n2 == 0) {
                        String string8 = new String(byArray, 0, 30, "8859_1");
                        this.results.println("Read " + n4 + " bytes of data");
                        this.results.println("First 30 bytes: " + this.escapeHTML(string8));
                    }
                    n2 += n4;
                    string7 = new String(byArray, n4 - 31, 30, "8859_1");
                }
            }
            catch (IOException iOException) {
                this.results.println("IOException while reading from pipe?  Actually got " + n2 + " bytes total");
                iOException.printStackTrace(this.results);
                this.results.println("");
                throw iOException;
            }
            finally {
                this.results.println("Last 30 bytes: " + string7);
                this.results.println("Number of read() calls: " + n3);
                this.results.println("Diagnostics");
                SSLSecurityStatus sSLSecurityStatus = sSLSocket.getStatus();
                this.results.println("Total bytes read: " + n2);
                this.results.println("Security status of session:");
                this.results.println(sSLSecurityStatus.toString());
            }
            outputStream.close();
            outputStream = null;
            inputStream.close();
            inputStream = null;
            if (clientHandshakeCB != null) {
                sSLSocket.removeHandshakeCompletedListener(clientHandshakeCB);
                clientHandshakeCB = null;
            }
            sSLSocket.close();
            sSLSocket = null;
        }
        catch (Exception exception) {
            this.results.println("***** TEST FAILED *****");
            exception.printStackTrace(this.results);
            this.results.println("If there is no stack trace, try disabling the JIT and trying again.");
        }
        this.results.println("END OF TEST");
    }

    private String escapeHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public SSLClient(PrintStream printStream, String string, String[] stringArray) {
        this.args = new Hashtable();
        this.results = printStream;
        this.versionStr = string;
        int n = 0;
        while (n < this.argNames.length) {
            String string2 = this.values[n];
            if (string2 != null) {
                this.args.put(this.argNames[n], string2);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.args.put(stringArray[n2], stringArray[n2 + 1]);
            n2 += 2;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        try {
            object = new CryptoManager.InitializationValues(".");
            CryptoManager.initialize((CryptoManager.InitializationValues)object);
        }
        catch (KeyDatabaseException keyDatabaseException) {
            System.out.println("Couldn't open the key database");
            return;
        }
        catch (CertDatabaseException certDatabaseException) {
            System.out.println("Couldn't open the certificate database");
            return;
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            System.out.println("CryptoManager already initialized???");
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception occurred: " + exception.getMessage());
            return;
        }
        int n = 65281;
        while (n <= 65287) {
            if (n != 65285) {
                SSLSocket.setCipherPreferenceDefault(n, true);
            }
            ++n;
        }
        n = 0;
        while (cipherSuites[n] != 0) {
            SSLSocket.setCipherPreferenceDefault(cipherSuites[n], true);
            ++n;
        }
        object = new SSLClient(System.out, "Stand alone Ver 0.01", stringArray);
        ((SSLClient)object).run(true);
    }
}

