/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.InvalidKeyException;
import javax.crypto.SecretKey;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.SecretDecoderRing.Decryptor;
import org.mozilla.jss.SecretDecoderRing.Encryptor;
import org.mozilla.jss.SecretDecoderRing.KeyManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.tests.FilePasswordCallback;

public class TestSDR {
    public static final EncryptionAlgorithm encAlg = EncryptionAlgorithm.DES3_CBC;
    public static final KeyGenAlgorithm keyGenAlg = KeyGenAlgorithm.DES3;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            throw new Exception("Usage: java TestSDR <dbdir> <pwfile>");
        }
        CryptoManager.initialize(stringArray[0]);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        cryptoManager.setPasswordCallback(new FilePasswordCallback(stringArray[1]));
        CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
        KeyManager keyManager = new KeyManager(cryptoToken);
        byte[] byArray = keyManager.generateKey(keyGenAlg, 0);
        System.out.println("Successfully generated key");
        SecretKey secretKey = keyManager.lookupKey(encAlg, byArray);
        if (secretKey == null) {
            throw new Exception("Error: generated key not found");
        }
        System.out.println("Successfully looked up key");
        keyManager.deleteKey(byArray);
        System.out.println("Successfully deleted key");
        secretKey = keyManager.lookupKey(encAlg, byArray);
        if (secretKey != null) {
            throw new Exception("Deleted key still found");
        }
        System.out.println("Good: deleted key not found");
        byArray = keyManager.generateKey(keyGenAlg, 0);
        Encryptor encryptor = new Encryptor(cryptoToken, byArray, encAlg);
        byte[] byArray2 = "Hello, world!".getBytes("UTF-8");
        byte[] byArray3 = encryptor.encrypt(byArray2);
        System.out.println("Successfully encrypted plaintext");
        Decryptor decryptor = new Decryptor(cryptoToken);
        byte[] byArray4 = decryptor.decrypt(byArray3);
        System.out.println("Decrypted ciphertext");
        if (byArray2.length != byArray4.length) {
            throw new Exception("Recovered plaintext does not match original plaintext");
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] != byArray4[n]) {
                throw new Exception("Recovered plaintext does not match original plaintext");
            }
            ++n;
        }
        System.out.println("Decrypted ciphertext matches original plaintext");
        keyManager.deleteKey(byArray);
        try {
            byArray4 = decryptor.decrypt(byArray3);
            throw new Exception("Error: successfully decrypted with deleted key");
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("Good: failed to decrypt plaintext with deleted key");
            System.out.println("TestSDR: Success");
            System.exit(0);
            return;
        }
    }
}

