/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.RSAParameterSpec;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.pkcs11.PK11KeyPairGenerator;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.Assert;

public class TestKeyGen {
    public static void main(String[] stringArray) {
        try {
            DSAParams dSAParams;
            DSAPublicKey dSAPublicKey;
            RSAPublicKey rSAPublicKey;
            KeyPair keyPair;
            if (stringArray.length != 2) {
                System.err.println("Usage: java org.mozilla.jss.pkcs11.TestKeyGen  <dbdir> <pwfile>");
                System.exit(1);
            }
            CryptoManager.initialize(stringArray[0]);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            cryptoManager.setPasswordCallback(new FilePasswordCallback(stringArray[1]));
            Enumeration enumeration = cryptoManager.getTokensSupportingAlgorithm(KeyPairAlgorithm.RSA);
            System.out.println("The following tokens support RSA keygen:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)enumeration.nextElement()).getName());
            }
            enumeration = cryptoManager.getTokensSupportingAlgorithm(KeyPairAlgorithm.DSA);
            System.out.println("The following tokens support DSA keygen:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)enumeration.nextElement()).getName());
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "Mozilla-JSS");
            System.out.println("Generating 512-bit RSA KeyPair!");
            int n = 0;
            while (n < 5) {
                try {
                    keyPairGenerator.initialize(512);
                    keyPair = keyPairGenerator.genKeyPair();
                    Assert._assert(keyPair.getPublic() instanceof RSAPublicKey);
                    rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 512-bit RSA KeyPair!");
                    System.out.println("Modulus: " + rSAPublicKey.getModulus());
                    System.out.println("Exponent: " + rSAPublicKey.getPublicExponent());
                    break;
                }
                catch (TokenRuntimeException tokenRuntimeException) {
                    if (n == 5) {
                        System.out.println("Generation of 512-bit RSA KeyPair Failed\n");
                        tokenRuntimeException.printStackTrace();
                    }
                    ++n;
                }
            }
            System.out.println("Generating 1024-bit RSA KeyPair!");
            int n2 = 0;
            while (n2 < 5) {
                try {
                    keyPairGenerator.initialize(1024);
                    keyPair = keyPairGenerator.genKeyPair();
                    Assert._assert(keyPair.getPublic() instanceof RSAPublicKey);
                    rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 1024-bit RSA KeyPair!");
                    System.out.println("Modulus: " + rSAPublicKey.getModulus());
                    System.out.println("Exponent: " + rSAPublicKey.getPublicExponent());
                    break;
                }
                catch (TokenRuntimeException tokenRuntimeException) {
                    if (n2 == 5) {
                        System.out.println("Generation of 1024-bit RSA KeyPair Failed\n");
                        tokenRuntimeException.printStackTrace();
                    }
                    ++n2;
                }
            }
            System.out.println("Generating 512-bit RSA KeyPair with public exponent=3!");
            int n3 = 0;
            while (n3 < 5) {
                try {
                    RSAParameterSpec rSAParameterSpec = new RSAParameterSpec(512, BigInteger.valueOf(3L));
                    keyPairGenerator.initialize(rSAParameterSpec);
                    keyPair = keyPairGenerator.genKeyPair();
                    Assert._assert(keyPair.getPublic() instanceof RSAPublicKey);
                    rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 512-bit RSA KeyPair with public exponent=3!");
                    System.out.println("Modulus: " + rSAPublicKey.getModulus());
                    System.out.println("Exponent: " + rSAPublicKey.getPublicExponent());
                    break;
                }
                catch (TokenRuntimeException tokenRuntimeException) {
                    if (n3 == 5) {
                        System.out.println("Generation of 512-bit RSA KeyPair with public exponent=3 Failed\n");
                        tokenRuntimeException.printStackTrace();
                    }
                    ++n3;
                }
            }
            System.out.println("Generating 512-bit DSA KeyPair!");
            keyPairGenerator = KeyPairGenerator.getInstance("DSA", "Mozilla-JSS");
            int n4 = 0;
            while (n4 < 5) {
                try {
                    keyPairGenerator.initialize(512);
                    keyPair = keyPairGenerator.genKeyPair();
                    Assert._assert(keyPair.getPublic() instanceof DSAPublicKey);
                    dSAPublicKey = (DSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 512-bit DSA KeyPair!");
                    dSAParams = dSAPublicKey.getParams();
                    System.out.println("P: " + dSAParams.getP());
                    System.out.println("Q: " + dSAParams.getQ());
                    System.out.println("G: " + dSAParams.getG());
                    System.out.println("Y: " + dSAPublicKey.getY());
                    break;
                }
                catch (TokenRuntimeException tokenRuntimeException) {
                    if (n4 == 5) {
                        System.out.println("Generation of 512-bit DSA KeyPair Failed\n");
                        tokenRuntimeException.printStackTrace();
                    }
                    ++n4;
                }
            }
            System.out.println("Generating 1024-bit DSA KeyPair with PQG params!");
            int n5 = 0;
            while (n5 < 5) {
                try {
                    keyPairGenerator.initialize(PK11KeyPairGenerator.PQG1024);
                    keyPair = keyPairGenerator.genKeyPair();
                    Assert._assert(keyPair.getPublic() instanceof DSAPublicKey);
                    dSAPublicKey = (DSAPublicKey)keyPair.getPublic();
                    System.out.println("Generated 1024-bit DSA KeyPair with PQG params!");
                    dSAParams = dSAPublicKey.getParams();
                    System.out.println("P: " + dSAParams.getP());
                    System.out.println("Q: " + dSAParams.getQ());
                    System.out.println("G: " + dSAParams.getG());
                    System.out.println("Y: " + dSAPublicKey.getY());
                    break;
                }
                catch (TokenRuntimeException tokenRuntimeException) {
                    if (n5 == 5) {
                        System.out.println("Generation of 1024-bit DSA KeyPair with PQG params Failed\n");
                        tokenRuntimeException.printStackTrace();
                    }
                    ++n5;
                }
            }
            keyPairGenerator = KeyPairGenerator.getInstance("EC", "Mozilla-JSS");
            keyPairGenerator.initialize(256);
            keyPair = keyPairGenerator.genKeyPair();
            System.out.println("Generated 256-bit EC KeyPair!");
            keyPairGenerator.initialize(384);
            keyPair = keyPairGenerator.genKeyPair();
            System.out.println("Generated 384-bit EC KeyPair!");
            keyPairGenerator.initialize(521);
            keyPair = keyPairGenerator.genKeyPair();
            System.out.println("Generated 521-bit EC KeyPair!");
            System.out.println("TestKeyGen passed");
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

