/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.pkcs11.PK11SecureRandom;
import org.mozilla.jss.util.Password;

public class SymKeyGen {
    private CryptoToken token = null;
    byte[] plainText16Bytes = "Firefox   rules!".getBytes();
    byte[] plainText18Bytes = "Thunderbird rules!".getBytes();

    public SymmetricKey genPBEKey(PBEAlgorithm pBEAlgorithm, SymmetricKey.Type type, int n) throws Exception {
        SymmetricKey symmetricKey = null;
        KeyGenerator keyGenerator = this.token.getKeyGenerator(pBEAlgorithm);
        try {
            keyGenerator.initialize(n);
            throw new Exception("ERROR: Initializing PBE key with strength " + n + " succeeded");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Password password = new Password("passwd1".toCharArray());
            byte[] byArray = this.genSalt(pBEAlgorithm.getSaltLength());
            PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(password, byArray, 2);
            keyGenerator.initialize(pBEKeyGenParams);
            symmetricKey = keyGenerator.generate();
            if (symmetricKey.getType() != type) {
                throw new Exception("Wrong key type: " + symmetricKey.getType());
            }
            if (!symmetricKey.getOwningToken().equals(this.token)) {
                throw new Exception("wrong token");
            }
            if (symmetricKey.getStrength() != n) {
                throw new Exception("wrong strength: " + symmetricKey.getStrength());
            }
            return symmetricKey;
        }
    }

    public SymmetricKey genPBAKey(KeyGenAlgorithm keyGenAlgorithm, SymmetricKey.Type type, int n) throws Exception {
        SymmetricKey symmetricKey = null;
        KeyGenerator keyGenerator = this.token.getKeyGenerator(keyGenAlgorithm);
        try {
            keyGenerator.initialize(n);
            throw new Exception("ERROR: Initializing PBE key with strength " + n + " succeeded");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Password password = new Password("passwd1".toCharArray());
            byte[] byArray = this.genSalt(8);
            PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(password, byArray, 2);
            keyGenerator.initialize(pBEKeyGenParams);
            symmetricKey = keyGenerator.generate();
            if (symmetricKey.getType() != type) {
                throw new Exception("Wrong key type: " + symmetricKey.getType());
            }
            if (!symmetricKey.getOwningToken().equals(this.token)) {
                throw new Exception("wrong token");
            }
            if (symmetricKey.getStrength() != n) {
                throw new Exception("wrong strength: " + symmetricKey.getStrength());
            }
            return symmetricKey;
        }
    }

    public SymmetricKey genSymKey(KeyGenAlgorithm keyGenAlgorithm, SymmetricKey.Type type, int n, int n2) throws Exception {
        SymmetricKey symmetricKey = null;
        KeyGenerator keyGenerator = this.token.getKeyGenerator(keyGenAlgorithm);
        if (keyGenAlgorithm == KeyGenAlgorithm.AES || keyGenAlgorithm == KeyGenAlgorithm.RC4 || keyGenAlgorithm == KeyGenAlgorithm.RC2) {
            keyGenerator.initialize(n);
        }
        if ((symmetricKey = keyGenerator.generate()).getType() != type) {
            throw new Exception("wrong algorithm");
        }
        if (!symmetricKey.getOwningToken().equals(this.token)) {
            throw new Exception("wrong token");
        }
        if (symmetricKey.getStrength() != n) {
            throw new Exception("wrong strength");
        }
        byte[] byArray = symmetricKey.getKeyData();
        if (byArray.length != n2) {
            throw new Exception("key data wrong length: " + byArray.length);
        }
        return symmetricKey;
    }

    public boolean cipherTest(SymmetricKey symmetricKey, EncryptionAlgorithm encryptionAlgorithm) throws Exception {
        Object object;
        byte[] byArray;
        boolean bl = false;
        int n = 0;
        AlgorithmParameterSpec algorithmParameterSpec = null;
        Cipher cipher = null;
        cipher = this.token.getCipherContext(encryptionAlgorithm);
        byte[] byArray2 = this.plainText18Bytes;
        if ((encryptionAlgorithm.getMode() == EncryptionAlgorithm.Mode.CBC || encryptionAlgorithm.getMode() == EncryptionAlgorithm.Mode.ECB) && encryptionAlgorithm.getPadding() == EncryptionAlgorithm.Padding.NONE) {
            byArray2 = this.plainText16Bytes;
        }
        if ((n = encryptionAlgorithm.getIVLength()) != 0) {
            algorithmParameterSpec = this.genIV(n);
        }
        if (symmetricKey.getType() == SymmetricKey.RC2) {
            byArray = new byte[n];
            object = new PK11SecureRandom();
            ((PK11SecureRandom)object).nextBytes(byArray);
            algorithmParameterSpec = new RC2ParameterSpec(40, byArray);
        }
        if (algorithmParameterSpec == null) {
            cipher.initEncrypt(symmetricKey);
        } else {
            cipher.initEncrypt(symmetricKey, algorithmParameterSpec);
        }
        byArray = cipher.doFinal(byArray2);
        if (n == 0) {
            cipher.initDecrypt(symmetricKey);
        } else {
            cipher.initDecrypt(symmetricKey, algorithmParameterSpec);
        }
        object = cipher.doFinal(byArray);
        if (((Object)object).length != byArray2.length) {
            throw new Exception("Recovered plaintext has different length (" + ((Object)object).length + ") than original (" + byArray2.length + ")");
        }
        if (!Arrays.equals(byArray2, (byte[])object)) {
            throw new Exception("ERROR: unable to recover plaintext");
        }
        bl = true;
        return bl;
    }

    private SymKeyGen(String string) {
        try {
            CryptoManager.initialize(string);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            this.token = cryptoManager.getInternalCryptoToken();
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            alreadyInitializedException.printStackTrace();
        }
        catch (CertDatabaseException certDatabaseException) {
            certDatabaseException.printStackTrace();
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            notInitializedException.printStackTrace();
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
        }
        catch (KeyDatabaseException keyDatabaseException) {
            keyDatabaseException.printStackTrace();
        }
    }

    public IVParameterSpec genIV(int n) throws Exception {
        byte[] byArray = new byte[n];
        PK11SecureRandom pK11SecureRandom = new PK11SecureRandom();
        pK11SecureRandom.nextBytes(byArray);
        return new IVParameterSpec(byArray);
    }

    public byte[] genSalt(int n) throws Exception {
        byte[] byArray = new byte[n];
        PK11SecureRandom pK11SecureRandom = new PK11SecureRandom();
        pK11SecureRandom.nextBytes(byArray);
        return byArray;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.out.println("Usage: java org.mozilla.jss.tests.SymKeyGen <dbdir>");
                System.exit(1);
            }
            SymKeyGen symKeyGen = new SymKeyGen(stringArray[0]);
            SymmetricKey symmetricKey = null;
            symmetricKey = symKeyGen.genSymKey(KeyGenAlgorithm.DES, SymmetricKey.DES, 56, 8);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_CBC_PAD);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_ECB);
            System.out.println("DES key and cipher tests correct");
            symmetricKey = symKeyGen.genSymKey(KeyGenAlgorithm.DES3, SymmetricKey.DES3, 168, 24);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES3_CBC_PAD);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES3_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES3_ECB);
            System.out.println("DESede key and cipher tests correct");
            symmetricKey = symKeyGen.genSymKey(KeyGenAlgorithm.AES, SymmetricKey.AES, 128, 16);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.AES_128_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.AES_128_ECB);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.AES_128_CBC_PAD);
            System.out.println("AES 128 key and cipher tests correct");
            symmetricKey = symKeyGen.genSymKey(KeyGenAlgorithm.AES, SymmetricKey.AES, 192, 24);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.AES_192_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.AES_192_ECB);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.AES_192_CBC_PAD);
            System.out.println("AES 192 key and cipher tests correct");
            symmetricKey = symKeyGen.genSymKey(KeyGenAlgorithm.AES, SymmetricKey.AES, 256, 32);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.AES_256_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.AES_256_ECB);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.AES_256_CBC_PAD);
            System.out.println("AES 256 key and cipher tests correct");
            symmetricKey = symKeyGen.genSymKey(KeyGenAlgorithm.RC2, SymmetricKey.RC2, 40, 5);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.RC2_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.RC2_CBC_PAD);
            System.out.println("RC2 key and cipher tests correct");
            symmetricKey = symKeyGen.genSymKey(KeyGenAlgorithm.RC4, SymmetricKey.RC4, 128, 16);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.RC4);
            System.out.println("RC4 key and cipher tests correct");
            symmetricKey = symKeyGen.genPBEKey(PBEAlgorithm.PBE_MD2_DES_CBC, SymmetricKey.DES, 56);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_CBC_PAD);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_ECB);
            symmetricKey = symKeyGen.genPBEKey(PBEAlgorithm.PBE_MD5_DES_CBC, SymmetricKey.DES, 56);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_CBC_PAD);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_ECB);
            symmetricKey = symKeyGen.genPBEKey(PBEAlgorithm.PBE_SHA1_DES_CBC, SymmetricKey.DES, 64);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_CBC_PAD);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES_ECB);
            symmetricKey = symKeyGen.genPBEKey(PBEAlgorithm.PBE_SHA1_DES3_CBC, SymmetricKey.DES3, 168);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES3_CBC_PAD);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES3_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.DES3_ECB);
            symmetricKey = symKeyGen.genPBEKey(PBEAlgorithm.PBE_SHA1_RC2_40_CBC, SymmetricKey.RC2, 40);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.RC2_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.RC2_CBC_PAD);
            symmetricKey = symKeyGen.genPBEKey(PBEAlgorithm.PBE_SHA1_RC2_128_CBC, SymmetricKey.RC2, 128);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.RC2_CBC);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.RC2_CBC_PAD);
            symmetricKey = symKeyGen.genPBEKey(PBEAlgorithm.PBE_SHA1_RC4_40, SymmetricKey.RC4, 40);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.RC4);
            symmetricKey = symKeyGen.genPBEKey(PBEAlgorithm.PBE_SHA1_RC4_128, SymmetricKey.RC4, 128);
            symKeyGen.cipherTest(symmetricKey, EncryptionAlgorithm.RC4);
            System.out.println("Password Based key generation tests correct");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class alg {
        public KeyGenAlgorithm sAlg;
        public SymmetricKey.Type keyType;
        public int size;
        public int blkSize;
        List ciphers = new LinkedList();

        public alg(KeyGenAlgorithm keyGenAlgorithm, SymmetricKey.Type type, int n, int n2) {
            this.sAlg = keyGenAlgorithm;
            this.keyType = type;
            this.size = n;
            this.blkSize = n2;
        }

        public void setEncAlgs(List list) {
            this.ciphers = list;
        }
    }
}

