/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;

public class KeyWrapping {
    public static void main(String[] stringArray) {
        try {
            CryptoManager.initialize(".");
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalCryptoToken();
            CryptoToken cryptoToken2 = cryptoManager.getInternalKeyStorageToken();
            KeyGenerator keyGenerator = cryptoToken.getKeyGenerator(KeyGenAlgorithm.DES);
            KeyGenerator keyGenerator2 = cryptoToken2.getKeyGenerator(KeyGenAlgorithm.DES3);
            SymmetricKey symmetricKey = keyGenerator.generate();
            SymmetricKey symmetricKey2 = keyGenerator.generate();
            SymmetricKey symmetricKey3 = keyGenerator2.generate();
            SymmetricKey symmetricKey4 = keyGenerator2.clone(symmetricKey);
            byte[] byArray = new byte[]{115, 36, 81, 72, 50, -121, 35, 51, 101};
            byte[] byArray2 = Cipher.pad(byArray, EncryptionAlgorithm.DES_ECB.getBlockSize());
            System.out.println("plaintext length is " + byArray2.length);
            Cipher cipher = cryptoToken.getCipherContext(EncryptionAlgorithm.DES_ECB);
            cipher.initEncrypt(symmetricKey);
            byte[] byArray3 = cipher.doFinal(byArray2);
            System.out.println("ciphertext length is " + byArray3.length);
            KeyWrapper keyWrapper = cryptoToken.getKeyWrapper(KeyWrapAlgorithm.DES_ECB);
            keyWrapper.initWrap(symmetricKey2, null);
            byte[] byArray4 = keyWrapper.wrap(symmetricKey);
            keyWrapper.initUnwrap(symmetricKey2, null);
            SymmetricKey symmetricKey5 = keyWrapper.unwrapSymmetric(byArray4, SymmetricKey.DES, SymmetricKey.Usage.DECRYPT, 0);
            Cipher cipher2 = cryptoToken.getCipherContext(EncryptionAlgorithm.DES_ECB);
            cipher2.initDecrypt(symmetricKey5);
            byte[] byArray5 = cipher2.doFinal(byArray3);
            System.out.println("Decrypted " + byArray5.length + " bytes");
            byte[] byArray6 = Cipher.unPad(byArray5, EncryptionAlgorithm.DES_ECB.getBlockSize());
            System.out.println("plaintext:");
            KeyWrapping.displayByteArray(byArray);
            System.out.println("ciphertext:");
            KeyWrapping.displayByteArray(byArray3);
            System.out.println("recovered:");
            KeyWrapping.displayByteArray(byArray6);
            keyWrapper = cryptoToken2.getKeyWrapper(KeyWrapAlgorithm.DES3_CBC_PAD);
            IVParameterSpec iVParameterSpec = new IVParameterSpec(byArray6);
            keyWrapper.initWrap(symmetricKey3, (AlgorithmParameterSpec)iVParameterSpec);
            KeyPairGenerator keyPairGenerator = cryptoToken2.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            keyPairGenerator.initialize(512);
            keyPairGenerator.temporaryPairs(true);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = (PrivateKey)keyPair.getPrivate();
            byArray4 = keyWrapper.wrap(privateKey);
            System.out.println("Original key:");
            KeyWrapping.displayByteArray(privateKey.getUniqueID());
            privateKey = null;
            keyPair = null;
            keyWrapper.initUnwrap(symmetricKey3, (AlgorithmParameterSpec)iVParameterSpec);
            PrivateKey privateKey2 = keyWrapper.unwrapTemporaryPrivate(byArray4, PrivateKey.RSA, publicKey);
            System.out.println("New key:");
            KeyWrapping.displayByteArray(privateKey2.getUniqueID());
            keyWrapper = cryptoToken2.getKeyWrapper(KeyWrapAlgorithm.RSA);
            keyWrapper.initWrap(publicKey, null);
            byArray4 = keyWrapper.wrap(symmetricKey4);
            keyWrapper.initUnwrap(privateKey2, null);
            symmetricKey5 = keyWrapper.unwrapSymmetric(byArray4, SymmetricKey.DES, SymmetricKey.Usage.DECRYPT, 0);
            symmetricKey5 = keyGenerator.clone(symmetricKey5);
            cipher2 = cryptoToken.getCipherContext(EncryptionAlgorithm.DES_ECB);
            cipher2.initDecrypt(symmetricKey5);
            byArray6 = cipher2.doFinal(byArray3);
            System.out.println("Recovered again:");
            KeyWrapping.displayByteArray(Cipher.unPad(byArray6, 8));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void displayByteArray(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            System.out.print(Integer.toHexString(byArray[n] & 0xFF) + " ");
            if (n % 26 == 25) {
                System.out.println("");
            }
            ++n;
        }
        System.out.println("");
    }
}

