/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.TestCertApprovalCallback;
import org.mozilla.jss.ssl.TestClientCertificateSelectionCallback;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class JSS_SelfServClient {
    private String clientCertNick = null;
    private String serverHost = "localhost";
    private boolean TestCertCallBack = false;
    private boolean success = true;
    private int fCipher = -1;
    private int port = 29754;
    private String EOF = "test";
    private boolean handshakeCompleted = false;
    private CryptoManager cm = null;
    private CryptoToken tok = null;
    private PasswordCallback cb = null;
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";

    public void setCipher(int n) {
        this.fCipher = n;
    }

    public void setHostName(String string) {
        this.serverHost = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setPasswordFile(String string) {
        this.fPasswordFile = string;
    }

    public void setCertDbPath(String string) {
        this.fCertDbPath = string;
    }

    public void setTestCertCallback(boolean bl) {
        this.TestCertCallBack = bl;
    }

    public void setClientCertNick(String string) {
        this.clientCertNick = string;
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeCompleted;
    }

    public void setHandshakeCompleted() {
        this.handshakeCompleted = true;
    }

    public void clearHandshakeCompleted() {
        this.handshakeCompleted = false;
    }

    public void setEOF(String string) {
        this.EOF = string;
    }

    public void doIt(int n) throws Exception {
        try {
            CryptoManager.initialize(this.fCertDbPath);
            this.cm = CryptoManager.getInstance();
            this.tok = this.cm.getInternalKeyStorageToken();
            this.cb = new FilePasswordCallback(this.fPasswordFile);
            this.tok.login(this.cb);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Constants.debug_level >= 3) {
            System.out.println("client about to connect...");
        }
        String string = InetAddress.getByName(this.serverHost).getHostAddress();
        if (Constants.debug_level >= 3) {
            System.out.println("the host " + this.serverHost + " and the address " + string);
        }
        TestCertApprovalCallback testCertApprovalCallback = new TestCertApprovalCallback();
        TestClientCertificateSelectionCallback testClientCertificateSelectionCallback = new TestClientCertificateSelectionCallback();
        SSLSocket sSLSocket = null;
        if (this.TestCertCallBack) {
            if (Constants.debug_level >= 3) {
                System.out.println("calling approvalCallBack");
            }
            sSLSocket = new SSLSocket(InetAddress.getByName(string), this.port, null, 0, (SSLCertificateApprovalCallback)new TestCertApprovalCallback(), null);
        } else {
            if (Constants.debug_level >= 3) {
                System.out.println("NOT calling approvalCallBack");
            }
            sSLSocket = new SSLSocket(InetAddress.getByName(string), this.port);
        }
        if (Constants.debug_level >= 3) {
            System.out.println("clientCertNick=" + this.clientCertNick);
        }
        sSLSocket.setClientCertNickname(this.clientCertNick);
        if (this.fCipher != -1) {
            sSLSocket.setCipherPreference(this.fCipher, true);
        }
        if (Constants.debug_level >= 3) {
            System.out.println("Client specified cert by nickname");
            System.out.println("client connected");
        }
        sSLSocket.addHandshakeCompletedListener(new HandshakeListener("client", this));
        sSLSocket.forceHandshake();
        sSLSocket.setSoTimeout(10000);
        readWriteThread readWriteThread2 = new readWriteThread(sSLSocket, n);
        readWriteThread2.start();
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static void main(String[] stringArray) {
        String string = "JSSCATestCert";
        String string2 = null;
        String string3 = "localhost";
        int n = 29754;
        int n2 = 10;
        String string4 = null;
        String string5 = null;
        String string6 = "\nUSAGE:\njava org.mozilla.jss.tests.JSS_SelfServClient [# sockets] [JSS cipher integer]\n\nOptional:\n[certdb path] [password file] [server host] [server port]\n";
        try {
            if (stringArray.length <= 0 || stringArray[0].toLowerCase().equals("-h")) {
                System.out.println(string6);
                System.exit(0);
            } else {
                n2 = new Integer(stringArray[0]);
                System.out.println("Socket Counter = " + n2);
            }
            string2 = stringArray[1];
            System.out.println("Test Cipher    = " + string2);
            if (stringArray.length >= 3) {
                string4 = stringArray[2];
                string5 = stringArray[3];
            }
            if (stringArray.length >= 5) {
                string3 = stringArray[4];
                n = new Integer(stringArray[5]);
            }
        }
        catch (Exception exception) {
            System.out.println("Unknown exception : " + exception.getMessage());
        }
        System.out.println("Client connecting to server ...");
        int n3 = 0;
        while (n3 < n2) {
            JSS_SelfServClient jSS_SelfServClient = new JSS_SelfServClient();
            try {
                if (!string3.equals("localhost")) {
                    jSS_SelfServClient.setHostName(string3);
                }
                if (n != 29754) {
                    jSS_SelfServClient.setPort(n);
                }
                jSS_SelfServClient.setTestCertCallback(true);
                jSS_SelfServClient.setClientCertNick(string);
                if (string4 != null) {
                    jSS_SelfServClient.setCertDbPath(string4);
                }
                if (string5 != null) {
                    jSS_SelfServClient.setPasswordFile(string5);
                }
                if (string2 != null) {
                    try {
                        jSS_SelfServClient.setCipher(new Integer(string2));
                        jSS_SelfServClient.setEOF(string2);
                        jSS_SelfServClient.doIt(n3);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        exception.printStackTrace();
                        System.exit(1);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
                System.exit(1);
            }
            ++n3;
        }
        System.out.println("All " + n2 + " sockets created. Exiting");
        try {
            Thread.currentThread();
            Thread.sleep(300000L);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        System.exit(0);
    }

    public class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SelfServClient boss;

        public HandshakeListener(String string, JSS_SelfServClient jSS_SelfServClient2) {
            this.who = string;
            this.boss = jSS_SelfServClient2;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
                if (Constants.debug_level >= 3) {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
            JSS_SelfServClient.this.setHandshakeCompleted();
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket clientSock = null;
        private int socketCntr = 0;

        public readWriteThread(SSLSocket sSLSocket, int n) {
            this.clientSock = sSLSocket;
            this.socketCntr = n;
        }

        public void run() {
            try {
                Object var1_1 = null;
                String string = null;
                InputStream inputStream = this.clientSock.getInputStream();
                OutputStream outputStream = this.clientSock.getOutputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
                while (true) {
                    System.out.println("Writing hi to server on thread " + this.socketCntr);
                    printWriter.print("Client saying hi to server\n");
                    printWriter.flush();
                    string = bufferedReader.readLine();
                    System.out.println("Received " + string + " on thread " + this.socketCntr);
                    Thread.sleep(1000L);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                System.out.println("Exception caught\n" + socketTimeoutException.getMessage());
                socketTimeoutException.printStackTrace();
                System.exit(1);
            }
            catch (IOException iOException) {
                System.out.println("Exception caught\n" + iOException.getMessage());
                iOException.printStackTrace();
                System.exit(1);
            }
            catch (Exception exception) {
                System.out.println("Exception caught\n" + exception.getMessage());
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

