/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.TestCertApprovalCallback;
import org.mozilla.jss.ssl.TestClientCertificateSelectionCallback;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class JSS_SSLClient {
    private String clientCertNick = null;
    private String serverHost = null;
    private boolean TestCertCallBack = false;
    private boolean testBypass = false;
    private boolean success = true;
    private int fCipher = -1;
    private int port = 29753;
    private String EOF = "test";
    private boolean handshakeCompleted = false;
    private CryptoManager cm = null;
    private CryptoToken tok = null;
    private PasswordCallback cb = null;
    private String fPasswordFile = "passwords";
    private static String fCertDbPath = ".";

    public JSS_SSLClient() {
        try {
            CryptoManager.initialize(fCertDbPath);
            this.cm = CryptoManager.getInstance();
            this.tok = this.cm.getInternalKeyStorageToken();
            this.cb = new FilePasswordCallback(this.fPasswordFile);
            this.tok.login(this.cb);
        }
        catch (Exception exception) {}
    }

    public void setCipher(int n) {
        this.fCipher = n;
    }

    public void setHostName(String string) {
        this.serverHost = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setPasswordFile(String string) {
        this.fPasswordFile = string;
    }

    public static void setCertDbPath(String string) {
        fCertDbPath = string;
    }

    public static String getCertDbPath() {
        return fCertDbPath;
    }

    public void setBypass(boolean bl) {
        this.testBypass = bl;
    }

    public void setTestCertCallback(boolean bl) {
        this.TestCertCallBack = bl;
    }

    public void setClientCertNick(String string) {
        this.clientCertNick = string;
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeCompleted;
    }

    public void setHandshakeCompleted() {
        this.handshakeCompleted = true;
    }

    public void clearHandshakeCompleted() {
        this.handshakeCompleted = false;
    }

    public void setEOF(String string) {
        this.EOF = string;
    }

    public void doIt() throws Exception {
        if (Constants.debug_level >= 3) {
            System.out.println("client about to connect...");
        }
        String string = InetAddress.getByName(this.serverHost).getHostAddress();
        if (Constants.debug_level >= 3) {
            System.out.println("the host " + this.serverHost + " and the address " + string);
        }
        TestCertApprovalCallback testCertApprovalCallback = new TestCertApprovalCallback();
        TestClientCertificateSelectionCallback testClientCertificateSelectionCallback = new TestClientCertificateSelectionCallback();
        SSLSocket sSLSocket = null;
        try {
            if (this.TestCertCallBack) {
                if (Constants.debug_level >= 3) {
                    System.out.println("calling approvalCallBack");
                }
                sSLSocket = new SSLSocket(InetAddress.getByName(string), this.port, null, 0, (SSLCertificateApprovalCallback)new TestCertApprovalCallback(), null);
            } else {
                if (Constants.debug_level >= 3) {
                    System.out.println("NOT calling approvalCallBack");
                }
                sSLSocket = new SSLSocket(InetAddress.getByName(string), this.port);
            }
        }
        catch (Exception exception) {
            if (Constants.debug_level > 3) {
                System.out.println("Could not connect to server socket\n" + exception.getMessage());
                exception.printStackTrace();
            }
            System.exit(0);
        }
        if (this.testBypass) {
            sSLSocket.bypassPKCS11(true);
        }
        if (Constants.debug_level >= 3) {
            System.out.println("clientCertNick=" + this.clientCertNick);
        }
        sSLSocket.setClientCertNickname(this.clientCertNick);
        if (this.fCipher != -1) {
            sSLSocket.setCipherPreference(this.fCipher, true);
        }
        if (Constants.debug_level >= 3) {
            System.out.println("Client specified cert by nickname");
            System.out.println("client connected ...");
        }
        sSLSocket.setSoTimeout(10000);
        sSLSocket.addHandshakeCompletedListener(new HandshakeListener("client", this));
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(sSLSocket.getOutputStream())));
        printWriter.println(this.EOF + "\n");
        printWriter.flush();
        if (printWriter.checkError()) {
            System.out.println("JSS_SSLClient: java.io.PrintWriter error");
        }
        try {
            sSLSocket.close();
        }
        catch (Exception exception) {}
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static void main(String[] stringArray) {
        block30: {
            String string = "JSSCATestCert";
            int n = 0;
            String string2 = "localhost";
            int n2 = 29753;
            String string3 = null;
            String string4 = "passwords";
            boolean bl = false;
            String string5 = "USAGE:\njava org.mozilla.jss.tests.JSS_SSLClient <cert db path> <password file>\n [server host] [server port] [bypass] [test cipher] ";
            try {
                if (stringArray[0].toLowerCase().equals("-h") || stringArray.length < 2) {
                    System.out.println(string5);
                    System.exit(1);
                }
                if (stringArray.length >= 2) {
                    string3 = stringArray[0];
                    string4 = stringArray[1];
                }
                if (string3 != null) {
                    JSS_SSLClient.setCertDbPath(string3);
                }
                if (stringArray.length >= 3) {
                    string2 = stringArray[2];
                    System.out.println("testhost" + string2);
                }
                if (stringArray.length >= 4) {
                    n2 = new Integer(stringArray[3]);
                    System.out.println("using port: " + n2);
                }
                if (stringArray.length >= 5 && stringArray[4].equalsIgnoreCase("bypass")) {
                    bl = true;
                }
                if (stringArray.length == 6) {
                    n = new Integer(stringArray[5]);
                    System.out.println("testCipher " + n);
                }
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                System.out.println("Exception caught " + exception.toString());
                exception.printStackTrace();
            }
            JSS_SSLClient jSS_SSLClient = new JSS_SSLClient();
            try {
                if (!string2.equals("localhost")) {
                    jSS_SSLClient.setHostName(string2);
                }
                if (n2 != 29753) {
                    jSS_SSLClient.setPort(n2);
                }
                jSS_SSLClient.setBypass(bl);
                jSS_SSLClient.setTestCertCallback(true);
                jSS_SSLClient.setClientCertNick(string);
                if (string4 != null) {
                    jSS_SSLClient.setPasswordFile(string4);
                }
                if (n != 0) {
                    try {
                        jSS_SSLClient.setCipher(n);
                        jSS_SSLClient.setEOF(new Integer(n).toString());
                        jSS_SSLClient.doIt();
                        while (!jSS_SSLClient.isHandshakeCompleted()) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                System.out.println("Thread Interrupted ...\n");
                            }
                        }
                        jSS_SSLClient.clearHandshakeCompleted();
                    }
                    catch (Exception exception) {
                        System.out.println("Exception caught " + exception.getMessage());
                        exception.printStackTrace();
                        System.exit(1);
                    }
                    jSS_SSLClient.setCipher(n);
                    jSS_SSLClient.setEOF("null");
                    jSS_SSLClient.doIt();
                    while (!jSS_SSLClient.isHandshakeCompleted()) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            System.out.println("Thread Interrupted ...\n");
                        }
                    }
                    jSS_SSLClient.clearHandshakeCompleted();
                    break block30;
                }
                int n3 = 0;
                while (n3 < Constants.jssCipherSuites.length) {
                    try {
                        jSS_SSLClient.setCipher(Constants.jssCipherSuites[n3]);
                        jSS_SSLClient.setEOF(new Integer(n3).toString());
                        jSS_SSLClient.doIt();
                        while (!jSS_SSLClient.isHandshakeCompleted()) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                System.out.println("Thread Interrupted ...\n");
                            }
                        }
                        jSS_SSLClient.clearHandshakeCompleted();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n3;
                }
                jSS_SSLClient.setCipher(1);
                jSS_SSLClient.setEOF("null");
                jSS_SSLClient.doIt();
                while (!jSS_SSLClient.isHandshakeCompleted()) {
                }
                jSS_SSLClient.clearHandshakeCompleted();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    public class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SSLClient boss;

        public HandshakeListener(String string, JSS_SSLClient jSS_SSLClient2) {
            this.who = string;
            this.boss = jSS_SSLClient2;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent) {
            try {
                String string = this.who + " got a completed handshake ";
                SSLSecurityStatus sSLSecurityStatus = sSLHandshakeCompletedEvent.getStatus();
                string = sSLSecurityStatus.isSecurityOn() ? string + "(security is ON)" : string + "(security is OFF)";
                if (Constants.debug_level >= 3) {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.boss.setFailure();
            }
            JSS_SSLClient.this.setHandshakeCompleted();
        }
    }
}

