/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.mozilla.jss.tests.Constants;

public class JSSE_SSLServer {
    private static int DefaultServerPort;
    private static int port;
    private static String type;
    private static String keystoreLoc;
    private static boolean bClientAuth;
    private static Vector supportedCiphers;

    public static void setKeystoreLoc(String string) {
        keystoreLoc = string + "/" + keystoreLoc;
    }

    public static String getKeystoreLoc() {
        return keystoreLoc;
    }

    public static void main(String[] stringArray) {
        try {
            new JSSE_SSLServer().startSSLServer(stringArray);
        }
        catch (Exception exception) {}
    }

    public void startSSLServer(String[] stringArray) throws Exception {
        String string = "keystore.pfx";
        if (stringArray.length <= 1) {
            System.out.println("USAGE: java JSSE_SSLServer [port] [TLS | SSLv3 [true]]");
            System.out.println("[keystore location]");
            System.out.println("\nIf the second argument is TLS, it will start as a\nTLS server, otherwise, it will be started in SSLv3 mode.\nIf the third argument is true,it will require\nclient authentication as well.");
            System.exit(1);
        }
        if (stringArray.length >= 1) {
            port = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length >= 2) {
            type = stringArray[1];
        }
        if (stringArray.length >= 3 && stringArray[2].equals("true")) {
            bClientAuth = true;
        }
        if (stringArray.length >= 4 && (string = stringArray[3]) != null) {
            JSSE_SSLServer.setKeystoreLoc(string);
        }
        System.out.println("using port: " + port);
        System.out.println("mode type " + type + (bClientAuth ? "true" : "false"));
        System.out.println("keystoreLoc" + string);
        try {
            SSLServerSocketFactory sSLServerSocketFactory = JSSE_SSLServer.getServerSocketFactory(type);
            if (sSLServerSocketFactory != null) {
                SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(port);
                sSLServerSocket.setSoTimeout(15000);
                if (System.getProperty("java.version").indexOf("1.4") != -1) {
                    System.out.println("*** Using J2SE 1.4.x ***");
                    sSLServerSocket.setEnabledCipherSuites(Constants.sslciphersarray_jdk142);
                } else {
                    System.out.println("*** Using J2SE 1.5.x ***");
                    sSLServerSocket.setEnabledCipherSuites(Constants.sslciphersarray_jdk150);
                }
                sSLServerSocket.setNeedClientAuth(bClientAuth);
                JSSE_SSLServer jSSE_SSLServer = new JSSE_SSLServer();
                try {
                    while (true) {
                        Socket socket = sSLServerSocket.accept();
                        readWriteThread readWriteThread2 = new readWriteThread(socket);
                        readWriteThread2.start();
                    }
                }
                catch (IOException iOException) {
                    if (Constants.debug_level > 3) {
                        System.out.println("Exception caught in SSLServerSocket.accept():" + iOException.getMessage());
                    }
                    try {
                        sSLServerSocket.close();
                    }
                    catch (Exception exception) {}
                }
            } else if (System.getProperty("java.vendor").equals("IBM Corporation")) {
                System.out.println("Using IBM JDK: Cannot load keystore due to strong security encryption settings\nwith limited Jurisdiction policy files :\n http://www-1.ibm.com/support/docview.wss?uid=swg21169931");
                System.exit(0);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to start JSSE_SSLServer: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        System.out.println("Server exiting");
        System.out.println("supportedCiphers.size      :" + (supportedCiphers.size() - 1));
        System.out.println("Constants.jssCiphersSuites :" + Constants.jssCipherSuites.length);
        System.out.println("Constants.jssCiphersNames  :" + Constants.jssCipherNames.length);
        System.out.println("--------------------------------------------------------");
        System.out.println("Summary of JSS client to JSSE server communication test :");
        System.out.println("--------------------------------------------------------");
        int n = 0;
        while (n < supportedCiphers.size() - 1) {
            System.out.print("[" + (n + 1) + "]\t");
            int n2 = 0;
            while (n2 < Constants.jssCipherSuites.length - 1) {
                if (new Integer((String)supportedCiphers.elementAt(n)) == n2) {
                    int n3 = Constants.jssCipherSuites[n2];
                    System.out.print(" JSSC\t" + Constants.jssCipherNames[n2] + "\n");
                    System.out.flush();
                }
                ++n2;
            }
            ++n;
        }
        System.out.println("--------------------------------------------------------");
        System.out.flush();
        System.exit(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static SSLServerSocketFactory getServerSocketFactory(String string) {
        SSLContext sSLContext = null;
        KeyManagerFactory keyManagerFactory = null;
        KeyStore keyStore = null;
        char[] cArray = "netscape".toCharArray();
        SSLServerSocketFactory sSLServerSocketFactory = null;
        System.setProperty("javax.net.ssl.trustStore", System.getProperty("java.home") + "/jre/lib/security/cacerts");
        String string2 = "SunX509";
        String string3 = System.getProperty("java.vendor");
        if (string3.equals("IBM Corporation")) {
            string2 = "IbmX509";
        }
        if (string.equals("TLS")) {
            try {
                sSLContext = SSLContext.getInstance("TLS");
                keyManagerFactory = KeyManagerFactory.getInstance(string2);
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(new FileInputStream(JSSE_SSLServer.getKeystoreLoc()), cArray);
                keyManagerFactory.init(keyStore, cArray);
                sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
                return sSLContext.getServerSocketFactory();
            }
            catch (Exception exception) {
                if (Constants.debug_level <= 3) return sSLServerSocketFactory;
                exception.printStackTrace();
                return sSLServerSocketFactory;
            }
        }
        if (!string.equals("SSLv3")) return sSLServerSocketFactory;
        try {
            sSLContext = SSLContext.getInstance("SSLv3");
            keyManagerFactory = KeyManagerFactory.getInstance(string2);
            keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(JSSE_SSLServer.getKeystoreLoc()), cArray);
            keyManagerFactory.init(keyStore, cArray);
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
            return sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            if (Constants.debug_level <= 3) return sSLServerSocketFactory;
            exception.printStackTrace();
            return sSLServerSocketFactory;
        }
    }

    static {
        port = DefaultServerPort = 29753;
        type = "SSLv3";
        keystoreLoc = "keystore.pfx";
        bClientAuth = false;
        supportedCiphers = new Vector();
    }

    private class readWriteThread
    extends Thread {
        private Socket socket = null;
        private boolean socketListenStatus = true;

        public readWriteThread(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String string = null;
                Object var2_3 = null;
                InputStream inputStream = this.socket.getInputStream();
                OutputStream outputStream = this.socket.getOutputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
                while (this.socketListenStatus) {
                    try {
                        string = bufferedReader.readLine();
                        if (string.equals("null")) {
                            this.socketListenStatus = false;
                            if (Constants.debug_level > 3) {
                                System.out.println("Received " + string + " on socket");
                            }
                        } else if (string != null && !string.equals("skip")) {
                            Vector vector = supportedCiphers;
                            synchronized (vector) {
                                supportedCiphers.add(string);
                            }
                            if (Constants.debug_level > 3) {
                                System.out.println("Received " + string + " on socket");
                            }
                            this.socketListenStatus = false;
                        } else if (string == null) {
                            this.socketListenStatus = false;
                            if (Constants.debug_level > 3) {
                                System.out.println("Received " + string + " on socket");
                            }
                        }
                        this.socket.close();
                    }
                    catch (EOFException eOFException) {
                        if (Constants.debug_level > 3) {
                            System.out.println("EOFException caught in : " + eOFException.getMessage());
                        }
                        this.socketListenStatus = false;
                    }
                    catch (IOException iOException) {
                        if (Constants.debug_level > 3) {
                            System.out.println("IOException caught in : " + iOException.getMessage());
                        }
                        this.socketListenStatus = false;
                    }
                    catch (NullPointerException nullPointerException) {
                        if (Constants.debug_level > 3) {
                            System.out.println("NPException caught in : " + nullPointerException.getMessage());
                        }
                        this.socketListenStatus = false;
                        this.socketListenStatus = false;
                    }
                    catch (Exception exception) {
                        if (Constants.debug_level > 3) {
                            System.out.println("Exception caught in : " + exception.getMessage());
                        }
                        this.socketListenStatus = false;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception caught\n");
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

