/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.Assert;

class JSSCipherSpi
extends CipherSpi {
    private String algFamily = null;
    private String algMode = null;
    private String algPadding = null;
    CryptoToken token = null;
    private Cipher cipher = null;
    private EncryptionAlgorithm encAlg = null;
    private KeyWrapper wrapper = null;
    private KeyWrapAlgorithm wrapAlg = null;
    private AlgorithmParameterSpec params = null;
    private int blockSize;
    private int keyStrength;
    private static final NoAlgParams noAlgParams = new NoAlgParams();
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    private JSSCipherSpi() {
    }

    protected JSSCipherSpi(String string) {
        this.algFamily = string;
        this.token = TokenSupplierManager.getTokenSupplier().getThreadToken();
    }

    public void engineSetMode(String string) {
        this.algMode = string;
    }

    public void engineSetPadding(String string) {
        this.algPadding = string;
    }

    private static SecretKey importKey(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            SecretKey secretKey = (SecretKey)key;
            SecretKeyFactory secretKeyFactory = null;
            try {
                secretKeyFactory = SecretKeyFactory.getInstance(secretKey.getAlgorithm(), "Mozilla-JSS");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException("Unable to translate key with Algorithm" + key.getAlgorithm());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new InvalidKeyException("Unable to find provider, this should not happen");
            }
            return secretKeyFactory.translateKey(secretKey);
        }
        throw new InvalidKeyException("Invalid key type: " + key.getClass().getName());
    }

    public void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block25: {
            try {
                this.cipher = null;
                this.wrapper = null;
                this.params = algorithmParameterSpec;
                if (this.algFamily == null) {
                    throw new InvalidAlgorithmParameterException("incorrectly specified algorithm");
                }
                if (n != 1 && n != 2 && n != 3 && n != 4) {
                    throw new InvalidKeyException("Invalid opmode");
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.algFamily);
                if (this.algMode != null) {
                    stringBuffer.append('/');
                    stringBuffer.append(this.algMode);
                }
                if (this.algPadding != null) {
                    stringBuffer.append('/');
                    stringBuffer.append(this.algPadding);
                }
                if (n == 1 || n == 2) {
                    if (!(key instanceof SecretKeyFacade)) {
                        key = JSSCipherSpi.importKey(key);
                    }
                    SymmetricKey symmetricKey = ((SecretKeyFacade)key).key;
                    this.keyStrength = symmetricKey.getStrength();
                    this.encAlg = EncryptionAlgorithm.lookup(this.algFamily, this.algMode, this.algPadding, this.keyStrength);
                    this.blockSize = this.encAlg.getBlockSize();
                    if (!this.token.doesAlgorithm(this.encAlg)) {
                        throw new NoSuchAlgorithmException(this.encAlg.toString() + " is not supported by this token " + this.token.getName());
                    }
                    this.cipher = this.token.getCipherContext(this.encAlg);
                    if (n == 1) {
                        if (this.params == noAlgParams) {
                            this.params = this.generateAlgParams(this.encAlg, this.blockSize);
                        }
                        this.cipher.initEncrypt(symmetricKey, this.params);
                    } else if (n == 2) {
                        if (this.params == noAlgParams) {
                            this.params = null;
                        }
                        this.cipher.initDecrypt(symmetricKey, this.params);
                    }
                    break block25;
                }
                Assert._assert(n == 3 || n == 4);
                this.wrapAlg = KeyWrapAlgorithm.fromString(stringBuffer.toString());
                this.blockSize = this.wrapAlg.getBlockSize();
                this.wrapper = this.token.getKeyWrapper(this.wrapAlg);
                if (this.params == noAlgParams) {
                    if (n == 3) {
                        this.params = this.generateAlgParams(this.wrapAlg, this.blockSize);
                    } else {
                        Assert._assert(n == 4);
                        this.params = null;
                    }
                }
                if (key instanceof PrivateKey) {
                    if (n != 4) {
                        throw new InvalidKeyException("Private key can only be used for unwrapping");
                    }
                    this.wrapper.initUnwrap((PrivateKey)key, this.params);
                    break block25;
                }
                if (key instanceof PublicKey) {
                    if (n != 3) {
                        throw new InvalidKeyException("Public key can only be used for wrapping");
                    }
                    this.wrapper.initWrap((PublicKey)key, this.params);
                    break block25;
                }
                if (key instanceof SecretKeyFacade) {
                    SecretKeyFacade secretKeyFacade = (SecretKeyFacade)key;
                    if (n == 3) {
                        this.wrapper.initWrap(secretKeyFacade.key, this.params);
                    } else {
                        Assert._assert(n == 4);
                        this.wrapper.initUnwrap(secretKeyFacade.key, this.params);
                    }
                    break block25;
                }
                throw new InvalidKeyException("Invalid key type: " + key.getClass().getName());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException(noSuchAlgorithmException.getMessage());
            }
            catch (TokenException tokenException) {
                throw new TokenRuntimeException(tokenException.getMessage());
            }
        }
    }

    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = null;
            if (this.algFamily.compareToIgnoreCase("RC2") == 0) {
                algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = JSSCipherSpi.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec);
            } else if (this.algMode.compareToIgnoreCase("CBC") == 0) {
                algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = JSSCipherSpi.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec);
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("Unknown Parameter Spec");
            }
            this.engineInit(n, key, algorithmParameterSpec, secureRandom);
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException(exception.getMessage());
        }
    }

    public void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, noAlgParams, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    private AlgorithmParameterSpec generateAlgParams(Algorithm algorithm, int n) throws InvalidKeyException {
        Class[] classArray = algorithm.getParameterClasses();
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (classArray == null) {
            return null;
        }
        byte[] byArray = new byte[n];
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            secureRandom.nextBytes(byArray);
        }
        catch (Exception exception) {
            Assert.notReached(exception.getMessage());
        }
        int n2 = 0;
        while (n2 < classArray.length) {
            if (classArray[n2].equals(class$javax$crypto$spec$IvParameterSpec == null ? JSSCipherSpi.class$("javax.crypto.spec.IvParameterSpec") : class$javax$crypto$spec$IvParameterSpec)) {
                algorithmParameterSpec = new IvParameterSpec(byArray);
                break;
            }
            if (classArray[n2].equals(class$javax$crypto$spec$RC2ParameterSpec == null ? JSSCipherSpi.class$("javax.crypto.spec.RC2ParameterSpec") : class$javax$crypto$spec$RC2ParameterSpec)) {
                algorithmParameterSpec = new RC2ParameterSpec(this.keyStrength, byArray);
                break;
            }
            ++n2;
        }
        return algorithmParameterSpec;
    }

    public int engineGetBlockSize() {
        return this.blockSize;
    }

    public byte[] engineGetIV() {
        if (this.params == null) {
            return null;
        }
        if (this.params instanceof IvParameterSpec) {
            return ((IvParameterSpec)this.params).getIV();
        }
        if (this.params instanceof RC2ParameterSpec) {
            return ((RC2ParameterSpec)this.params).getIV();
        }
        return null;
    }

    public AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            if (this.params instanceof IvParameterSpec || this.params instanceof RC2ParameterSpec) {
                algorithmParameters = AlgorithmParameters.getInstance(this.algFamily);
                algorithmParameters.init(this.params);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.notReached(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            Assert.notReached(invalidParameterSpecException.getMessage());
        }
        return algorithmParameters;
    }

    public int engineGetOutputSize(int n) {
        int n2 = this.blockSize - 1 + n;
        return (n2 / this.blockSize + 1) * this.blockSize;
    }

    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.cipher == null) {
            Assert.notReached();
            return null;
        }
        try {
            return this.cipher.update(byArray, n, n2);
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
    }

    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        byte[] byArray3 = this.engineUpdate(byArray, n, n2);
        if (byArray3.length < byArray2.length - n3) {
            throw new ShortBufferException(byArray3.length + " needed, " + (byArray2.length - n3) + " supplied");
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    public byte[] engineDoFinal(byte[] byArray, int n, int n2) throws javax.crypto.IllegalBlockSizeException, BadPaddingException {
        if (this.cipher == null) {
            Assert.notReached();
            return null;
        }
        try {
            if (byArray == null || n2 == 0) {
                return this.cipher.doFinal();
            }
            return this.cipher.doFinal(byArray, n, n2);
        }
        catch (IllegalStateException illegalStateException) {
            Assert.notReached();
            return null;
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new javax.crypto.IllegalBlockSizeException(illegalBlockSizeException.getMessage());
        }
        catch (org.mozilla.jss.crypto.BadPaddingException badPaddingException) {
            throw new BadPaddingException(badPaddingException.getMessage());
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
    }

    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, javax.crypto.IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        if (byArray3.length < byArray2.length - n3) {
            throw new ShortBufferException(byArray3.length + " needed, " + (byArray2.length - n3) + " supplied");
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    public byte[] engineWrap(Key key) throws javax.crypto.IllegalBlockSizeException, InvalidKeyException {
        if (this.wrapper == null) {
            Assert.notReached();
            return null;
        }
        try {
            if (key instanceof PrivateKey) {
                return this.wrapper.wrap((PrivateKey)key);
            }
            if (key instanceof SecretKeyFacade) {
                return this.wrapper.wrap(((SecretKeyFacade)key).key);
            }
            throw new InvalidKeyException("Unsupported key type: " + key.getClass().getName());
        }
        catch (IllegalStateException illegalStateException) {
            Assert.notReached();
            return null;
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
    }

    public Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.wrapper == null) {
            Assert.notReached();
            return null;
        }
        try {
            switch (n) {
                case 3: {
                    return this.engineUnwrapSecret(byArray, string);
                }
                case 2: {
                    return this.engineUnwrapPrivate(byArray, string);
                }
                case 1: {
                    throw new UnsupportedOperationException("Unable to unwrap public keys");
                }
            }
            throw new NoSuchAlgorithmException("Invalid key type: " + n);
        }
        catch (IllegalStateException illegalStateException) {
            Assert.notReached();
            return null;
        }
    }

    private Key engineUnwrapSecret(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            int n = string.indexOf(47);
            if (n != -1) {
                string = string.substring(0, n);
            }
            SymmetricKey.Type type = SymmetricKey.Type.fromName(string);
            SymmetricKey symmetricKey = this.wrapper.unwrapSymmetric(byArray, type, 0);
            return new SecretKeyFacade(symmetricKey);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + string);
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new NoSuchAlgorithmException("Invalid algorithm parameters" + invalidAlgorithmParameterException.getMessage());
        }
    }

    private Key engineUnwrapPrivate(byte[] byArray, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unwrapping private keys via the JCA interface is not supported: http://bugzilla.mozilla.org/show_bug.cgi?id=135328");
    }

    public int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PK11PrivKey) {
            return ((PK11PrivKey)key).getStrength();
        }
        if (key instanceof PK11PubKey) {
            try {
                byte[] byArray = ((PK11PubKey)key).getEncoded();
                SubjectPublicKeyInfo.Template template = new SubjectPublicKeyInfo.Template();
                SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)ASN1Util.decode(template, byArray);
                BIT_STRING bIT_STRING = subjectPublicKeyInfo.getSubjectPublicKey();
                return bIT_STRING.getBits().length - bIT_STRING.getPadCount();
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidKeyException("Exception while decoding public key: " + invalidBERException.getMessage());
            }
        }
        if (key instanceof SecretKeyFacade) {
            SymmetricKey symmetricKey = ((SecretKeyFacade)key).key;
            return symmetricKey.getLength();
        }
        key = JSSCipherSpi.importKey(key);
        SymmetricKey symmetricKey = ((SecretKeyFacade)key).key;
        return symmetricKey.getLength();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class RC2
    extends JSSCipherSpi {
        public RC2() {
            super("RC2");
        }
    }

    public static class RSA
    extends JSSCipherSpi {
        public RSA() {
            super("RSA");
        }
    }

    public static class RC4
    extends JSSCipherSpi {
        public RC4() {
            super("RC4");
        }
    }

    public static class AES
    extends JSSCipherSpi {
        public AES() {
            super("AES");
        }
    }

    public static class DESede
    extends JSSCipherSpi {
        public DESede() {
            super("DESede");
        }
    }

    public static class DES
    extends JSSCipherSpi {
        public DES() {
            super("DES");
        }
    }

    private static class NoAlgParams
    implements AlgorithmParameterSpec {
        private NoAlgParams() {
        }
    }
}

