/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Assert;

final class PK11KeyWrapper
implements KeyWrapper {
    private PK11Token token;
    private KeyWrapAlgorithm algorithm;
    private int state = 0;
    private AlgorithmParameterSpec parameters = null;
    private SymmetricKey symKey = null;
    private PrivateKey privKey = null;
    private PublicKey pubKey = null;
    private byte[] IV = null;
    private static final int UNINITIALIZED = 0;
    private static final int WRAP = 1;
    private static final int UNWRAP = 2;

    private PK11KeyWrapper() {
    }

    PK11KeyWrapper(PK11Token pK11Token, KeyWrapAlgorithm keyWrapAlgorithm) {
        this.token = pK11Token;
        this.algorithm = keyWrapAlgorithm;
    }

    public void initWrap(SymmetricKey symmetricKey, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initWrap(algorithmParameterSpec);
        this.checkWrapper(symmetricKey);
        this.symKey = symmetricKey;
    }

    public void initWrap(PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initWrap(algorithmParameterSpec);
        this.checkWrapper(publicKey);
        this.pubKey = publicKey;
    }

    public void initWrap() throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.algorithm != KeyWrapAlgorithm.PLAINTEXT) {
            throw new InvalidKeyException(this.algorithm + " requires a key");
        }
        this.reset();
        this.state = 1;
    }

    private void initWrap(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.reset();
        this.checkParams(algorithmParameterSpec);
        this.parameters = algorithmParameterSpec;
        this.state = 1;
    }

    public void initUnwrap(PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initUnwrap(algorithmParameterSpec);
        this.checkWrapper(privateKey);
        this.privKey = privateKey;
    }

    public void initUnwrap(SymmetricKey symmetricKey, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initUnwrap(algorithmParameterSpec);
        this.checkWrapper(symmetricKey);
        this.symKey = symmetricKey;
    }

    public void initUnwrap() throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.algorithm != KeyWrapAlgorithm.PLAINTEXT) {
            throw new InvalidKeyException(this.algorithm + " requires a key");
        }
        this.reset();
        this.state = 2;
    }

    private void initUnwrap(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.reset();
        this.checkParams(algorithmParameterSpec);
        this.parameters = algorithmParameterSpec;
        this.state = 2;
    }

    private void checkWrapper(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("Key is null");
        }
        if (!(publicKey instanceof PK11PubKey)) {
            throw new InvalidKeyException("Key is not a PKCS #11 key");
        }
        try {
            KeyType keyType = KeyType.getKeyTypeFromAlgorithm(this.algorithm);
            if (keyType == KeyType.RSA && !(publicKey instanceof RSAPublicKey) || keyType == KeyType.DSA && !(publicKey instanceof DSAPublicKey)) {
                throw new InvalidKeyException("Key is not the right type for this algorithm");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.notReached("unable to find algorithm from key type");
        }
    }

    private void checkWrapper(SymmetricKey symmetricKey) throws InvalidKeyException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key is null");
        }
        if (!symmetricKey.getOwningToken().equals(this.token)) {
            throw new InvalidKeyException("Key does not reside on the current token");
        }
        if (!(symmetricKey instanceof PK11SymKey)) {
            throw new InvalidKeyException("Key is not a PKCS #11 key");
        }
        try {
            if (((PK11SymKey)symmetricKey).getKeyType() != KeyType.getKeyTypeFromAlgorithm(this.algorithm)) {
                throw new InvalidKeyException("Key is not the right type for this algorithm");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.notReached("Unknown algorithm");
        }
    }

    private void checkWrapper(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("Key is null");
        }
        if (!privateKey.getOwningToken().equals(this.token)) {
            throw new InvalidKeyException("Key does not reside on the current token");
        }
        if (!(privateKey instanceof PK11PrivKey)) {
            throw new InvalidKeyException("Key is not a PKCS #11 key");
        }
        try {
            if (((PK11PrivKey)privateKey).getKeyType() != KeyType.getKeyTypeFromAlgorithm(this.algorithm)) {
                throw new InvalidKeyException("Key is not the right type for this algorithm");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.notReached("Unknown algorithm");
        }
    }

    private void checkParams(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!this.algorithm.isValidParameterObject(algorithmParameterSpec)) {
            String string = "null";
            if (algorithmParameterSpec != null) {
                string = algorithmParameterSpec.getClass().getName();
            }
            throw new InvalidAlgorithmParameterException(this.algorithm + " cannot use a " + string + " parameter");
        }
        if (algorithmParameterSpec instanceof IVParameterSpec) {
            this.IV = ((IVParameterSpec)algorithmParameterSpec).getIV();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.IV = ((IvParameterSpec)algorithmParameterSpec).getIV();
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            this.IV = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
        }
    }

    public byte[] wrap(PrivateKey privateKey) throws InvalidKeyException, IllegalStateException, TokenException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        if (this.algorithm == KeyWrapAlgorithm.PLAINTEXT) {
            throw new InvalidKeyException("plaintext wrapping not supported");
        }
        this.checkWrappee(privateKey);
        if (this.symKey != null) {
            Assert._assert(this.privKey == null && this.pubKey == null);
            return PK11KeyWrapper.nativeWrapPrivWithSym(this.token, privateKey, this.symKey, this.algorithm, this.IV);
        }
        throw new InvalidKeyException("Wrapping a private key with a public key is not supported");
    }

    public byte[] wrap(SymmetricKey symmetricKey) throws InvalidKeyException, IllegalStateException, TokenException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        if (this.algorithm == KeyWrapAlgorithm.PLAINTEXT) {
            throw new InvalidKeyException("plaintext wrapping not supported");
        }
        this.checkWrappee(symmetricKey);
        if (this.symKey != null) {
            Assert._assert(this.privKey == null && this.pubKey == null);
            return PK11KeyWrapper.nativeWrapSymWithSym(this.token, symmetricKey, this.symKey, this.algorithm, this.IV);
        }
        Assert._assert(this.pubKey != null && this.privKey == null && this.symKey == null);
        return PK11KeyWrapper.nativeWrapSymWithPub(this.token, symmetricKey, this.pubKey, this.algorithm, this.IV);
    }

    private void checkWrappee(SymmetricKey symmetricKey) throws InvalidKeyException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("key to be wrapped is null");
        }
        if (!(symmetricKey instanceof PK11SymKey)) {
            throw new InvalidKeyException("key to be wrapped is not a PKCS #11 key");
        }
        if (!symmetricKey.getOwningToken().equals(this.token)) {
            throw new InvalidKeyException("key to be wrapped does not live on the same token as the wrapping key");
        }
    }

    private void checkWrappee(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("key to be wrapped is null");
        }
        if (!(privateKey instanceof PK11PrivKey)) {
            throw new InvalidKeyException("key to be wrapped is not a PKCS #11 key");
        }
        if (!privateKey.getOwningToken().equals(this.token)) {
            throw new InvalidKeyException("key to be wrapped does not live on the same token as the wrapping key");
        }
    }

    private static native byte[] nativeWrapSymWithSym(PK11Token var0, SymmetricKey var1, SymmetricKey var2, KeyWrapAlgorithm var3, byte[] var4) throws TokenException;

    private static native byte[] nativeWrapSymWithPub(PK11Token var0, SymmetricKey var1, PublicKey var2, KeyWrapAlgorithm var3, byte[] var4) throws TokenException;

    private static native byte[] nativeWrapPrivWithSym(PK11Token var0, PrivateKey var1, SymmetricKey var2, KeyWrapAlgorithm var3, byte[] var4) throws TokenException;

    public PrivateKey unwrapPrivate(byte[] byArray, PrivateKey.Type type, PublicKey publicKey) throws TokenException, InvalidKeyException, IllegalStateException {
        return this.baseUnwrapPrivate(byArray, type, publicKey, false);
    }

    public PrivateKey unwrapTemporaryPrivate(byte[] byArray, PrivateKey.Type type, PublicKey publicKey) throws TokenException, InvalidKeyException, IllegalStateException {
        return this.baseUnwrapPrivate(byArray, type, publicKey, true);
    }

    private PrivateKey baseUnwrapPrivate(byte[] byArray, PrivateKey.Type type, PublicKey publicKey, boolean bl) throws TokenException, InvalidKeyException, IllegalStateException {
        if (this.state != 2) {
            throw new IllegalStateException();
        }
        if (this.algorithm == KeyWrapAlgorithm.PLAINTEXT) {
            throw new TokenException("plaintext unwrapping of private keys is not supported");
        }
        byte[] byArray2 = PK11KeyWrapper.extractPublicValue(publicKey, type);
        if (this.symKey != null) {
            Assert._assert(this.pubKey == null && this.privKey == null);
            return PK11KeyWrapper.nativeUnwrapPrivWithSym(this.token, this.symKey, byArray, this.algorithm, PK11KeyWrapper.algFromType(type), byArray2, this.IV, bl);
        }
        throw new InvalidKeyException("Unwrapping a private key with a private key is not supported");
    }

    private static byte[] extractPublicValue(PublicKey publicKey, PrivateKey.Type type) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("publicKey is null");
        }
        if (type == PrivateKey.RSA) {
            if (!(publicKey instanceof RSAPublicKey)) {
                throw new InvalidKeyException("Type of public key does not match type of private key");
            }
            return ((RSAPublicKey)publicKey).getModulus().toByteArray();
        }
        if (type == PrivateKey.DSA) {
            if (!(publicKey instanceof DSAPublicKey)) {
                throw new InvalidKeyException("Type of public key does not match type of private key");
            }
            return ((DSAPublicKey)publicKey).getY().toByteArray();
        }
        Assert.notReached("Unknown private key type");
        return new byte[0];
    }

    public SymmetricKey unwrapSymmetric(byte[] byArray, SymmetricKey.Type type, SymmetricKey.Usage usage, int n) throws TokenException, IllegalStateException, InvalidAlgorithmParameterException {
        return this.unwrapSymmetric(byArray, type, usage.getVal(), n);
    }

    public SymmetricKey unwrapSymmetric(byte[] byArray, SymmetricKey.Type type, int n) throws TokenException, IllegalStateException, InvalidAlgorithmParameterException {
        return this.unwrapSymmetric(byArray, type, -1, n);
    }

    private SymmetricKey unwrapSymmetric(byte[] byArray, SymmetricKey.Type type, int n, int n2) throws TokenException, IllegalStateException, InvalidAlgorithmParameterException {
        if (this.state != 2) {
            throw new IllegalStateException();
        }
        if (!this.algorithm.isPadded() && type == SymmetricKey.RC4) {
            if (n2 <= 0) {
                throw new InvalidAlgorithmParameterException("RC4 keys wrapped in unpadded algorithms need key length specified when unwrapping");
            }
        } else {
            n2 = 0;
        }
        if (this.algorithm == KeyWrapAlgorithm.PLAINTEXT) {
            return PK11KeyWrapper.nativeUnwrapSymPlaintext(this.token, byArray, PK11KeyWrapper.algFromType(type), n);
        }
        if (this.symKey != null) {
            Assert._assert(this.pubKey == null && this.privKey == null);
            return PK11KeyWrapper.nativeUnwrapSymWithSym(this.token, this.symKey, byArray, this.algorithm, PK11KeyWrapper.algFromType(type), n2, this.IV, n);
        }
        Assert._assert(this.privKey != null && this.pubKey == null && this.symKey == null);
        return PK11KeyWrapper.nativeUnwrapSymWithPriv(this.token, this.privKey, byArray, this.algorithm, PK11KeyWrapper.algFromType(type), n2, this.IV, n);
    }

    private static Algorithm algFromType(PrivateKey.Type type) {
        if (type == PrivateKey.RSA) {
            return KeyPairAlgorithm.RSAFamily;
        }
        if (type == PrivateKey.DSA) {
            return KeyPairAlgorithm.DSAFamily;
        }
        Assert._assert(type == PrivateKey.EC);
        return KeyPairAlgorithm.ECFamily;
    }

    private static Algorithm algFromType(SymmetricKey.Type type) {
        if (type == SymmetricKey.DES) {
            return EncryptionAlgorithm.DES_ECB;
        }
        if (type == SymmetricKey.DES3) {
            return EncryptionAlgorithm.DES3_ECB;
        }
        if (type == SymmetricKey.RC4) {
            return EncryptionAlgorithm.RC4;
        }
        Assert._assert(type == SymmetricKey.RC2);
        return EncryptionAlgorithm.RC2_CBC;
    }

    private static native PrivateKey nativeUnwrapPrivWithSym(PK11Token var0, SymmetricKey var1, byte[] var2, KeyWrapAlgorithm var3, Algorithm var4, byte[] var5, byte[] var6, boolean var7) throws TokenException;

    private static native SymmetricKey nativeUnwrapSymWithSym(PK11Token var0, SymmetricKey var1, byte[] var2, KeyWrapAlgorithm var3, Algorithm var4, int var5, byte[] var6, int var7) throws TokenException;

    private static native SymmetricKey nativeUnwrapSymWithPriv(PK11Token var0, PrivateKey var1, byte[] var2, KeyWrapAlgorithm var3, Algorithm var4, int var5, byte[] var6, int var7) throws TokenException;

    private static native SymmetricKey nativeUnwrapSymPlaintext(PK11Token var0, byte[] var1, Algorithm var2, int var3);

    private void reset() {
        this.state = 0;
        this.symKey = null;
        this.privKey = null;
        this.pubKey = null;
        this.parameters = null;
        this.IV = null;
    }
}

