/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.processor.config.TypeMappingInfo;
import com.sun.xml.rpc.processor.config.TypeMappingRegistryInfo;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaCustomType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.JavaBean;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiStructure;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreatorBase;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.util.ClassNameInfo;
import com.sun.xml.rpc.util.JAXRPCClassFactory;
import com.sun.xml.rpc.util.VersionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class RmiTypeModeler
implements RmiConstants {
    private Map soapTypeMap;
    private Set typeNames = new HashSet();
    private RmiModeler modeler;
    private ProcessorEnvironment env;
    private TypeMappingRegistryInfo typeMappingRegistry;
    private SOAPSimpleTypeCreatorBase soapTypes;
    private SOAPEncodingConstants soapEncodingConstants;
    private SOAPVersion soapVersion;
    private String targetVersion;
    private static final Set boxedPrimitiveSet = new HashSet();
    private static final Set optionalTypes = new HashSet();

    static {
        boxedPrimitiveSet.add("java.lang.Boolean");
        boxedPrimitiveSet.add("java.lang.Byte");
        boxedPrimitiveSet.add("java.lang.Double");
        boxedPrimitiveSet.add("java.lang.Float");
        boxedPrimitiveSet.add("java.lang.Integer");
        boxedPrimitiveSet.add("java.lang.Long");
        boxedPrimitiveSet.add("java.lang.Short");
        optionalTypes.add("java.lang.Object");
        optionalTypes.add("java.util.Collection");
        optionalTypes.add("java.util.List");
        optionalTypes.add("java.util.Set");
        optionalTypes.add("java.util.Vector");
        optionalTypes.add("java.util.Stack");
        optionalTypes.add("java.util.LinkedList");
        optionalTypes.add("java.util.ArrayList");
        optionalTypes.add("java.util.HashSet");
        optionalTypes.add("java.util.TreeSet");
        optionalTypes.add("java.util.Map");
        optionalTypes.add("java.util.HashMap");
        optionalTypes.add("java.util.TreeMap");
        optionalTypes.add("java.util.Hashtable");
        optionalTypes.add("java.util.Properties");
    }

    public SOAPSimpleTypeCreatorBase getSOAPTypes() {
        return this.soapTypes;
    }

    public SOAPVersion getSOAPVersion() {
        return this.soapVersion;
    }

    public void modelSubclasses(String typeUri) {
        SOAPType type;
        HashSet<SOAPType> abstractTypes = new HashSet<SOAPType>();
        int startSize = this.soapTypeMap.size();
        Iterator iter = this.soapTypeMap.entrySet().iterator();
        while (iter.hasNext()) {
            type = (SOAPType)iter.next().getValue();
            if (!(type instanceof SOAPStructureType)) continue;
            abstractTypes.add(type);
        }
        iter = abstractTypes.iterator();
        while (iter.hasNext()) {
            type = (SOAPType)((Object)iter.next());
            this.modelSubclasses(typeUri, (JavaStructureType)type.getJavaType());
        }
        if (startSize != this.soapTypeMap.size()) {
            iter = this.soapTypeMap.entrySet().iterator();
            while (iter.hasNext()) {
                type = (SOAPType)iter.next().getValue();
                if (!(type instanceof SOAPStructureType) || !((JavaStructureType)type.getJavaType()).isAbstract() || abstractTypes.contains(type)) continue;
                this.modelSubclasses(typeUri, (JavaStructureType)type.getJavaType());
            }
        }
    }

    public void initializeTypeMap(Map typeMap) {
        this.soapTypes.initializeTypeMap(typeMap);
    }

    private void modelSubclasses(String typeUri, JavaStructureType type) {
        try {
            Class typeClass = RmiUtils.getClassForName(type.getRealName(), this.env.getClassLoader());
            Class[] interfaces = typeClass.getInterfaces();
            if (RmiTypeModeler.multipleClasses(interfaces, this.env)) {
                throw new ModelerException("rmimodeler.type.implements.more.than.one.interface", new Object[]{type.getRealName(), interfaces[0].getName(), interfaces[1].getName()});
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", type.getRealName());
        }
        int startSize = this.soapTypeMap.size();
        int curSize = 0;
        block2: while (curSize != startSize) {
            curSize = startSize;
            Iterator iterator = this.soapTypeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                JavaStructureType javaType;
                SOAPType extraType = (SOAPType)iterator.next().getValue();
                if (!(extraType instanceof SOAPStructureType) || type.equals(javaType = (JavaStructureType)extraType.getJavaType()) || !RmiTypeModeler.isSubclass(javaType.getRealName(), type.getRealName(), this.env.getClassLoader())) continue;
                this.modelHierarchy(typeUri, javaType, type);
                curSize = this.soapTypeMap.size();
                if (curSize == startSize) continue;
                startSize = curSize;
                curSize = 0;
                continue block2;
            }
        }
    }

    public static void markInheritedMembers(ProcessorEnvironment env, SOAPStructureType struct) {
        String className = struct.getJavaType().getRealName();
        try {
            Iterator members = struct.getMembers();
            Class javaClass = RmiUtils.getClassForName(className, env.getClassLoader());
            if (javaClass.isInterface() || Modifier.isAbstract(javaClass.getModifiers())) {
                ((JavaStructureType)struct.getJavaType()).setAbstract(true);
            }
            Class superclass = javaClass.getSuperclass();
            while (members.hasNext()) {
                SOAPStructureMember soapMember = (SOAPStructureMember)members.next();
                JavaStructureMember javaMember = soapMember.getJavaStructureMember();
                if (javaMember.isPublic()) {
                    try {
                        Field field = javaClass.getDeclaredField(javaMember.getName());
                        if (field.getDeclaringClass().equals(javaClass)) continue;
                        javaMember.setInherited(true);
                        soapMember.setInherited(true);
                    }
                    catch (NoSuchFieldException e) {
                        javaMember.setInherited(true);
                        soapMember.setInherited(true);
                    }
                    continue;
                }
                String methodName = javaMember.getReadMethod();
                Class[] args = new Class[]{};
                boolean isInherited = RmiTypeModeler.isMethodInherited(methodName, args, javaClass);
                methodName = javaMember.getWriteMethod();
                if (methodName != null) {
                    boolean bl = isInherited = isInherited ? RmiTypeModeler.isMethodInherited(methodName, args, javaClass) : false;
                }
                if (!isInherited) continue;
                javaMember.setInherited(true);
                soapMember.setInherited(true);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", className);
        }
    }

    private SOAPType getMappedSoapType(RmiType type) {
        String name = type.toString();
        return (SOAPType)this.soapTypeMap.get(name);
    }

    private void mapSOAPType(RmiType type, SOAPType soapType) {
        this.mapSOAPType(type.toString(), soapType);
    }

    private void mapSOAPType(String name, SOAPType soapType) {
        this.soapTypeMap.put(name, soapType);
    }

    protected RmiTypeModeler(RmiModeler modeler, ProcessorEnvironment env) {
        this(modeler, env, SOAPVersion.SOAP_11);
    }

    public static boolean multipleClasses(Class[] classes, ProcessorEnvironment env) {
        if (classes.length < 2) {
            return false;
        }
        ArrayList<Class> tmpList = new ArrayList<Class>(classes.length);
        int i = 0;
        while (i < classes.length) {
            RmiType type = RmiType.getRmiType(classes[i]);
            if (RmiStructure.modelTypeSOAP(env, type).size() > 0 || JavaBean.modelTypeSOAP(env, type).size() > 0) {
                tmpList.add(classes[i]);
            }
            ++i;
        }
        classes = new Class[tmpList.size()];
        if ((classes = tmpList.toArray(classes)).length < 2) {
            return false;
        }
        boolean isSubclass = true;
        boolean isNotConvertibleInterface = true;
        int i2 = 0;
        while (i2 < classes.length && isSubclass && isNotConvertibleInterface) {
            isSubclass = false;
            int j = i2;
            while (j < classes.length && !isSubclass) {
                if (i2 != j && (classes[i2].isAssignableFrom(classes[j]) || classes[j].isAssignableFrom(classes[i2]))) {
                    isSubclass = true;
                    isNotConvertibleInterface = false;
                }
                ++j;
            }
            ++i2;
        }
        return isSubclass;
    }

    private static void log(ProcessorEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[RmiTypeModeler: " + msg + "]");
        }
    }

    private void addTypeName(QName typeName, String javaType) {
        if (this.typeNames.contains(typeName)) {
            throw new ModelerException("rmimodeler.duplicate.type.name", new Object[]{typeName.toString(), javaType});
        }
        this.typeNames.add(typeName);
    }

    public boolean modelHierarchy(String typeUri, JavaStructureType subclass, JavaStructureType superclassType) {
        String superClassName = superclassType.getRealName();
        SOAPStructureType superSOAPType = (SOAPStructureType)superclassType.getOwner();
        SOAPStructureType soapType = (SOAPStructureType)subclass.getOwner();
        if (soapType.getParentType() != null) {
            if (soapType.getParentType().equals(superSOAPType)) {
                return true;
            }
            if (RmiTypeModeler.isSubclass(soapType.getParentType().getJavaType().getRealName(), superClassName, this.env.getClassLoader())) {
                SOAPStructureType tmpType = soapType;
                while (tmpType.getParentType() != null) {
                    if ((tmpType = tmpType.getParentType()).getJavaType().getRealName().equals(superClassName)) {
                        return true;
                    }
                    if (RmiTypeModeler.isSubclass(tmpType.getJavaType().getRealName(), superClassName, this.env.getClassLoader())) continue;
                    throw new ModelerException("rmimodeler.type.is.used.as.two.types", new Object[]{subclass.getRealName(), tmpType.getJavaType().getRealName(), superClassName});
                }
                return this.modelHierarchy(typeUri, (JavaStructureType)tmpType.getJavaType(), superclassType);
            }
            if (!RmiTypeModeler.isSubclass(superClassName, soapType.getParentType().getJavaType().getRealName(), this.env.getClassLoader())) {
                if (soapType.getParentType().getJavaType().getRealName().equals(superClassName)) {
                    return true;
                }
                throw new ModelerException("rmimodeler.type.is.used.as.two.types", new Object[]{subclass.getRealName(), soapType.getParentType().getJavaType().getRealName(), superClassName});
            }
        }
        try {
            Class subclassClass = RmiUtils.getClassForName(subclass.getRealName(), this.env.getClassLoader());
            Class superclass = subclassClass.getSuperclass();
            if (superclass == null || !superclass.getName().equals(superClassName) && !RmiTypeModeler.isSubclass(superclass.getName(), superClassName, this.env.getClassLoader())) {
                Class<?>[] interfaces = subclassClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (interfaces[i].getName().equals(superClassName)) {
                        superSOAPType.addSubtype((SOAPStructureType)subclass.getOwner());
                        ((JavaStructureType)superSOAPType.getJavaType()).addSubclass(subclass);
                        return true;
                    }
                    if (RmiTypeModeler.isSubclass(interfaces[i].getName(), superClassName, this.env.getClassLoader())) {
                        RmiType type = RmiType.getRmiType(interfaces[i]);
                        SOAPStructureType superType = (SOAPStructureType)this.modelTypeSOAP(typeUri, type);
                        superType.addSubtype((SOAPStructureType)subclass.getOwner());
                        ((JavaStructureType)superType.getJavaType()).addSubclass(subclass);
                        return this.modelHierarchy(typeUri, (JavaStructureType)superType.getJavaType(), superclassType);
                    }
                    ++i;
                }
            }
            RmiType type = RmiType.getRmiType(superclass);
            SOAPStructureType superType = (SOAPStructureType)this.modelTypeSOAP(typeUri, type);
            superType.addSubtype((SOAPStructureType)subclass.getOwner());
            ((JavaStructureType)superType.getJavaType()).addSubclass(subclass);
            if (!superclass.getName().equals(superClassName)) {
                return this.modelHierarchy(typeUri, (JavaStructureType)superType.getJavaType(), superclassType);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", subclass.getRealName());
        }
    }

    private SOAPType processTypeMapping(ProcessorEnvironment env, TypeMappingInfo typeMapping) {
        RmiTypeModeler.log(env, "creating custom type for: " + typeMapping.getJavaTypeName());
        SOAPCustomType soapType = new SOAPCustomType(typeMapping.getXMLType(), this.soapVersion);
        JavaCustomType javaType = new JavaCustomType(typeMapping.getJavaTypeName(), typeMapping);
        soapType.setJavaType(javaType);
        this.mapSOAPType(javaType.getRealName(), (SOAPType)soapType);
        return soapType;
    }

    public SOAPType modelTypeSOAP(String typeUri, RmiType type) {
        TypeMappingInfo typeMapping;
        if (this.modeler.isStrictCompliant() && optionalTypes.contains(type.typeString(false).replace('$', '.'))) {
            throw new ModelerException("rmimodeler.type.not.strict.compliant", type.typeString(false).replace('$', '.'));
        }
        SOAPType typeNode = this.getMappedSoapType(type);
        if (typeNode != null) {
            return typeNode;
        }
        if (this.typeMappingRegistry != null && (typeMapping = this.typeMappingRegistry.getTypeMappingInfo(this.soapEncodingConstants.getURIEncoding(), type.toString())) != null) {
            return this.processTypeMapping(this.env, typeMapping);
        }
        int typeCode = type.getTypeCode();
        String packageName = ClassNameInfo.getQualifier(type.toString());
        String namespaceURI = this.modeler.getNamespaceURI(packageName);
        if (namespaceURI == null) {
            namespaceURI = typeUri;
        }
        switch (typeCode) {
            case 11: {
                return null;
            }
            case 9: {
                QName arrName = new QName(namespaceURI, "tmp");
                String fixedupClassName = type.typeString(false);
                JavaArrayType javaArType = new JavaArrayType(fixedupClassName);
                javaArType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME.getLocalPart());
                SOAPArrayType arrType = new SOAPArrayType(arrName, this.soapVersion);
                arrType.setJavaType(javaArType);
                arrType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
                this.mapSOAPType(type, (SOAPType)arrType);
                SOAPType elemType = this.modelTypeSOAP(typeUri, type.getElementType());
                String tmp = boxedPrimitiveSet.contains(elemType.getJavaType().getRealName()) ? ClassNameInfo.getName(elemType.getJavaType().getName()) : elemType.getName().getLocalPart();
                arrName = new QName(namespaceURI, "ArrayOf" + tmp);
                SOAPType tmpSOAPType = elemType;
                while (tmpSOAPType instanceof SOAPArrayType) {
                    tmpSOAPType = ((SOAPArrayType)tmpSOAPType).getElementType();
                }
                if (!(tmpSOAPType instanceof SOAPSimpleType)) {
                    this.addTypeName(arrName, fixedupClassName);
                }
                arrType.setName(arrName);
                arrType.setElementType(elemType);
                if (elemType instanceof SOAPArrayType) {
                    arrType.setRank(((SOAPArrayType)elemType).getRank() + 1);
                } else {
                    arrType.setRank(1);
                }
                javaArType.setElementType(elemType.getJavaType());
                return arrType;
            }
            case 10: {
                Class typeClass;
                SOAPType holderType = this.modelHolder(this.modeler, this.env, typeUri, type);
                if (holderType != null) {
                    this.mapSOAPType(type, holderType);
                    return holderType;
                }
                QName structName = new QName(namespaceURI, type.typeString(true).replace('$', '.'));
                SOAPOrderedStructureType struct = new SOAPOrderedStructureType(structName, this.soapVersion);
                String fixedupClassName = type.getClassName();
                this.addTypeName(structName, fixedupClassName);
                this.mapSOAPType(type, (SOAPType)struct);
                JavaStructureType javaStruct = new JavaStructureType(fixedupClassName, true, struct);
                struct.setJavaType(javaStruct);
                Map members = RmiTypeModeler.collectMembers(this.env, type);
                if (members.size() == 0) {
                    throw new ModelerException("rmimodeler.invalid.rmi.type", type.toString());
                }
                try {
                    typeClass = type.getTypeClass(this.env.getClassLoader());
                    if (typeClass.isInterface() || Modifier.isAbstract(typeClass.getModifiers())) {
                        ((JavaStructureType)struct.getJavaType()).setAbstract(true);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ModelerException("rmimodeler.class.not.found", type.toString());
                }
                List sortedMembers = null;
                sortedMembers = VersionUtil.isVersion101(this.targetVersion) ? RmiTypeModeler.sortMembers101(typeClass, members, this.env) : RmiTypeModeler.sortMembers(typeClass, members, this.env);
                this.fillInStructure(typeUri, struct, javaStruct, sortedMembers, type);
                return struct;
            }
        }
        throw new ModelerException("rmimodeler.unexpected.type", type.toString());
    }

    protected RmiTypeModeler(RmiModeler modeler, ProcessorEnvironment env, SOAPVersion soapVersion) {
        this.modeler = modeler;
        this.env = env;
        this.typeMappingRegistry = modeler.getTypeMappingRegistryInfo();
        this.typeNames = new HashSet();
        this.soapTypeMap = new HashMap();
        this.soapVersion = soapVersion;
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(soapVersion);
        this.soapTypes = JAXRPCClassFactory.newInstance().createSOAPSimpleTypeCreator(modeler.isStrictCompliant(), soapVersion);
        this.initializeTypeMap(this.soapTypeMap);
        this.targetVersion = modeler.getOptions().getProperty("sourceVersion");
    }

    public static boolean isMethodInherited(String methodName, Class[] args, Class javaClass) {
        return RmiTypeModeler.methodMemberClass(methodName, args, javaClass) != javaClass;
    }

    public static boolean isSubclass(String subtypeName, String supertypeName, ClassLoader classLoader) {
        String className = subtypeName;
        if (subtypeName.equals(supertypeName)) {
            return false;
        }
        try {
            Class subClass = RmiUtils.getClassForName(className, classLoader);
            className = supertypeName;
            Class<?> supertypeClass = Class.forName(className, true, classLoader);
            return supertypeClass.isAssignableFrom(subClass);
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", className);
        }
    }

    public static Field getValueMember(ProcessorEnvironment env, Class classDef) {
        Field member = null;
        try {
            member = classDef.getDeclaredField("value");
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        if (member == null) {
            Class superDec = classDef.getSuperclass();
            member = RmiTypeModeler.getValueMember(env, superDec);
        }
        return member;
    }

    public static Map collectMembers(ProcessorEnvironment env, RmiType type) {
        Map members = RmiStructure.modelTypeSOAP(env, type);
        Map members2 = JavaBean.modelTypeSOAP(env, type);
        if (members.size() != 0 && members2.size() != 0) {
            Iterator keys = members.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!members2.containsKey(key)) continue;
                throw new ModelerException("rmimodeler.javabean.property.has.public.member", new Object[]{type.toString(), key});
            }
        }
        members.putAll(members2);
        return members;
    }

    public static RmiType getHolderValueType(ProcessorEnvironment env, Class defHolder, RmiType type) {
        if (type.getTypeCode() != 10) {
            return null;
        }
        Class def = null;
        try {
            def = type.getTypeClass(env.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", type.toString());
        }
        Class<?>[] interfaces = def.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            Class<?> interfaceDef = interfaces[i];
            if (defHolder.isAssignableFrom(interfaces[i])) {
                Field member = RmiTypeModeler.getValueMember(env, def);
                return member != null ? RmiType.getRmiType(member.getType()) : null;
            }
            ++i;
        }
        return null;
    }

    public static Class getDeclaringClass(Class theClass, MemberInfo memInfo, ProcessorEnvironment env) {
        Class retClass = null;
        if (retClass == null) {
            if (memInfo.isPublic()) {
                Class superClass = theClass.getSuperclass();
                if (superClass != null) {
                    retClass = RmiTypeModeler.getDeclaringClass(superClass, memInfo, env);
                }
                if (retClass == null) {
                    Class<?>[] interfaces = theClass.getInterfaces();
                    int i = 0;
                    while (i < interfaces.length && retClass == null) {
                        retClass = RmiTypeModeler.getDeclaringClass(interfaces[i], memInfo, env);
                        ++i;
                    }
                }
                try {
                    Field field = theClass.getDeclaredField(memInfo.getName());
                    if (field.getDeclaringClass().equals(theClass)) {
                        retClass = theClass;
                    }
                }
                catch (NoSuchFieldException e) {}
            } else {
                try {
                    Class typeClass = memInfo.getType().getTypeClass(theClass.getClassLoader());
                    Class readClass = RmiTypeModeler.getDeclaringClassMethod(theClass, memInfo.getReadMethod(), new Class[0]);
                    Class writeClass = RmiTypeModeler.getDeclaringClassMethod(theClass, memInfo.getWriteMethod(), new Class[]{typeClass});
                    retClass = readClass.equals(writeClass) ? readClass : (readClass.isAssignableFrom(writeClass) ? writeClass : readClass);
                }
                catch (ClassNotFoundException e) {
                    throw new ModelerException("rmimodeler.class.not.found", memInfo.getType().getClassName());
                }
            }
        }
        return retClass;
    }

    private static Class methodMemberClass(String methodName, Class[] args, Class javaClass) {
        Class retClass = null;
        Class superclass = javaClass.getSuperclass();
        if (superclass != null && (retClass = RmiTypeModeler.methodMemberClass(methodName, args, superclass)) != null) {
            return retClass;
        }
        Class<?>[] interfaces = javaClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            retClass = RmiTypeModeler.methodMemberClass(methodName, args, interfaces[i]);
            if (retClass != null) {
                return retClass;
            }
            ++i;
        }
        try {
            Method method = javaClass.getDeclaredMethod(methodName, args);
            return javaClass;
        }
        catch (NoSuchMethodException e) {
            return retClass;
        }
    }

    public static Class getDeclaringClassMethod(Class theClass, String methodName, Class[] args) {
        Class retClass;
        block6: {
            retClass = null;
            Class superClass = theClass.getSuperclass();
            if (superClass != null) {
                retClass = RmiTypeModeler.getDeclaringClassMethod(superClass, methodName, args);
            }
            if (retClass == null) {
                Class<?>[] interfaces = theClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length && retClass == null) {
                    retClass = RmiTypeModeler.getDeclaringClassMethod(interfaces[i], methodName, args);
                    ++i;
                }
            }
            if (retClass != null) break block6;
            try {
                Method method = theClass.getMethod(methodName, args);
                if (method.getDeclaringClass().equals(theClass)) {
                    retClass = theClass;
                }
            }
            catch (NoSuchMethodException e) {}
        }
        return retClass;
    }

    public static List sortMembers(Class typeClass, Map members, ProcessorEnvironment env) {
        MemberInfo memInfo;
        TreeSet<MemberInfo> sorted = new TreeSet<MemberInfo>(new MemberInfoComparator());
        Iterator iter = members.entrySet().iterator();
        while (iter.hasNext()) {
            memInfo = (MemberInfo)iter.next().getValue();
            memInfo.setSortingClass(RmiTypeModeler.getDeclaringClass(typeClass, memInfo, env));
            sorted.add(memInfo);
        }
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>(sorted.size());
        Iterator iter2 = sorted.iterator();
        while (iter2.hasNext()) {
            memInfo = (MemberInfo)iter2.next();
            list.add(memInfo);
        }
        return list;
    }

    private static List sortMembers101(Class typeClass, Map members, ProcessorEnvironment env) {
        ArrayList<MemberInfo> sorted = new ArrayList<MemberInfo>();
        Iterator iter = members.entrySet().iterator();
        while (iter.hasNext()) {
            MemberInfo memInfo = (MemberInfo)iter.next().getValue();
            memInfo.setSortingClass(RmiTypeModeler.getDeclaringClass(typeClass, memInfo, env));
            sorted.add(memInfo);
        }
        return sorted;
    }

    private SOAPType modelHolder(RmiModeler modeler, ProcessorEnvironment env, String typeUri, RmiType type) {
        RmiType holderValueType = RmiTypeModeler.getHolderValueType(env, modeler.getDefHolder(), type);
        if (holderValueType == null) {
            return null;
        }
        SOAPType holderSOAPType = this.modelTypeSOAP(typeUri, holderValueType);
        JavaType javaType = holderSOAPType.getJavaType();
        javaType.setHolder(true);
        javaType.setHolderPresent(true);
        javaType.setHolderName(type.toString());
        return holderSOAPType;
    }

    private void fillInStructure(String typeUri, SOAPStructureType struct, JavaStructureType javaStruct, List sortedMembers, RmiType type) {
        ProcessorEnvironment env = this.modeler.getProcessorEnvironment();
        Iterator iter = sortedMembers.iterator();
        while (iter.hasNext()) {
            MemberInfo memInfo = (MemberInfo)iter.next();
            SOAPStructureMember member = new SOAPStructureMember(new QName(null, memInfo.getName()), this.modelTypeSOAP(typeUri, memInfo.getType()));
            JavaStructureMember javaMember = new JavaStructureMember(memInfo.getName(), member.getType().getJavaType(), member, memInfo.isPublic());
            member.setJavaStructureMember(javaMember);
            javaMember.setReadMethod(memInfo.getReadMethod());
            javaMember.setWriteMethod(memInfo.getWriteMethod());
            if (memInfo.getDeclaringClass() != null) {
                javaMember.setDeclaringClass(memInfo.getDeclaringClass().getName());
            }
            javaStruct.add(javaMember);
            struct.add(member);
        }
        RmiTypeModeler.markInheritedMembers(env, struct);
    }

    public static class MemberInfoComparator
    implements Comparator {
        protected int sort(MemberInfo mem1, MemberInfo mem2) {
            Class class2;
            String key1 = mem1.getName();
            String key2 = mem2.getName();
            Class class1 = mem1.getSortingClass();
            if (class1.equals(class2 = mem2.getSortingClass())) {
                return key1.compareTo(key2);
            }
            if (class1.isAssignableFrom(class2) && !class2.isAssignableFrom(class1)) {
                return -1;
            }
            return 1;
        }

        public int compare(Object o1, Object o2) {
            MemberInfo mem1 = (MemberInfo)o1;
            MemberInfo mem2 = (MemberInfo)o2;
            return this.sort(mem1, mem2);
        }
    }
}

