/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.common.util.MarshallerUtil;
import com.sun.xml.registry.common.util.XMLUtil;
import com.sun.xml.registry.uddi.JAXRConstants;
import com.sun.xml.registry.uddi.bindings_v2.URLType;
import com.sun.xml.registry.uddi.infomodel.OrganizationImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;

public class MapperHelpers
extends JAXRConstants {
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });
    private static XMLUtil xmlUtil;
    private static MarshallerUtil marshallerUtil;

    MapperHelpers() {
    }

    URLType parseUrlForUrlType(String string) {
        URLType uRLType = null;
        uRLType = string.indexOf("https") != -1 || string.indexOf("HTTPS") != -1 ? URLType.HTTPS : (string.indexOf("http") != -1 || string.indexOf("HTTP") != -1 ? URLType.HTTP : (string.indexOf("ftp") != -1 || string.indexOf("FTP") != -1 ? URLType.FTP : (string.indexOf("phone") != -1 || string.indexOf("PHONE") != -1 ? URLType.PHONE : (string.indexOf("mailto") != -1 || string.indexOf("MAILTO") != -1 ? URLType.MAILTO : URLType.OTHER))));
        return uRLType;
    }

    Collection cullDuplicates(Collection collection) throws JAXRException {
        HashMap<String, RegistryObject> hashMap = new HashMap<String, RegistryObject>(collection.size() * 2 - 1);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RegistryObject registryObject = (RegistryObject)iterator.next();
            String string = registryObject.getKey().getId().toUpperCase();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, registryObject);
                continue;
            }
            this.logger.finest("Found a dup of " + string);
            RegistryObject registryObject2 = (RegistryObject)hashMap.get(string);
            if (!(registryObject instanceof ClassificationScheme) || !(registryObject2 instanceof ClassificationScheme)) continue;
            this.logger.finest("Both RO's are classificationSchemes");
            if (((ClassificationScheme)registryObject).isExternal()) {
                this.logger.finest("registryObject is external - don't keep it");
                continue;
            }
            this.logger.finest("RegistryObject is internal - remove dup - keep internal ro");
            hashMap.remove(string);
            hashMap.put(string, registryObject);
        }
        return hashMap.values();
    }

    Collection getAllServiceBindingsFromOrganizations(Collection collection) throws JAXRException {
        ArrayList arrayList = new ArrayList();
        Collection collection2 = this.getAllServicesFromOrganizations(collection);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            ServiceImpl serviceImpl = (ServiceImpl)iterator.next();
            Collection collection3 = serviceImpl.getServiceBindings();
            arrayList.addAll(collection3);
        }
        return arrayList;
    }

    Collection getAllServicesFromOrganizations(Collection collection) throws JAXRException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            OrganizationImpl organizationImpl = (OrganizationImpl)iterator.next();
            Collection collection2 = organizationImpl.getServices();
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    BulkResponse cullDuplicates(BulkResponse bulkResponse) throws JAXRException {
        Collection collection = bulkResponse.getCollection();
        if (collection.isEmpty()) {
            return bulkResponse;
        }
        Collection collection2 = this.cullDuplicates(collection);
        ((BulkResponseImpl)bulkResponse).setCollection(collection2);
        return bulkResponse;
    }

    Collection getCallerSourceAssociations(Collection collection, Collection collection2) throws JAXRException {
        ArrayList<Association> arrayList = new ArrayList<Association>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            RegistryObject registryObject = association.getSourceObject();
            if (registryObject == null) continue;
            String string = registryObject.getKey().getId();
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                arrayList.add(association);
            }
        }
        return arrayList;
    }

    Collection getCallerTargetAssociations(Collection collection, Collection collection2) throws JAXRException {
        ArrayList<Association> arrayList = new ArrayList<Association>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            RegistryObject registryObject = association.getTargetObject();
            if (registryObject == null) continue;
            String string = registryObject.getKey().getId();
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                arrayList.add(association);
            }
        }
        return arrayList;
    }

    BulkResponse extractRegistryObjectByClass(BulkResponse bulkResponse, String string) throws JAXRException {
        ArrayList<RegistryObject> arrayList = new ArrayList<RegistryObject>();
        if (bulkResponse.getExceptions() == null) {
            Collection collection = bulkResponse.getCollection();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RegistryObject registryObject = (RegistryObject)iterator.next();
                if (string.equals("Concept")) {
                    if (!(registryObject instanceof Concept)) continue;
                    arrayList.add(registryObject);
                    continue;
                }
                if (!string.equals("ClassificationScheme") || !(registryObject instanceof ClassificationScheme)) continue;
                arrayList.add(registryObject);
            }
            ((BulkResponseImpl)bulkResponse).setCollection(arrayList);
        }
        return bulkResponse;
    }

    BulkResponse filterByAssociationTypes(BulkResponse bulkResponse, Collection collection) throws JAXRException {
        if (collection == null) {
            return null;
        }
        BulkResponseImpl bulkResponseImpl = new BulkResponseImpl();
        ArrayList<Association> arrayList = new ArrayList<Association>();
        Collection collection2 = bulkResponse.getCollection();
        Iterator iterator = collection2.iterator();
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Concept concept = (Concept)iterator2.next();
            while (iterator.hasNext()) {
                Association association = (Association)iterator.next();
                Concept concept2 = association.getAssociationType();
                if (concept2 == null || !concept2.getValue().equalsIgnoreCase(concept.getValue())) continue;
                arrayList.add(association);
            }
        }
        bulkResponseImpl.setPartialResponse(bulkResponse.isPartialResponse());
        bulkResponseImpl.setStatus(bulkResponse.getStatus());
        bulkResponseImpl.addCollection(arrayList);
        return bulkResponseImpl;
    }

    Collection getCallerIsSourceByState(Collection collection, Boolean bl, Boolean bl2) throws JAXRException {
        Object object;
        boolean bl3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl != null && bl2 != null) {
            bl3 = bl;
            boolean bl4 = bl2;
            object = collection.iterator();
            while (object.hasNext()) {
                Association association = (Association)object.next();
                boolean bl5 = association.isConfirmedBySourceOwner();
                boolean bl6 = association.isConfirmedByTargetOwner();
                if (bl5 != bl3 || bl6 != bl4) continue;
                arrayList.add(association);
            }
        }
        if (bl != null && bl2 == null) {
            bl3 = bl;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (Association)iterator.next();
                boolean bl7 = object.isConfirmedBySourceOwner();
                if (bl7 != bl3) continue;
                arrayList.add(object);
            }
        }
        if (bl == null && bl2 != null) {
            bl3 = bl2;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (Association)iterator.next();
                boolean bl8 = object.isConfirmedByTargetOwner();
                if (bl8 != bl3) continue;
                arrayList.add(object);
            }
        }
        if (bl == null && bl2 == null) {
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    Collection getCallerIsTargetByState(Collection collection, Boolean bl, Boolean bl2) throws JAXRException {
        Object object;
        boolean bl3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl != null && bl2 != null) {
            bl3 = bl;
            boolean bl4 = bl2;
            object = collection.iterator();
            while (object.hasNext()) {
                Association association = (Association)object.next();
                boolean bl5 = association.isConfirmedBySourceOwner();
                boolean bl6 = association.isConfirmedByTargetOwner();
                if (bl6 != bl3 || bl5 != bl4) continue;
                arrayList.add(association);
            }
        }
        if (bl != null && bl2 == null) {
            bl3 = bl;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (Association)iterator.next();
                boolean bl7 = object.isConfirmedByTargetOwner();
                if (bl7 != bl3) continue;
                arrayList.add(object);
            }
        }
        if (bl == null && bl2 != null) {
            bl3 = bl2;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (Association)iterator.next();
                boolean bl8 = object.isConfirmedBySourceOwner();
                if (bl8 != bl3) continue;
                arrayList.add(object);
            }
        }
        if (bl == null && bl2 == null) {
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    BulkResponse filterAssociations(BulkResponse bulkResponse, int n, String string, String string2) throws JAXRException {
        BulkResponseImpl bulkResponseImpl = new BulkResponseImpl();
        ArrayList<Association> arrayList = new ArrayList<Association>();
        Collection collection = bulkResponse.getCollection();
        Iterator iterator = collection.iterator();
        block5: while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            RegistryObject registryObject = association.getSourceObject();
            RegistryObject registryObject2 = association.getTargetObject();
            String string3 = registryObject.getKey().getId();
            String string4 = registryObject2.getKey().getId();
            switch (n) {
                case 100: {
                    if (!string3.equals(string)) break;
                    arrayList.add(association);
                    break;
                }
                case 200: {
                    if (!string4.equals(string2)) break;
                    arrayList.add(association);
                    break;
                }
                case 300: {
                    if (!string3.equals(string) || !string4.equals(string2)) continue block5;
                    arrayList.add(association);
                    break;
                }
            }
        }
        bulkResponseImpl.setPartialResponse(bulkResponse.isPartialResponse());
        bulkResponseImpl.setStatus(bulkResponse.getStatus());
        bulkResponseImpl.addCollection(arrayList);
        return bulkResponseImpl;
    }

    Collection getCallerSourceAssociations(Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
        ArrayList<Association> arrayList = new ArrayList<Association>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            RegistryObject registryObject = association.getSourceObject();
            if (registryObject == null) continue;
            String string = registryObject.getKey().getId();
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                arrayList.add(association);
            }
        }
        return arrayList;
    }

    BulkResponse filterAssociationsByConfirmationState(BulkResponse bulkResponse, Boolean bl, Boolean bl2, Collection collection, Collection collection2) throws JAXRException {
        BulkResponseImpl bulkResponseImpl = new BulkResponseImpl();
        ArrayList arrayList = new ArrayList();
        Collection collection3 = bulkResponse.getCollection();
        Iterator iterator = collection3.iterator();
        Collection collection4 = collection;
        Collection collection5 = collection2;
        Collection collection6 = this.getCallerSourceAssociations(collection3, collection4);
        Collection collection7 = this.getCallerTargetAssociations(collection3, collection5);
        Collection collection8 = this.getCallerIsSourceByState(collection6, bl, bl2);
        Collection collection9 = this.getCallerIsTargetByState(collection7, bl, bl2);
        if (collection8 != null && collection8.size() != 0) {
            arrayList.addAll(collection8);
        }
        if (collection9 != null && collection9.size() != 0) {
            arrayList.addAll(collection9);
        }
        bulkResponseImpl.setPartialResponse(bulkResponse.isPartialResponse());
        bulkResponseImpl.setStatus(bulkResponse.getStatus());
        bulkResponseImpl.addCollection(arrayList);
        return bulkResponseImpl;
    }
}

