/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;

public abstract class JAXRCommand {
    RegistryServiceImpl service;
    UDDIMapper mapper;
    BulkResponseImpl response;
    BulkResponseImpl content;

    abstract void execute() throws JAXRException;

    public JAXRCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl) throws JAXRException {
        this.service = registryServiceImpl;
        this.response = bulkResponseImpl;
        this.mapper = new UDDIMapper(registryServiceImpl);
    }

    static class DeleteAssociationsCommand
    extends JAXRCommand {
        Collection schemeKeys;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteAssociations(this.schemeKeys));
        }

        public DeleteAssociationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.schemeKeys = collection;
        }
    }

    static class DeleteClassificationSchemesCommand
    extends JAXRCommand {
        Collection schemeKeys;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteConcepts(this.schemeKeys));
        }

        public DeleteClassificationSchemesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.schemeKeys = collection;
        }
    }

    static class DeleteConceptsCommand
    extends JAXRCommand {
        Collection conceptKeys;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteConcepts(this.conceptKeys));
        }

        public DeleteConceptsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.conceptKeys = collection;
        }
    }

    static class DeleteObjectsCommand
    extends JAXRCommand {
        Collection keys;
        String type;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteObjects(this.keys, this.type));
        }

        public DeleteObjectsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, String string) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.keys = collection;
            this.type = string;
        }
    }

    static class DeleteOrganizationsCommand
    extends JAXRCommand {
        Collection organizationKeys;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteOrganizations(this.organizationKeys));
        }

        public DeleteOrganizationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.organizationKeys = collection;
        }
    }

    static class DeleteServiceBindingsCommand
    extends JAXRCommand {
        Collection bindingKeys;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteServiceBindings(this.bindingKeys));
        }

        public DeleteServiceBindingsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.bindingKeys = collection;
        }
    }

    static class DeleteServicesCommand
    extends JAXRCommand {
        Collection serviceKeys;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteServices(this.serviceKeys));
        }

        public DeleteServicesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.serviceKeys = collection;
        }
    }

    static class FindAssociationsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        String sourceObjectId;
        String targetObjectId;
        Collection associationTypes;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findAssociations(this.findQualifiers, this.sourceObjectId, this.targetObjectId, this.associationTypes));
        }

        public FindAssociationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, String string, String string2, Collection collection2) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.sourceObjectId = string;
            this.targetObjectId = string2;
            this.associationTypes = collection2;
        }
    }

    static class FindCallerAssociationsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Boolean confirmedByCaller;
        Boolean confirmedByOther;
        Collection associationTypes;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findCallerAssociations(this.findQualifiers, this.confirmedByCaller, this.confirmedByOther, this.associationTypes));
        }

        public FindCallerAssociationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, Boolean bl, Boolean bl2, Collection collection2) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.confirmedByCaller = bl;
            this.confirmedByOther = bl2;
            this.associationTypes = collection2;
        }
    }

    static class FindClassificationSchemesCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection externalLinks;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findClassificationSchemes(this.findQualifiers, this.namePatterns, this.classifications, this.externalLinks));
        }

        public FindClassificationSchemesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.namePatterns = collection2;
            this.classifications = collection3;
            this.externalLinks = collection4;
        }
    }

    static class FindConceptsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection identifiers;
        Collection externalLinks;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findConcepts(this.findQualifiers, this.namePatterns, this.classifications, this.identifiers, this.externalLinks));
        }

        public FindConceptsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.namePatterns = collection2;
            this.classifications = collection3;
            this.identifiers = collection4;
            this.externalLinks = collection5;
        }
    }

    static class FindOrganizationsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection specifications;
        Collection identifiers;
        Collection externalLinks;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findOrganizations(this.findQualifiers, this.namePatterns, this.classifications, this.specifications, this.identifiers, this.externalLinks));
        }

        public FindOrganizationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, Collection collection6) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.findQualifiers = collection;
            this.namePatterns = collection2;
            this.classifications = collection3;
            this.specifications = collection4;
            this.identifiers = collection5;
            this.externalLinks = collection6;
        }
    }

    static class FindServiceBindingsCommand
    extends JAXRCommand {
        Key serviceKey;
        Collection findQualifiers;
        Collection classifications;
        Collection specifications;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findServiceBindings(this.serviceKey, this.findQualifiers, this.classifications, this.specifications));
        }

        public FindServiceBindingsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Key key, Collection collection, Collection collection2, Collection collection3) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.serviceKey = key;
            this.findQualifiers = collection;
            this.classifications = collection2;
            this.specifications = collection3;
        }
    }

    static class FindServicesCommand
    extends JAXRCommand {
        Key orgKey;
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection specifications;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findServices(this.orgKey, this.findQualifiers, this.namePatterns, this.classifications, this.specifications));
        }

        public FindServicesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Key key, Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.orgKey = key;
            this.findQualifiers = collection;
            this.namePatterns = collection2;
            this.classifications = collection3;
            this.specifications = collection4;
        }
    }

    static class GetRegistryObjectsByKeysCommand
    extends JAXRCommand {
        Collection objectKeys;
        String type;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.getRegistryObjects(this.objectKeys, this.type));
        }

        public GetRegistryObjectsByKeysCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, String string) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.objectKeys = collection;
            this.type = string;
        }
    }

    static class GetRegistryObjectsByTypeCommand
    extends JAXRCommand {
        String objectType;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.getRegistryObjects(this.objectType));
        }

        public GetRegistryObjectsByTypeCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, String string) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.objectType = string;
        }
    }

    static class GetRegistryObjectsCommand
    extends JAXRCommand {
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.getRegistryObjects());
        }

        public GetRegistryObjectsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
        }
    }

    static class SaveAssociationsCommand
    extends JAXRCommand {
        Collection associations;
        boolean replace;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveAssociations(this.associations, this.replace));
        }

        public SaveAssociationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection, boolean bl) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.associations = collection;
            this.replace = bl;
        }
    }

    static class SaveClassificationSchemesCommand
    extends JAXRCommand {
        Collection schemes;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveClassificationSchemes(this.schemes));
        }

        public SaveClassificationSchemesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.schemes = collection;
        }
    }

    static class SaveConceptsCommand
    extends JAXRCommand {
        Collection concepts;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveConcepts(this.concepts));
        }

        public SaveConceptsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.concepts = collection;
        }
    }

    static class SaveObjectsCommand
    extends JAXRCommand {
        Collection cataloguedObjects;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveObjects(this.cataloguedObjects));
        }

        public SaveObjectsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.cataloguedObjects = collection;
        }
    }

    static class SaveOrganizationsCommand
    extends JAXRCommand {
        Collection organizations;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveOrganizations(this.organizations));
        }

        public SaveOrganizationsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.organizations = collection;
        }
    }

    static class SaveServiceBindingsCommand
    extends JAXRCommand {
        Collection bindings;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveServiceBindings(this.bindings));
        }

        public SaveServiceBindingsCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.bindings = collection;
        }
    }

    static class SaveServicesCommand
    extends JAXRCommand {
        Collection services;

        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveServices(this.services));
        }

        public SaveServicesCommand(RegistryServiceImpl registryServiceImpl, BulkResponseImpl bulkResponseImpl, Collection collection) throws JAXRException {
            super(registryServiceImpl, bulkResponseImpl);
            this.services = collection;
        }
    }
}

