/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.common.tools.bindings.impl.runtime;

import com.sun.xml.bind.validator.Messages;
import com.sun.xml.registry.common.tools.bindings.impl.runtime.Util;
import com.sun.xml.registry.common.tools.bindings.impl.runtime.ValidatableObject;
import com.sun.xml.registry.common.tools.bindings.impl.runtime.ValidationContext;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.bind.Validator;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.xml.sax.SAXException;

public class ValidatorImpl
implements Validator {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();

    public boolean validate(Object object) throws ValidationException {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"subrootObj"));
        }
        return this.validate(object, false);
    }

    public boolean validateRoot(Object object) throws ValidationException {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"rootObj"));
        }
        return this.validate(object, true);
    }

    private boolean validate(Object object, boolean bl) throws ValidationException {
        try {
            ValidatableObject validatableObject = Util.toValidatableObject(object);
            if (validatableObject == null) {
                throw new ValidationException(Messages.format((String)"Validator.NotValidatable"));
            }
            EventInterceptor eventInterceptor = new EventInterceptor(this.eventHandler);
            ValidationContext validationContext = new ValidationContext(eventInterceptor, bl);
            validationContext.validate(validatableObject);
            validationContext.reconcileIDs();
            return !eventInterceptor.hadError();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (sAXException != null) {
                throw new ValidationException((Throwable)exception);
            }
            throw new ValidationException((Throwable)sAXException);
        }
    }

    public ValidationEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) {
        this.eventHandler = validationEventHandler == null ? new DefaultValidationEventHandler() : validationEventHandler;
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"name"));
        }
        throw new PropertyException(string);
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"name"));
        }
        throw new PropertyException(string, object);
    }

    private static class EventInterceptor
    implements ValidationEventHandler {
        private boolean hadError = false;
        private final ValidationEventHandler next;

        public boolean hadError() {
            return this.hadError;
        }

        public boolean handleEvent(ValidationEvent validationEvent) {
            boolean bl;
            this.hadError = true;
            if (this.next != null) {
                try {
                    bl = this.next.handleEvent(validationEvent);
                }
                catch (RuntimeException runtimeException) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        EventInterceptor(ValidationEventHandler validationEventHandler) {
            this.next = validationEventHandler;
        }
    }
}

