/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


package roster;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class RosterDispatcher extends HttpServlet implements Serializable {
    
    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
        
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();

        String option = (String)request.getParameter("choice");

        if (option.equals("insert")) {
            request.getRequestDispatcher("/InsertData").forward(request,response);
        }
        else if (option.equals("list")) {
            request.getRequestDispatcher("/ListData").include(request,response);
        }
        else if (option.equals("clear")) {
            request.getRequestDispatcher("/ClearSession.jsp").forward(request,response);
        }
        else if (option.equals("remove")) {
            request.getRequestDispatcher("/RemoveData").forward(request,response);
        }
        out.close();
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "RosterDispatcher servlet for CMP Roster Application";
    }
    
}
