/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


package roster;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.ejb.*;
import java.util.*;

import team.*;
import util.*;

public class RemoveData extends HttpServlet implements Serializable {
    
    HttpSession session;
    
    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);        
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
        
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        session = request.getSession(false);
        out.println("<html>");
        out.println("<head><title>CMP Roster Having LocalEJBHome Reference Stored in HttpSession</title></head>");
        out.println("<body bgcolor=white>");
        out.println("<B> Remove Data from the database </B>");
        out.println("<BR><BR>");
        try {               
            removeLeague("L1");
            out.println("<BR><BR>Delete League Mountain from database....<BR>");
            out.println("Team 1, 2, and 5 have deleted because of cascade-delete");
            removeLeague("L2");
            out.println("<BR><BR>Delete League Valley from database....<BR>");
            out.println("Team 3 and 4 have deleted because of cascade-delete");
            removeAllPlayers();
            out.println("<BR><BR>And all players have deleted!");
            out.println("<BR><BR<BR><BR>Go back to <a href=index.jsp> Main Page</a> and");
            out.println("select <b><i>Insert data into database</i></b> option to continue again!");
            out.println("<BR><BR>The SessionID:  " + session.getId() + "<BR><BR>");         
        } catch (Exception ex) {
           out.println("Caught an exception: " + ex.toString());
           ex.printStackTrace();
        }
        out.println("</body>");
        out.println("</html>");         
        out.close();
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "RemoveData servlet for CMP Roster Application";
    }
    
    public void removeLeague(String leagueId) { 
        Debug.print("Roster removeLeague");
        try {
            LocalLeagueHome leagueHome = (LocalLeagueHome)session.getAttribute("leagueHome");
            LocalLeague league = leagueHome.findByPrimaryKey(leagueId);
            league.remove();
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
    }

    public void removeAllPlayers() { 
        Debug.print("Roster removeAllPlayers");
        try {
            LocalPlayerHome playerHome = (LocalPlayerHome)session.getAttribute("playerHome");
            Collection players = playerHome.findAll();
            Iterator i = players.iterator();
            while (i.hasNext()) {
            LocalPlayer player = (LocalPlayer) i.next();
            player.remove();
            }
        } catch (Exception ex) {
            throw new EJBException(ex.getMessage());
        }
    }

}
