/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


package team;

import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import util.Debug;


public abstract class PlayerBean implements javax.ejb.EntityBean {
    
    private javax.ejb.EntityContext context;
    
    
    /**
     * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
     */
    public void setEntityContext(javax.ejb.EntityContext ctx) {
        context=ctx;
    }
    
    
    /**
     * @see javax.ejb.EntityBean#ejbActivate()
     */
    public void ejbActivate() {
        
    }
    
    
    /**
     * @see javax.ejb.EntityBean#ejbPassivate()
     */
    public void ejbPassivate() {
        
    }
    
    
    /**
     * @see javax.ejb.EntityBean#ejbRemove()
     */
    public void ejbRemove() {
        
    }
    
    
    /**
     * @see javax.ejb.EntityBean#unsetEntityContext()
     */
    public void unsetEntityContext() {
        context=null;
    }
    
    
    /**
     * @see javax.ejb.EntityBean#ejbLoad()
     */
    public void ejbLoad() {
        
    }
    
    
    /**
     * @see javax.ejb.EntityBean#ejbStore()
     */
    public void ejbStore() {
        
    }
    
    public abstract java.lang.String getPlayer_Id();
    public abstract void setPlayer_Id(java.lang.String playerId);
    
    public abstract java.lang.String getName();
    public abstract void setName(java.lang.String name);
    
    public abstract java.lang.String getPosition();
    public abstract void setPosition(java.lang.String position);
    
    public abstract double getSalary();
    public abstract void setSalary(double salary);
    
    // Select methods

    public abstract java.util.Collection ejbSelectLeagues(LocalPlayer player)
        throws FinderException;

    public abstract java.util.Collection ejbSelectSports(LocalPlayer player)
        throws FinderException;

    // Business methods

    public Collection getLeagues() throws FinderException {

         LocalPlayer player =
             (team.LocalPlayer)context.getEJBLocalObject();
         return ejbSelectLeagues(player);
    }

    public Collection getSports() throws FinderException {

         LocalPlayer player =
             (team.LocalPlayer)context.getEJBLocalObject();
         return ejbSelectSports(player);
    }

    public String ejbCreate (String id, String name, String position,
        double salary) throws CreateException {

        Debug.print("PlayerBean ejbCreate");
        setPlayer_Id(id);
        setName(name);
        setPosition(position);
        setSalary(salary);
        return null;
    }

    public void ejbPostCreate (String id, String name, String position,
        double salary) throws CreateException { }

    public abstract java.util.Collection getTeams();
    
    public abstract void setTeams(java.util.Collection teams);
    
}
