/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package bookstore.database;

import bookstore.exception.*;
import java.util.Collection;

public class BookDB implements java.io.Serializable {

  private String bookId = "0";
  private BookDBAO database = null;

  public BookDB () {
  }

  public void setBookId(String bookId) {
    this.bookId = bookId;
  }
    
  public void setDatabase(BookDBAO database) {
    this.database = database;
  }

  public BookDetails getBookDetails() throws Exception {
    try {
        return (BookDetails)database.getBookDetails(bookId);        
    } catch (BookNotFoundException ex) {
        throw ex;
    } 
  }

  public Collection getBooks() throws Exception {
    try {
        return database.getBooks();
    } catch (BooksNotFoundException ex) {
        throw ex;
    } 

  }

  public int getNumberOfBooks() throws Exception {
    try {
        return database.getNumberOfBooks();
    } catch (BooksNotFoundException ex) {
        throw ex;
    }     
  }
}
