/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */



package jaxrpcmejb;

import java.io.*;
import java.util.*;
import javax.naming.*;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.Call;
import javax.management.*;
import javax.swing.JOptionPane;
import com.sun.enterprise.management.agent.ws.*;

public class Client {
    
    private String targetEndpointAddress;
    
    public static void main(String[] args) {
        Client client = new Client(args);
        client.doTest();        
    }
    
    public Client(String[] args) {
        targetEndpointAddress = (args.length > 0) ? args[0] : null;
    }

    public void doTest() {
        try {
            ManagementWSTransiever mejb = new ManagementWSTransiever(targetEndpointAddress);
            
            
            //getDefaultDomain
            String defaultDomain =
            mejb.getDefaultDomain();
            System.err.println("Default Domain = " + defaultDomain);
            
            //getMBeanCount
            Integer mBeanCount =
            mejb.getMBeanCount();
            System.err.println("Number of MBeans = " + mBeanCount);
            
            //queryNames
            ObjectName query = new ObjectName("*:*");
            Set objectNameSet = mejb.queryNames(query, null);
            System.err.println("queryNames " + query + " found " + objectNameSet.size() + " names");
            ObjectName [] objectNames =
            (ObjectName [])objectNameSet.toArray(new ObjectName [] {});
            
            //isRegistered
            boolean registered = mejb.isRegistered(objectNames[0]);
            System.err.println("test isRegistered = " + registered);

            //addNotificationListener to the MBeanServerDelegate object
            query = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            
            Set mYobjectNameSet = mejb.queryNames(query, null);
            System.err.println("queryNames " + query + " found " + mYobjectNameSet.size() + " names");
            ObjectName [] mYobjectNames =
            (ObjectName [])mYobjectNameSet.toArray(new ObjectName [] {});
            javax.management.j2ee.ListenerRegistration lr = mejb.getListenerRegistry();
            SimpleNotificationListener ml = new SimpleNotificationListener();
            lr.addNotificationListener(mYobjectNames[0], ml, null, "MEJB WS Test");

            
            // Print info of all MBeans in the set
            Iterator it = mYobjectNameSet.iterator();
            int count=0;
            while ( it.hasNext() ) {
                
                ObjectName name = (ObjectName)it.next();
                System.err.println("\n [ " + count++ + " ]");
                System.err.println("\nObjectName: "+ name);
                
                // MBeanInfo
                MBeanInfo info = mejb.getMBeanInfo(name);
                
                //Description
                System.err.println("Description: " + info.getDescription());
                
                //Attributes
                System.err.println("\n***  Attributes   ***\n");
                MBeanAttributeInfo[] attrInfo = info.getAttributes();
                //String[] attrNames = new String[attrInfo.length];
                for ( int i=0; i<attrInfo.length; i++ ) {
                    //attrNames[i] = attrInfo[i].getName();
                    try {
                        Object o = mejb.getAttribute(name, attrInfo[i].getName());
                        System.err.println("name: " + attrInfo[i].getName() + " value: " + o);
                    } catch (java.rmi.ServerException se) {
                        System.err.println("Failed to retrieve attribute: " + attrInfo[i].getName() + " message: " + se.getMessage());
                    }
                    
                }
                System.err.println("*********************\n");
                
                //Constructors
                System.err.println("\n*** Constructors  ***\n");
                MBeanConstructorInfo[] consInfo = info.getConstructors();
                for ( int i=0; i<consInfo.length; i++ ) {
                    System.err.println("Description: " + consInfo[i].getDescription());
                    System.err.print(consInfo[i].getName() + "( ");
                    MBeanParameterInfo[] params = consInfo[i].getSignature();
                    if (params.length > 0 ) {
                        int p;
                        for(p=0; p<params.length -1;p++) {
                            System.err.print(params[p] + ", ");
                        }
                        System.err.println(params[p] + " )\n");
                    } else {
                        System.err.println(")");
                    }
                }
                System.err.println("*********************\n");
                
                //Notifications
                System.err.println("\n*** Notifications ***\n");
                MBeanNotificationInfo[] notInfo = info.getNotifications();
                for ( int i=0; i<notInfo.length; i++ ) {
                    System.err.println("Name: " + notInfo[i].getName());
                    System.err.println("Description: " + notInfo[i].getDescription());
                    String[] types = notInfo[i].getNotifTypes();
                    int p;
                    for(p=0; p<types.length;p++) {
                        System.err.println(types[p]);
                    }
                }
                System.err.println("*********************\n");
                
                //Operations
                System.err.println("\n***  Operations   ***\n");
                MBeanOperationInfo[] opsInfo = info.getOperations();
                for ( int i=0; i<opsInfo.length; i++ ) {
                    System.err.println("Description: " + opsInfo[i].getDescription());
                    System.err.print(opsInfo[i].getReturnType() + " " + opsInfo[i].getName() + "( ");
                    MBeanParameterInfo[] params = opsInfo[i].getSignature();
                    
                    if (params.length > 0) {
                        int p;
                        for(p=0; p<params.length-1;p++) {
                            System.err.print(params[p] + ", ");
                        }
                        System.err.println(params[p] + " )\n");
                    } else {
                        System.err.println(")");
                    }
                }
                System.err.println("*********************\n");
                System.err.println(" \n");
            }
        } catch (Exception ex) {
            System.err.println("mejb port client test failed");
            ex.printStackTrace();
        }
        
        return;
    }
    
    

 
}

