/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.management.agent.ws;

import javax.management.ObjectName;

/**
 * A Simple wrapper class that is used to Serialize and deserialize
 * javax.management.Notification objects. This can be removed once
 * javax.management.Notification adds a "No Arg Constructor" .
 */

public class LocalNotificationObject implements java.io.Serializable {

    private String type;
    private long sequenceNumber;
    private long timeStamp;
    private Object userData;
    private String message;
    private String sourceObjectName;
    private String mbeanName = null;
    
    public LocalNotificationObject( ) { }

    public LocalNotificationObject( javax.management.Notification n ) {
        type = n.getType( );
        sequenceNumber = n.getSequenceNumber( );
        timeStamp = n.getTimeStamp( );
        userData = n.getUserData( );
        message = n.getMessage( );
        sourceObjectName =  (( ObjectName )n.getSource( )).toString();
        if (n instanceof javax.management.MBeanServerNotification) {
            mbeanName = ((javax.management.MBeanServerNotification)n).getMBeanName().toString();
        }        
    }

    public void setType( String t ) { type = t; }

    public String getType( ) { return type; }

    public void setSequenceNumber( long n ) { sequenceNumber = n; }

    public long getSequenceNumber( ) { return sequenceNumber; }

    public void setTimeStamp( long t ) { timeStamp = t; }

    public long getTimeStamp( ) { return timeStamp; }

    public void setUserData( Object o ) { userData = o; }

    public Object getUserData( ) { return userData; }

    public void setMessage( String m ) { message = m; }

    public String getMessage( ) { return message; }

    public void setSourceObjectName( String n ) { sourceObjectName = n; }

    public String getSourceObjectName( ) { return sourceObjectName; }

    public void setMBeanName( String n ) { mbeanName = n; }

    public String getMBeanName( ) { return mbeanName; }

    public javax.management.Notification getNotificationObject( ) {
        if (getMBeanName() != null) {
            try {
                ObjectName mbon = new ObjectName(getMBeanName());            
                return new javax.management.MBeanServerNotification(type, sourceObjectName, sequenceNumber, mbon);
            } catch (Exception e) {
            }
        }
        return new javax.management.Notification( type, sourceObjectName,
            sequenceNumber, timeStamp, message );
    } 

}

