/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.management.agent.ws;

import java.io.*;

import org.xml.sax.*;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;

import org.exolab.castor.xml.Unmarshaller; 
import org.exolab.castor.xml.Marshaller; 
import javax.management.AttributeList;
import java.io.StringWriter;

public class AttributeListSerializer {
   public static String marshal( AttributeList attrList ) {
       try {
           StringWriter writer = new StringWriter( );

           for( int i = 0; i < attrList.size( ); i++ ) {
               if ( attrList.get( i ) != null ) {
                   Marshaller.marshal( attrList.get( i ), writer );
               }
           }

           String beforeCleanup = writer.toString( );


           StringBuffer afterCleanup = new StringBuffer(
               "<?xml version=\"1.0\"?>" );

           afterCleanup.append( " <AttributeList>\n" );

           int beginIndex = 0;
           int nextIndex = 0;
           while( beginIndex != -1 ) {
               beginIndex = beforeCleanup.indexOf( "<attribute>", beginIndex );
               if( beginIndex != -1 ) {
                   nextIndex = beforeCleanup.indexOf("</attribute>",beginIndex);
                   nextIndex = nextIndex + 12;
                   afterCleanup.append( beforeCleanup.substring( beginIndex,
                       nextIndex) );
                   beginIndex = nextIndex;
               }
           }

           afterCleanup.append( "</AttributeList>" );

           return afterCleanup.toString( );
       } catch( Exception e ) {
           System.err.println( e );
           e.printStackTrace( );
       }
       // To Keep Javac happy
       return null;
   }

   public static AttributeList unmarshal( String serializedAttributeList ) {
       try {

           SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();

           AttributeListSaxHandler saxHandler = new AttributeListSaxHandler( );

           org.xml.sax.InputSource is = new org.xml.sax.InputSource(
               new StringReader( serializedAttributeList ) );

           saxParser.parse( is , saxHandler );

           return saxHandler.getAttributeList ( );
       } catch( Exception e ) {
           System.err.println( e );
           e.printStackTrace( );
       }
       // To Keep Javac happy
       return null;
   }
       
}
