/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.management.agent;

import java.security.*;
import java.rmi.RemoteException;
import java.util.*;
import java.io.ObjectInputStream;
import javax.ejb.*;
import javax.management.*;
import javax.management.j2ee.*;
import javax.naming.*;

import com.sun.enterprise.management.agent.ws.*;
import java.io.StringWriter;

/**
 * This is a modification to MEJBBean which supports a WSDL port
 * to the standard management functions in javax.management.j2ee.Management
 *
 *  @author Hans Hrasna
 */
public class MEJBWebServiceBean implements SessionBean {
    private SessionContext ctx;
    private MEJBUtility mejbUtility = null;
    private Hashtable listeners = new Hashtable(); //table of listeners keyed by callbackURI
    
    public void setSessionContext(SessionContext context) {
        ctx = context;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void ejbCreate() throws CreateException {
        this.mejbUtility = MEJBUtility.getMEJBUtility();
    }

    // javax.management.j2ee.Management implementation starts here

    /**
     * Gets the names of managed objects controlled by the MEJB. This method
     * enables any of the following to be obtained: The names of all managed objects,
     * the names of a set of managed objects specified by pattern matching on the
     * <CODE>ObjectName</CODE> and/or a Query expression, a specific managed object name (equivalent to
     * testing whether an managed object is registered). When the object name is
     * null or no domain and key properties are specified, all objects are selected (and filtered if a
     * query is specified). It returns the set of ObjectNames for the managed objects selected.
     * @param name The object name pattern identifying the managed objects to be retrieved. If
     * null or no domain and key properties are specified, all the managed objects registered will be retrieved.
     * @param query The query expression to be applied for selecting managed objects. If null
     * no query expression will be applied for selecting managed objects.
     * @return  A set containing the ObjectNames for the managed objects selected.
     * If no managed object satisfies the query, an empty list is returned.
     */
    public Set queryNames(ObjectName name, QueryExp query) throws RemoteException {
        try{
            return this.mejbUtility.queryNames(name,query);
        }catch(Exception ex){
            throw new RemoteException(this.toString() +"::queryNames", ex);
        }
    }

	/* WS version */
    public Set queryNames(String objectName, String query) throws RemoteException {
        ObjectName n = null;
        QueryExp q = null;
        try {
			n = new ObjectName(objectName);
            if (query != null) {
				//TO FIX !!!
				System.out.println("Received query string: " + query);
            }
	        Set objectNames = this.mejbUtility.queryNames(n,q);
            Iterator i = objectNames.iterator();
            Set stringNames = new HashSet(); 
            while(i.hasNext()) {
                String name = ((ObjectName)i.next()).toString();
                stringNames.add(name);
            }
            return stringNames;

        } catch(Exception ex){
			System.out.println(ex);
            throw new RemoteException(this.toString() +"::queryNames", ex);
        }
    }
			

    /**
     * Checks whether an MBean, identified by its object name, is already registered with the MBean server.
     * @param name The object name of the MBean to be checked.
     * @return  True if the MBean is already registered in the MBean server, false otherwise.
     */
    public boolean isRegistered(ObjectName name) throws RemoteException {
        try{
            return this.mejbUtility.isRegistered(name);
        }catch(Exception ex){
            throw new RemoteException(this.toString() +"::isRegistered", ex);
        }
    }

    /* WS version */
    public boolean isRegistered(String name) throws RemoteException {
	    ObjectName n = null;
        try {
            n = new ObjectName(name);
        } catch(Exception ex){
            throw new RemoteException(this.toString() +"::isRegistered", ex);
        }
        return isRegistered(n);
    }	

    /** Returns the number of MBeans registered in the MBean server. */
    public Integer getMBeanCount() throws RemoteException {
        try{
            return this.mejbUtility.getMBeanCount();
        }catch(Exception ex){
            throw new RemoteException(this.toString() +"::getMBeanCount", ex);
        }
    }

    /**
     * This method discovers the attributes and operations that an MBean exposes for management.
     * @param name The name of the MBean to analyze
     * @return  An instance of <CODE>MBeanInfo</CODE> allowing the retrieval of all attributes and operations of this MBean.
     * @exception IntrospectionException An exception occurs during introspection.
     * @exception InstanceNotFoundException The MBean specified is not found.
     * @exception ReflectionException An exception occurred when trying to invoke the getMBeanInfo of a Dynamic MBean.
     */
    public MBeanInfo getMBeanInfo(ObjectName name) throws javax.management.InstanceNotFoundException,
        javax.management.IntrospectionException, javax.management.ReflectionException, RemoteException {
        return this.mejbUtility.getMBeanInfo(name);
    }

    /* WS version */
    public String getMBeanInfo(String name) throws RemoteException {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(name);
            MBeanInfo beanInfo = mejbUtility.getMBeanInfo(objectName);
            // Marshal the object
            String serializedMBeanInfo = MBeanInfoSerializer.marshal(beanInfo);
            return serializedMBeanInfo;
        } catch(Exception ex){
			System.out.println(ex);
            throw new RemoteException(this.toString() +"::getAttribute", ex);
        }
    }

    /**
     * Gets the value of a specific attribute of a named MBean. The MBean is identified by its object name.
     * @param name The object name of the MBean from which the attribute is to be retrieved.
     * @param attribute A String specifying the name of the attribute to be retrieved.
     * @return  The value of the retrieved attribute.
     * @exception AttributeNotFoundException The attribute specified is not accessible in the MBean.
     * @exception MBeanException  Wraps an exception thrown by the MBean's getter.
     * @exception InstanceNotFoundException The MBean specified is not registered in the MBean server.
     * @exception ReflectionException  Wraps a <CODE>java.lang.Exception</CODE> thrown when trying to invoke the setter.
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The object name in
     * parameter is null or the attribute in parameter is null.
     */
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException,
        javax.management.AttributeNotFoundException, javax.management.InstanceNotFoundException,
        javax.management.ReflectionException, RemoteException {
        return this.mejbUtility.getAttribute(name,attribute);
    }

    /* WS version */
    public Object getAttribute(String name, String attribute) throws RemoteException {
        ObjectName n = null;
        try {
            n = new ObjectName(name);
			return getAttribute(n,attribute);
        } catch(Exception ex){
            throw new RemoteException(this.toString() +"::getAttribute", ex);
        }
    }

    /**
     * Enables the values of several attributes of a named MBean. The MBean is identified by its object name.
     * @param name The object name of the MBean from which the attributes are retrieved.
     * @param attributes A list of the attributes to be retrieved.
     * @return The list of the retrieved attributes.
     * @exception InstanceNotFoundException The MBean specified is not registered in the MBean server.
     * @exception ReflectionException An exception occurred when trying to invoke the getAttributes method of a Dynamic MBean.
     * @exception RuntimeOperationsException Wrap a <CODE>java.lang.IllegalArgumentException</CODE>: The object name in
     * parameter is null or attributes in parameter is null.
     */
    public javax.management.AttributeList getAttributes(ObjectName name, String [] attributes)
        throws javax.management.InstanceNotFoundException, javax.management.ReflectionException, RemoteException {
        return this.mejbUtility.getAttributes(name,attributes);
    }


    /* WS version */
    public String getAttributes(String name, Set attributes) throws RemoteException {
		ObjectName n = null;
        try {
            n = new ObjectName(name);
			String [] atts = (String [])(attributes.toArray(new String []{}));
            System.out.println("getAttributes for " + name); 
            for ( int i=0; i<atts.length; i++ ) { 
                System.out.println("name = " + atts[i]); 
            }
			AttributeList al = mejbUtility.getAttributes(n, atts);
			if (al != null) {
                Object [] attrs = al.toArray();
                System.out.println("Attributes retrieved for " + name);
                for ( int i=0; i<attrs.length; i++ ) {
                    if ( attrs[i] instanceof Attribute ) {
                        System.out.println("name = " + ((Attribute)attrs[i]).getName());
                        System.out.println("value = " + ((Attribute)attrs[i]).getValue()); 
                    } else {
                        System.out.println("WARNING: AttributeList contains bad type: " + attrs[i]);
                    }
                }
			    return AttributeListSerializer.marshal(al);
            } else {
                System.out.println("WARINING: AttributeList for " + name + " is null");            }
            return null;
        } catch(Exception ex){
            throw new RemoteException(this.toString() +"::getAttribute", ex);
        }
    }

    /**
     * Sets the value of a specific attribute of a named MBean. The MBean is identified by its object name.
     * @param name The name of the MBean within which the attribute is to be set.
     * @param attribute The identification of the attribute to be set and the value it is to be set to.
     * @return  The value of the attribute that has been set.
     * @exception InstanceNotFoundException The MBean specified is not registered in the MBean server.
     * @exception AttributeNotFoundException The attribute specified is not accessible in the MBean.
     * @exception InvalidAttributeValueException The value specified for the attribute is not valid.
     * @exception MBeanException Wraps an exception thrown by the MBean's setter.
     * @exception ReflectionException  Wraps a <CODE>java.lang.Exception</CODE> thrown when trying to invoke the setter.
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The object name in
     * parameter is null or the attribute in parameter is null.
     */
    public void setAttribute(ObjectName name, javax.management.Attribute attribute)
        throws javax.management.InstanceNotFoundException, javax.management.AttributeNotFoundException,
        javax.management.InvalidAttributeValueException, MBeanException,
        javax.management.ReflectionException, RemoteException {
	this.mejbUtility.setAttribute(name,attribute);
    }

    /* WS version */
   public void setAttribute(String name, String attributeName, String value) throws RemoteException {
        ObjectName n = null;
        Attribute a = null;
        try {
            n = new ObjectName(name);
            a = new Attribute(attributeName, value);
            setAttribute(n,a);
        } catch(Exception ex){
            throw new RemoteException(this.toString() +"::setAttribute", ex);
        }
    }

    /**
     * Sets the values of several attributes of a named MBean. The MBean is identified by its object name.
     * @param name The object name of the MBean within which the attributes are to be set.
     * @param attributes A list of attributes: The identification of the
     * attributes to be set and  the values they are to be set to.
     * @return  The list of attributes that were set, with their new values.
     * @exception InstanceNotFoundException The MBean specified is not registered in the MBean server.
     * @exception ReflectionException An exception occurred when trying to invoke the getAttributes method of a Dynamic MBean.
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The object name in
     * parameter is null or attributes in parameter is null.
     */
    public javax.management.AttributeList setAttributes(ObjectName name, javax.management.AttributeList attributes)
        throws javax.management.InstanceNotFoundException, javax.management.ReflectionException, RemoteException {
        return this.mejbUtility.setAttributes(name,attributes);
    }

    /* WS version */
    public String setAttributes(String name, String xmlAttributeList) throws RemoteException {
        ObjectName n = null;
        AttributeList al = null;
        try {
            n = new ObjectName(name);
            al = AttributeListSerializer.unmarshal(xmlAttributeList);
            AttributeList newAtts = setAttributes(n,al);
            return AttributeListSerializer.marshal(newAtts);
        } catch(Exception ex){
            throw new RemoteException(this.toString() +"::setAttributes", ex);
        }
    }

    /**
     * Invokes an operation on an MBean.
     * @param name The object name of the MBean on which the method is to be invoked.
     * @param operationName The name of the operation to be invoked.
     * @param params An array containing the parameters to be set when the operation is invoked
     * @param signature An array containing the signature of the operation. The class objects will
     * be loaded using the same class loader as the one used for loading the MBean on which the operation was invoked.
     * @return  The object returned by the operation, which represents the result ofinvoking the operation
     * on the MBean specified.
     * @exception InstanceNotFoundException The MBean specified is not registered in the MBean server.
     * @exception MBeanException  Wraps an exception thrown by the MBean's invoked method.
     * @exception ReflectionException  Wraps a <CODE>java.lang.Exception</CODE> thrown while trying to invoke the method.
     */
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature)
        throws javax.management.InstanceNotFoundException, MBeanException,
        javax.management.ReflectionException, RemoteException {
        return this.mejbUtility.invoke(name,operationName,params,signature);
    }

    /* WS version */
    public Object invoke(String name, String operationName, Set params, Set sig) throws InstanceNotFoundException, RemoteException {
        ObjectName n = null;
        try {
            n = new ObjectName(name);
			Object [] parameters = params.toArray();
			String [] signature = (String [])sig.toArray(new String [] {});
            return invoke(n,operationName,parameters,signature);
        } catch(Exception ex){
            throw new RemoteException(this.toString() +"::invoke", ex);
        }
    }
    /**
     * Returns the default domain used for naming the managed object.
     * The default domain name is used as the domain part in the ObjectName
     * of managed objects if no domain is specified by the user.
     */
    public String getDefaultDomain() throws RemoteException {
        return this.mejbUtility.getDefaultDomain();
    }

    /*
     * returns the ListenerRegistry implementation for this MEJB
     */

    public ListenerRegistration getListenerRegistry() throws RemoteException {
        return this.mejbUtility.getListenerRegistry();
    }

    //called by AppContainer to register an AppClientModule MO if it wasn't registered during deployment
    public void registerAppClient(com.sun.enterprise.deployment.ApplicationClientDescriptor d) throws RemoteException, java.io.IOException {
       /* Hans, i Extracted MEJBUtility.class from appserv-rt.jar and did ajavap on the class
        and there is no method of this name or signature
        this.mejbUtility.registerAppClient(d);
        *
        *Compiled from MEJBUtility.java
public class com.sun.enterprise.management.agent.MEJBUtility extends java.lang.O
bject {
    public static com.sun.enterprise.management.agent.MEJBUtility getMEJBUtility
();

    public java.util.Set queryNames(javax.management.ObjectName, javax.managemen
t.QueryExp) throws java.lang.Exception;

    public boolean isRegistered(javax.management.ObjectName) throws java.lang.Ex
ception;

    public java.lang.Integer getMBeanCount() throws java.lang.Exception;

    public javax.management.MBeanInfo getMBeanInfo(javax.management.ObjectName)
throws javax.management.InstanceNotFoundException, javax.management.Introspectio
nException, javax.management.ReflectionException, java.rmi.RemoteException;

    public java.lang.Object getAttribute(javax.management.ObjectName, java.lang.
String) throws javax.management.MBeanException, javax.management.AttributeNotFou
ndException, javax.management.InstanceNotFoundException, javax.management.Reflec
tionException, java.rmi.RemoteException;

    public javax.management.AttributeList getAttributes(javax.management.ObjectN
ame, java.lang.String[]) throws javax.management.InstanceNotFoundException, java
x.management.ReflectionException, java.rmi.RemoteException;

    public void setAttribute(javax.management.ObjectName, javax.management.Attri
bute) throws javax.management.InstanceNotFoundException, javax.management.Attrib
uteNotFoundException, javax.management.InvalidAttributeValueException, javax.man
agement.MBeanException, javax.management.ReflectionException, java.rmi.RemoteExc
eption;

    public javax.management.AttributeList setAttributes(javax.management.ObjectN
ame, javax.management.AttributeList) throws javax.management.InstanceNotFoundExc
eption, javax.management.ReflectionException, java.rmi.RemoteException;
       
            public java.lang.Object invoke(javax.management.ObjectName, java.lang.String
, java.lang.Object[], java.lang.String[]) throws javax.management.InstanceNotFou
ndException, javax.management.MBeanException, javax.management.ReflectionExcepti
on, java.rmi.RemoteException;

    public java.lang.String getDefaultDomain();

    public javax.management.j2ee.ListenerRegistration getListenerRegistry();

    public java.lang.Object instantiate(java.lang.String) throws javax.managemen
t.ReflectionException, javax.management.MBeanException, java.rmi.RemoteException
;

    public java.lang.Object instantiate(java.lang.String, javax.management.Objec
tName) throws javax.management.ReflectionException, javax.management.MBeanExcept
ion, javax.management.InstanceNotFoundException, java.rmi.RemoteException;

    public java.lang.Object instantiate(java.lang.String, java.lang.Object[], ja
va.lang.String[]) throws javax.management.ReflectionException, javax.management.
MBeanException, java.rmi.RemoteException;

    public java.lang.Object instantiate(java.lang.String, javax.management.Objec
tName, java.lang.Object[], java.lang.String[]) throws javax.management.Reflectio
nException, javax.management.MBeanException, javax.management.InstanceNotFoundEx
ception, java.rmi.RemoteException;

    public javax.management.ObjectInstance createMBean(java.lang.String, javax.m
anagement.ObjectName) throws javax.management.ReflectionException, javax.managem
ent.InstanceAlreadyExistsException, javax.management.MBeanRegistrationException,
 javax.management.MBeanException, javax.management.NotCompliantMBeanException, j
ava.rmi.RemoteException;
        
        *    public javax.management.ObjectInstance createMBean(java.lang.String, javax.m
anagement.ObjectName, javax.management.ObjectName) throws javax.management.Refle
ctionException, javax.management.InstanceAlreadyExistsException, javax.managemen
t.MBeanRegistrationException, javax.management.MBeanException, javax.management.
NotCompliantMBeanException, javax.management.InstanceNotFoundException, java.rmi
.RemoteException;

    public javax.management.ObjectInstance createMBean(java.lang.String, javax.m
anagement.ObjectName, java.lang.Object[], java.lang.String[]) throws javax.manag
ement.ReflectionException, javax.management.InstanceAlreadyExistsException, java
x.management.MBeanRegistrationException, javax.management.MBeanException, javax.
management.NotCompliantMBeanException, java.rmi.RemoteException;

    public javax.management.ObjectInstance createMBean(java.lang.String, javax.m
anagement.ObjectName, javax.management.ObjectName, java.lang.Object[], java.lang
.String[]) throws javax.management.ReflectionException, javax.management.Instanc
eAlreadyExistsException, javax.management.MBeanRegistrationException, javax.mana
gement.MBeanException, javax.management.NotCompliantMBeanException, javax.manage
ment.InstanceNotFoundException, java.rmi.RemoteException;

    public javax.management.ObjectInstance registerMBean(java.lang.Object, javax
.management.ObjectName) throws javax.management.InstanceAlreadyExistsException,
javax.management.MBeanRegistrationException, javax.management.NotCompliantMBeanE
xception, java.rmi.RemoteException;

    public void unregisterMBean(javax.management.ObjectName) throws javax.manage
ment.InstanceNotFoundException, javax.management.MBeanRegistrationException, jav
a.rmi.RemoteException;

    public javax.management.ObjectInstance getObjectInstance(javax.management.Ob
jectName) throws javax.management.InstanceNotFoundException, java.rmi.RemoteExce
ption;     

    public java.util.Set queryMBeans(javax.management.ObjectName, javax.manageme
nt.QueryExp) throws java.rmi.RemoteException;

    public void addNotificationListener(javax.management.ObjectName, javax.manag
ement.NotificationListener, javax.management.NotificationFilter, java.lang.Objec
t) throws javax.management.InstanceNotFoundException, java.rmi.RemoteException;

    public void addNotificationListener(javax.management.ObjectName, javax.manag
ement.ObjectName, javax.management.NotificationFilter, java.lang.Object) throws
javax.management.InstanceNotFoundException, java.rmi.RemoteException;

    public void removeNotificationListener(javax.management.ObjectName, javax.ma
nagement.NotificationListener) throws javax.management.InstanceNotFoundException
, javax.management.ListenerNotFoundException, java.rmi.RemoteException;

    public void removeNotificationListener(javax.management.ObjectName, javax.ma
nagement.ObjectName) throws javax.management.InstanceNotFoundException, javax.ma
nagement.ListenerNotFoundException, java.rmi.RemoteException;

    public boolean isInstanceOf(javax.management.ObjectName, java.lang.String) t
hrows javax.management.InstanceNotFoundException, java.rmi.RemoteException;
    static {};
}
        **/
    }

    // Additional MBeanServer interface implementation starts here

    /**
     * Instantiates an object using the list of all class loaders registered
     * in the MBean server ({ javax.management.loading.DefaultLoaderRepository Default Loader Repository}).
     * The object's class should have a public constructor. It returns a reference to the newly created object.
     * The newly created object is not registered in the MBean server.
     * @param className The class name of the object to be instantiated.
     * @return The newly instantiated object.
     * @exception ReflectionException Wraps a <CODE>java.lang.ClassNotFoundException</CODE> or the
     * <CODE>java.lang.Exception</CODE> that occurred when trying to invoke the object's constructor.
     * @exception MBeanException The constructor of the object has thrown an exception
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The className
     * passed in parameter is null.
     */
    public Object instantiate(String className) throws javax.management.ReflectionException, MBeanException, RemoteException {
        return this.mejbUtility.instantiate(className);
    }

    /**
     * Instantiates an object using the class Loader specified by its <CODE>ObjectName</CODE>.
     * If the loader name is null, the ClassLoader that loaded the MBean Server will be used.
     * The object's class should have a public constructor. It returns a reference to the newly created object.
     * The newly created object is not registered in the MBean server.
     * @param className The class name of the MBean to be instantiated.
     * @param loaderName The object name of the class loader to be used.
     * @return The newly instantiated object.
     * @exception ReflectionException Wraps a <CODE>java.lang.ClassNotFoundException</CODE> or the
     * <CODE>java.lang.Exception</CODE> that occurred when trying to invoke the object's constructor.
     * @exception MBeanException The constructor of the object has thrown an exception.
     * @exception InstanceNotFoundException The specified class loader is not registered in the MBaenServer.
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The className
     * passed in parameter is null.
     */
    public Object instantiate(String className, ObjectName loaderName) throws javax.management.ReflectionException,
        MBeanException, javax.management.InstanceNotFoundException, RemoteException {
            return this.mejbUtility.instantiate(className, loaderName);
    }

    /**
     * Instantiates an object using the list of all class loaders registered
     * in the MBean server ({ javax.management.loading.DefaultLoaderRepository Default Loader Repository}).
     * The object's class should have a public constructor. The call returns a reference to the newly created object.
     * The newly created object is not registered in the MBean server.
     * @param className The class name of the object to be instantiated.
     * @param params An array containing the parameters of the constructor to be invoked.
     * @param signature An array containing the signature of the constructor to be invoked.
     * @return The newly instantiated object.
     * @exception ReflectionException Wraps a <CODE>java.lang.ClassNotFoundException</CODE> or the
     * <CODE>java.lang.Exception</CODE> that occurred when trying to invoke the object's constructor.
     * @exception MBeanException The constructor of the object has thrown an exception
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The className
     * passed in parameter is null.
     */
    public Object instantiate(String className, Object[] params, String[] signature) throws javax.management.ReflectionException,
        MBeanException, RemoteException {
            return this.mejbUtility.instantiate(className, params, signature);
    }

    /**
     * Instantiates an object. The class loader to be used is identified by its object
     * name. If the object name of the loader is null, the ClassLoader that loaded the MBean server will be used.
     * The object's class should have a public constructor. The call returns a reference to the newly created object.
     * The newly created object is not registered in the MBean server.
     * @param className The class name of the object to be instantiated.
     * @param params An array containing the parameters of the constructor to be invoked.
     * @param signature An array containing the signature of the constructor to be invoked.
     * @param loaderName The object name of the class loader to be used.
     * @return The newly instantiated object.
     * @exception ReflectionException Wraps a <CODE>java.lang.ClassNotFoundException</CODE> or the
     * <CODE>java.lang.Exception</CODE> that occurred when trying to invoke the object's constructor.
     * @exception MBeanException The constructor of the object has thrown an exception
     * @exception InstanceNotFoundException The specified class loader is not registered in the MBean server.
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The className
     * passed in parameter is null.
     */
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature)
        throws javax.management.ReflectionException, MBeanException,
        javax.management.InstanceNotFoundException, RemoteException {
            return this.mejbUtility.instantiate(className, loaderName, params, signature);
    }

    /**
     * Instantiates and registers an MBean in the MBean server. The MBean server will use the {
     * javax.management.loading.DefaultLoaderRepository Default Loader Repository} to load the class of the MBean.
     * An object name is associated to the MBean. If the object name given is null, the MBean can automatically provide its
     * own name by implementing the { javax.management.MBeanRegistration MBeanRegistration} interface. The call returns
     * an <CODE>ObjectInstance</CODE> object representing the newly created MBean.
     * @param className The class name of the MBean to be instantiated.
     * @param name The object name of the MBean. May be null.
     * @return  An <CODE>ObjectInstance</CODE>, containing the <CODE>ObjectName</CODE> and the Java class name
     * of the newly instantiated MBean.
     * @exception ReflectionException Wraps a <CODE>java.lang.ClassNotFoundException</CODE> or a
     * <CODE><CODE>java.lang.Exception</CODE></CODE> that occurred when trying to invoke the MBean's constructor.
     * @exception InstanceAlreadyExistsException The MBean is already under the control of the MBean server.
     * @exception MBeanRegistrationException The <CODE>preRegister</CODE> (<CODE>MBeanRegistration</CODE> interface) method of
     * the MBean has thrown an exception. The MBean will not be registered.
     * @exception MBeanException The constructor of the MBean has thrown an exception
     * @exception NotCompliantMBeanException This class is not a JMX compliant MBean
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The className passed in
     * parameter is null, the <CODE>ObjectName</CODE> passed in parameter contains a pattern or no <CODE>ObjectName</CODE> is
     * specified for the MBean.
     */
    public ObjectInstance createMBean(String className, ObjectName name) throws javax.management.ReflectionException,
        javax.management.InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException,
        NotCompliantMBeanException, RemoteException {
            return this.mejbUtility.createMBean(className, name);
    }

    /**
     * Instantiates and registers an MBean in the MBean server. The class loader to be used is identified by its object  name.
     * An object name is associated to the MBean. If the object name  of the loader is null, the ClassLoader that loaded the
     * MBean server will be used. If the MBean's object name given is null, the MBean can automatically provide its
     * own name by implementing the { javax.management.MBeanRegistration MBeanRegistration} interface. The call returns
     * an <CODE>ObjectInstance</CODE> object representing the newly created MBean.
     * @param className The class name of the MBean to be instantiated.
     * @param name The object name of the MBean. May be null.
     * @param loaderName The object name of the class loader to be used.
     * @return  An <CODE>ObjectInstance</CODE>, containing the <CODE>ObjectName</CODE> and the Java class name
     * of the newly instantiated MBean.
     * @exception ReflectionException  Wraps a <CODE>java.lang.ClassNotFoundException</CODE> or a
     * <CODE>java.lang.Exception</CODE> that occurred when trying to invoke the MBean's constructor.
     * @exception InstanceAlreadyExistsException The MBean is already under the control of the MBean server.
     * @exception MBeanRegistrationException The <CODE>preRegister</CODE> (<CODE>MBeanRegistration</CODE>  interface) method
     * of the MBean has thrown an exception. The MBean will not be registered.
     * @exception MBeanException The constructor of the MBean has thrown an exception
     * @exception NotCompliantMBeanException This class is not a JMX compliant MBean
     * @exception InstanceNotFoundException The specified class loader is not registered in the MBean server.
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The className passed in
     * parameter is null, the <CODE>ObjectName</CODE> passed in parameter contains a pattern or no <CODE>ObjectName</CODE> is
     * specified for the MBean.
     */
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName)
        throws javax.management.ReflectionException, javax.management.InstanceAlreadyExistsException,
        MBeanRegistrationException, MBeanException, NotCompliantMBeanException,
        javax.management.InstanceNotFoundException, RemoteException {
            return this.mejbUtility.createMBean(className, name, loaderName);
    }

    /**
     * Instantiates and registers an MBean in the MBean server.
     * The MBean server will use the { javax.management.loading.DefaultLoaderRepository Default Loader Repository}
     * to load the class of the MBean. An object name is associated to the MBean. If the object name given is null, the MBean
     * can automatically provide its own name by implementing the { javax.management.MBeanRegistration MBeanRegistration}
     * interface. The call returns an <CODE>ObjectInstance</CODE> object representing the newly created MBean.
     * @param className The class name of the MBean to be instantiated.
     * @param name The object name of the MBean. May be null.
     * @param params An array containing the parameters of the constructor to be invoked.
     * @param signature An array containing the signature of the constructor to be invoked.
     * @return  An <CODE>ObjectInstance</CODE>, containing the <CODE>ObjectName</CODE> and the Java class name
     * of the newly instantiated MBean.
     * @exception ReflectionException Wraps a <CODE>java.lang.ClassNotFoundException</CODE> or a
     * <CODE>java.lang.Exception</CODE> that occurred when trying to invoke the MBean's constructor.
     * @exception InstanceAlreadyExistsException The MBean is already under the control of the MBean server.
     * @exception MBeanRegistrationException The <CODE>preRegister</CODE> (<CODE>MBeanRegistration</CODE>  interface) method
     * of the MBean has thrown an exception. The MBean will not be registered.
     * @exception MBeanException The constructor of the MBean has thrown an exception
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The className passed in
     * parameter is null, the <CODE>ObjectName</CODE> passed in parameter contains a pattern or no <CODE>ObjectName</CODE> is
     * specified for the MBean.
     */
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature)
        throws javax.management.ReflectionException, javax.management.InstanceAlreadyExistsException,
        MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
            return this.mejbUtility.createMBean(className, name, params, signature);
    }

    /**
     * Instantiates and registers an MBean in the MBean server. The class loader to be used is identified by its object
     * name. An object name is associated to the MBean. If the object name
     * of the loader is not specified, the ClassLoader that loaded the MBean server will be used.
     * If  the MBean object name given is null, the MBean can automatically provide its
     * own name by implementing the { javax.management.MBeanRegistration MBeanRegistration} interface. The call returns
     * an <CODE>ObjectInstance</CODE> object representing the newly created MBean.
     * @param className The class name of the MBean to be instantiated.
     * @param name The object name of the MBean. May be null.
     * @param params An array containing the parameters of the constructor to be invoked.
     * @param signature An array containing the signature of the constructor to be invoked.
     * @param loaderName The object name of the class loader to be used.
     * @return  An <CODE>ObjectInstance</CODE>, containing the <CODE>ObjectName</CODE> and the Java class name
     * of the newly instantiated MBean.
     * @exception ReflectionException Wraps a <CODE>java.lang.ClassNotFoundException</CODE> or a
     * <CODE>java.lang.Exception</CODE> that occurred when trying to invoke the MBean's constructor.
     * @exception InstanceAlreadyExistsException The MBean is already under the control of the MBean server.
     * @exception MBeanRegistrationException The <CODE>preRegister</CODE> (<CODE>MBeanRegistration</CODE>  interface) method
     * of the MBean has thrown an exception. The MBean will not be registered.
     * @exception MBeanException The constructor of the MBean has thrown an exception
     * @exception InstanceNotFoundException The specified class loader is not registered in the MBean server.
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The className passed in
     * parameter is null, the <CODE>ObjectName</CODE> passed in parameter contains a pattern or no <CODE>ObjectName</CODE> is
     * specified for the MBean.
     */
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature)
        throws javax.management.ReflectionException, javax.management.InstanceAlreadyExistsException,
        MBeanRegistrationException, MBeanException, NotCompliantMBeanException,
        javax.management.InstanceNotFoundException, RemoteException {
            return this.mejbUtility.createMBean(className, name, loaderName, params, signature);
    }

    /**
     * Registers a pre-existing object as an MBean with the MBean server. If the object name given is
     * null, the MBean may automatically provide its own name by implementing the
     * { javax.management.MBeanRegistration MBeanRegistration}  interface.
     * The call returns an <CODE>ObjectInstance</CODE> object representing the registered MBean.
     * @param object The  MBean to be registered as an MBean.
     * @param name The object name of the MBean. May be null.
     * @return  The <CODE>ObjectInstance</CODE> for the MBean that has been registered.
     * @exception InstanceAlreadyExistsException The MBean is already under the control of the MBean server.
     * @exception MBeanRegistrationException The <CODE>preRegister</CODE> (<CODE>MBeanRegistration</CODE>  interface) method
     * of the MBean has thrown an exception. The MBean will not be registered.
     * @exception NotCompliantMBeanException This object is not a JMX compliant MBean
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The object passed in
     * parameter is null or no object name is specified.
     */
    public ObjectInstance registerMBean(Object object, ObjectName name) throws javax.management.InstanceAlreadyExistsException,
        MBeanRegistrationException, NotCompliantMBeanException, RemoteException {
            return this.mejbUtility.registerMBean(object, name);
    }

    /**
     * De-registers an MBean from the MBean server. The MBean is identified by
     * its object name. Once the method has been invoked, the MBean may no longer be accessed by its object name.
     * @param name The object name of the MBean to be de-registered.
     * @exception InstanceNotFoundException The MBean specified is not registered in the MBean server.
     * @exception MBeanRegistrationException The preDeregister ((<CODE>MBeanRegistration</CODE>  interface) method of the MBean
     * has thrown an exception.
     * @exception RuntimeOperationsException Wraps a <CODE>java.lang.IllegalArgumentException</CODE>: The object name in
     * parameter is null or the MBean you are when trying to de-register is the { javax.management.MBeanServerDelegate
     * MBeanServerDelegate} MBean.
     */
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException,
        MBeanRegistrationException, RemoteException {
        this.mejbUtility.unregisterMBean(name);
    }

    /**
     * Gets the <CODE>ObjectInstance</CODE> for a given MBean registered with the MBean server.
     * @param name The object name of the MBean.
     * @return The <CODE>ObjectInstance</CODE> associated to the MBean specified by <VAR>name</VAR>.
     * @exception InstanceNotFoundException The MBean specified is not registered in the MBean server.
     */
    public ObjectInstance getObjectInstance(ObjectName name)
        throws javax.management.InstanceNotFoundException, RemoteException {
            return this.mejbUtility.getObjectInstance(name);
    }

    /**
     * Gets MBeans controlled by the MBean server. This method allows any
     * of the following to be obtained: All MBeans, a set of MBeans specified
     * by pattern matching on the <CODE>ObjectName</CODE> and/or a Query expression, a
     * specific MBean. When the object name is null or no domain and key properties are specified, all objects are to be
     * selected (and filtered if a query is specified). It returns the
     * set of <CODE>ObjectInstance</CODE> objects (containing the <CODE>ObjectName</CODE> and the Java Class name)
     * for the selected MBeans.
     * @param name The object name pattern identifying the MBeans to be retrieved. If
     * null or no domain and key properties are specified, all the MBeans registered will be retrieved.
     * @param query The query expression to be applied for selecting MBeans. If null
     * no query expression will be applied for selecting MBeans.
     * @return  A set containing the <CODE>ObjectInstance</CODE> objects for the selected MBeans.
     * If no MBean satisfies the query an empty list is returned.
     */
    public Set queryMBeans(ObjectName name, QueryExp query) throws RemoteException {
        return this.mejbUtility.queryMBeans(name, query);
    }

    /**
     * Returns the default domain used for naming the MBean. The default domain name is used as the domain part in the
     * ObjectName of MBeans if no domain is specified by the user.
     */
    //public String getDefaultDomain() throws RemoteException;

    /**
     * Enables to add a listener to a registered MBean.
     * @param name The name of the MBean on which the listener should be added.
     * @param listener The listener object which will handle the notifications emitted by the registered MBean.
     * @param filter The filter object. If filter is null, no filtering will be performed before handling notifications.
     * @param handback The context to be sent to the listener when a notification is emitted.
     * @exception InstanceNotFoundException The MBean name provided does not match any of the registered MBeans.
     */
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback)
        throws javax.management.InstanceNotFoundException, RemoteException {
        this.mejbUtility.addNotificationListener(name, listener, filter, handback);
    }

    /**
     * Enables to add a listener to a registered MBean.
     * @param name The name of the MBean on which the listener should be added.
     * @param listener The object name of the listener which will handle the notifications emitted by the registered MBean.
     * @param filter The filter object. If filter is null, no filtering will be performed before handling notifications.
     * @param handback The context to be sent to the listener when a notification is emitted.
     * @exception InstanceNotFoundException The MBean name of the notification listener or of the notification broadcaster
     * does not match any of the registered MBeans.
     */
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback)
        throws javax.management.InstanceNotFoundException, RemoteException {
            this.mejbUtility.addNotificationListener(name, listener, filter, handback);
    }

    /**
     * Enables to remove a listener from a registered MBean.
     * @param name The name of the MBean on which the listener should be removed.
     * @param listener The listener object which will handle the notifications emitted by the registered MBean.
     * This method will remove all the information related to this listener.
     * @exception InstanceNotFoundException The MBean name provided does not match any of the registered MBeans.
     * @exception ListenerNotFoundException The listener is not registered in the MBean.
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener)
        throws javax.management.InstanceNotFoundException, javax.management.ListenerNotFoundException, RemoteException {
        this.mejbUtility.removeNotificationListener(name, listener);
    }

    /**
     * Enables to remove a listener from a registered MBean.
     * @param name The name of the MBean on which the listener should be removed.
     * @param listener The object name of the listener which will handle the notifications emitted by the registered MBean.
     * This method will remove all the information related to this listener.
     * @exception InstanceNotFoundException The MBean name provided does not match any of the registered MBeans.
     * @exception ListenerNotFoundException The listener is not registered in the MBean.
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws javax.management.InstanceNotFoundException,
        javax.management.ListenerNotFoundException, RemoteException {
            this.mejbUtility.removeNotificationListener(name, listener);
    }

    /**
     * Returns true if the MBean specified is an instance of the specified class, false otherwise.
     * @param name The <CODE>ObjectName</CODE> of the MBean.
     * @param className The name of the class.
     * @return true if the MBean specified is an instance of the specified class, false otherwise.
     * @exception InstanceNotFoundException The MBean specified is not registered in the MBean server.
     */
    public boolean isInstanceOf(ObjectName name, String className)
        throws javax.management.InstanceNotFoundException, RemoteException {
            return this.mejbUtility.isInstanceOf(name, className);
    }


    /* WS version */
    public void addNotificationListener( String objectName, String callbackUri,
        String filter, String handbackObject ) throws RemoteException
    {
        //notificationListenerRegistry.put( objectName,
        //    callbackUri + "/" + handbackObject );
        // A Simple test to make sure it works, once this works, we should
        // do the registration with different resources and then each
        // resource can maintain their registry of callbackURIs and
        // do the notification as shown here.
        HttpNotifier notifier =
            new HttpNotifier(callbackUri + "/" + handbackObject );
        listeners.put(callbackUri,  notifier);
			//new HttpNotifier("http://dalhi.sfbay:40094/ABC/HandbackForABC");
/*
		try {
			ObjectName n = new ObjectName(objectName);
        notifier.handleNotification( new javax.management.Notification( "ABCEvent",
            n, (long) 20201, "This is an ABC Event....." ), handbackObject);
		} catch(Exception ex){
            throw new RemoteException(this.toString() +"::isRegistered", ex);
        }
*/
        ObjectName n = null;
        try {
            n = new ObjectName(objectName);
			mejbUtility.addNotificationListener(n, (NotificationListener)notifier, null, handbackObject);
        } catch(Exception ex){
            throw new RemoteException(this.toString() +"::addNotificationListener", ex);
        }
    }
    
    /* WS version */
    public void removeNotificationListener(String objectName, String callbackUri)
        throws javax.management.InstanceNotFoundException, javax.management.ListenerNotFoundException, RemoteException {
        HttpNotifier listener = (HttpNotifier)listeners.get(callbackUri);
        ObjectName n;
        try {
            n = new ObjectName(objectName);
            this.mejbUtility.removeNotificationListener(n, listener);
        } catch(Exception ex){
            throw new RemoteException(this.toString() +"::removeNotificationListener", ex);
        }
    }
}
