/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.webapps.caching;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * A simple servlet that returns the Version of the application and other
 * basic information about the application and environment. This servlet
 * is largely based on the HaServlet provided as a sample application in iAS.
 *
 */
public class ServCache extends HttpServlet {

    public void init (ServletConfig config) throws ServletException
    {
        super.init(config);

    }

    public void doGet(HttpServletRequest request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
        String InputString = request.getParameter("inputtext");

        if (request.getParameter("delivery").equals("mvc")) {
            System.out.println("Executing ServCache (MVC mode) : " +
               InputString);
	    response.setContentType("text/html");
            RequestDispatcher dispatcher;
            dispatcher = getServletContext().getRequestDispatcher
               ("/ServCache.jsp");
            dispatcher.include(request,response);
        } else {
           System.out.println("Executing ServCache (println mode) : " +
              InputString);
           deliverServlet(InputString, response);
	}

    }

    private void deliverServlet (String anInputString,
                                 HttpServletResponse aResponse)
        throws IOException
    {
        java.util.ResourceBundle rb = java.util.ResourceBundle.getBundle("LocalStrings", Locale.getDefault());
        final String title_msg = rb.getString("caching_sample");
        final String header_msg = rb.getString("cache_sample");
        final String generated_by_msg = rb.getString("generated_by");
        final String println_msg = rb.getString("println_statements");
        final String within_servlet_msg = rb.getString("within_servlet");
        final String date_created_msg = rb.getString("date_created");
        final String input_passed_msg = rb.getString("input_passed");
        final String return_to_start_msg = rb.getString("return_to_start");
        /* Send Header */
        aResponse.setContentType("text/html");
        PrintWriter out = aResponse.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso8859-1\">");
        out.println("<meta description=\"Application Server Caching Sample Application Results\">");
        /* disable browser caching so that it doesn't mask server caching. */
        out.println("<meta http-equiv=\"pragma\" content=\"no-cache\">");
        out.println("<meta http-equiv=\"expires\" content=\"-1\">");
        out.println("<title>"+title_msg+"</title>");
        out.println("</head>");

        out.println("<body>");
	out.println("<h2>"+header_msg+"</h2>");

	/* Send Body */
        out.println(generated_by_msg+": ");
        out.println("<blockquote><strong>"+println_msg+" " +
                    within_servlet_msg+".</strong></blockquote>");

	out.println(date_created_msg+": ");
        out.println("<blockquote><strong>" + new Date().toString() +
            "</strong></blockquote>");

	out.println(input_passed_msg+": ");
        out.println("<blockquote><strong>" + anInputString +
            "</strong></blockquote>");

	out.println("<a href=\"index.html\">"+return_to_start_msg+"</a>");

        out.println("</body></html>");
        out.close();
    }

}
