/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * @author Jagadesh
 */

package samples.security.ldaprealm.dynamicgroup.client;

import java.io.*;
import java.util.*;
import javax.ejb.EJBHome;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import com.sun.enterprise.security.LoginContext;
import com.sun.enterprise.security.LoginException;
import java.rmi.RemoteException;
import java.security.*;

import samples.security.ldaprealm.dynamicgroup.ejb.*;

public class LdapRealmAppClient 
{
    private static String testId = null;

    public static void main (String[] args) 
    {
        LdapRealmAppClient client = new LdapRealmAppClient();
        System.out.println("****************************************************************");
        System.out.println("* <Security> LDAP LdapRealmAppClient with DynamicGroup *");
        System.out.println("****************************************************************");
        client.doTests();
    }
    
    public LdapRealmAppClient() {
    }
    
    /**
     * Perform security related tests
     */
    public void doTests() 
    {        
	SecAuthSample hr = null;
        Context ic           = null;
        LoginContext lc      = null;
        SecAuthSampleHome home = null;
        
    	try
        {
	    ic = new InitialContext();
            // create EJB using factory from container 
            java.lang.Object objref = ic.lookup("SecAuthSampleBeanJndiName");		
	    //System.err.println("Looked up home...");		
	    home = (SecAuthSampleHome)PortableRemoteObject.narrow(
                objref, SecAuthSampleHome.class);
	    //System.err.println("Narrowed home...");
            //System.out.println("Creating EJB...");
            hr = home.create();
            //System.err.println("Got the EJB...");
        } catch (Exception ex) {
            System.err.println("Got Exception!!!");
            ex.printStackTrace();
	    return;
        }

        //Get the user role/name from env entry.
        String userRole = null;
        String userName = null;
        
        try
        {
            userRole = (String)ic.lookup("java:comp/env/UserRole");
            userName = (String)ic.lookup("java:comp/env/UserName");        
        } catch(Exception ex){
            System.out.println("UserRole/UserName env entries lookup FAILED. Will use default values!");
        }

        if (userRole == null)
        {
                System.out.println("UserRole env entry Not set. Assuming Administrator!");
                userRole = "RoleAdministrator";
        }
        if (userName == null)
        {
                System.out.println("UserName env entry Not set. Assuming sjsasuser1!");
                userName = "sjsasuser1";
        }
        
        System.out.println("Testing with user: " + userName + "; role:" + userRole);
        
        //--------------------------------------------------------
        //Test1
        //--------------------------------------------------------
       
        testId = "[1] ";
        
        try
        {
            System.out.println (testId + "Calling testIsCallerInRole()...");
            if (hr.testIsCallerInRole(userRole)) 
            {
                System.out.println (testId + "PASSED");
            } else {
                System.out.println (testId + "FAILED: " + userName + " is not in Role: " + 
                                    userRole);
            }
        } catch(Exception ex){
            System.out.println (testId + "FAILED");
            ex.printStackTrace();
        }

        //--------------------------------------------------------
        //Test2
        //--------------------------------------------------------
        
        testId = "[2] ";
        try
        {
            System.out.println (testId + "Calling testIsCallerExpected()...");
            if (hr.testIsCallerExpected(userName))
            {
                System.out.println (testId + "PASSED");
            } else {
                System.out.println (testId + "FAILED: " + userName + " is not expected.");
            }

        } catch(Exception ex){
            System.out.println (testId + "FAILED");
            ex.printStackTrace();
        }


        //--------------------------------------------------------
        //Test3
        //--------------------------------------------------------
        
        testId = "[3] ";
       
        try
        {
            System.out.println (testId + "Calling authorized method - methodIsAuthorized()");

            if (hr.methodIsAuthorized())
            {
                System.out.println (testId + "PASSED");
            } else {
                System.out.println (testId + "FAILED: " + userName + 
                                    " was not authorized to call methodIsAuthorized()" );
            }

        } catch(Exception ex){
            System.out.println (testId + "FAILED");
            ex.printStackTrace();
        }

        //--------------------------------------------------------
        //Test4
        //--------------------------------------------------------
        
        testId = "[4] ";
        
        try
        {
            // invoke unauthorized method on the EJB
            System.out.println(testId + "Calling unauthorized method - methodIsNotAuthorized():");
            hr.methodIsNotAuthorized();
            System.out.println(testId + "FAILED: able to call method!"); 
        } catch(java.rmi.AccessException aex){
            System.out.println(testId + "PASSED: Got expected AccessException!");
        } catch(Exception ex) {
            System.out.println(testId + "FAILED: Got unexpected Exception instead of AccessException!");
            ex.printStackTrace();
        }               
    }
}
