/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.logging.simple.servlet;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.naming.*;
import javax.servlet.http.*;
import javax.rmi.PortableRemoteObject;
import javax.ejb.*;
import java.util.logging.*;

import samples.logging.simple.ejb.*;

/**
 * This servlet invokes the GreeterEJB and calls the getGreeting method. 
 * The returned message is displayed in the output JSP. 
 * However, the objective of this servlet is to demonstrate the logging 
 * mechanism. This servlet logs messages using JSR 047 API.
 * <ul>
 * <li> Log Messages at <b>INFO</b> log level
 * <li> Log Messages at <b>FINE</b> log level
 * </ul>
 */
public class GreeterServlet extends HttpServlet {

    public static final String LOGTYPE_INFO      = "INFO";
    public static final String LOGTYPE_FINE      = "FINE";
    public static final String SERVLET_LOGGER    = 
        "samples.logging.simple.servlet";


    public static final Logger logger  = Logger.getLogger(SERVLET_LOGGER);

    /**
     * The doGet method of the servlet. Handles all http GET request.
     * Required by the servlet specification.
     * @exception throws ServletException and IOException.
     */
    public void doGet (HttpServletRequest request,HttpServletResponse response)
        throws ServletException, IOException {
        String theMessage = null;

        Level logLevel = Level.parse(request.getParameter("log_type"));

        try {
            logger.log(logLevel, "GreeterServlet is executing ...");
            String JNDIName = "java:comp/env/ejb/logger";
            logger.log(logLevel, 
                "Looking up greeter bean home interface using JNDI name: " + 
                JNDIName);
            InitialContext initContext = new javax.naming.InitialContext();
            Object objref = initContext.lookup(JNDIName);

            logger.log(logLevel, "Bean found!!!");
            GreeterHome myGreeterHome = 
                (GreeterHome)PortableRemoteObject.narrow(objref, 
                GreeterHome.class);

            logger.log(logLevel, "Creating a remote bean object...");
            Greeter myGreeterRemote = myGreeterHome.create();

            logger.log(logLevel, "Calling bean's getGreeting method...");
            theMessage = myGreeterRemote.getGreeting();

            logger.log(logLevel, "Got message from greeter bean: " + 
                theMessage);
        } catch(Exception e) {
            logger.log(logLevel, 
                "Greeter bean home not found - " + 
                "Is bean registered with JNDI?: " + e.toString());
            return;
        }

        logger.log(logLevel, "Storing the message in request object");
        request.setAttribute("message", theMessage);

        logger.log(logLevel, "Dispatching JSP for output");
        response.setContentType("text/html");
        RequestDispatcher dispatcher;
        dispatcher = getServletContext().getRequestDispatcher
         ("/GreeterView.jsp");
        dispatcher.include(request, response);

        return;
    }

    /**
     * The doPost method of the servlet. Handles all http POST request.
     * Required by the servlet specification.
     * @exception throws ServletException and IOException.
     */
    public void doPost (HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException {
        doGet(request,response);
    }

    /**
     * Returns the servlet info as a String.
     * @return returns the servlet info as a String.
     */
    public String getServletInfo() {
        return "Call a session bean from a servlet and deliver result via a JSP.";
    }
}
