/*
 * $Id: CustomerBean.java,v 1.3 2004/11/14 07:33:07 tcfujii Exp $
 */
/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package carstore;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;

public class CustomerBean extends Object {


    String firstName = null;
    String middleInitial = null;
    String lastName = null;
    String mailingAddress = null;
    String city = null;
    String state = null;
    String zip = null;
    String month = null;
    String year = null;


    public CustomerBean() {
        super();
    }


    protected Collection titleOptions = null;


    public Collection getTitleOptions() {
        titleOptions = new ArrayList();
        ResourceBundle rb = ResourceBundle.getBundle(
            "carstore.bundles.Resources",
            (FacesContext.getCurrentInstance().getViewRoot().getLocale()));
        String titleStr = (String) rb.getObject("mrLabel");
        titleOptions.add(new SelectItem(titleStr, titleStr,
                                        titleStr));
        titleStr = (String) rb.getObject("mrsLabel");
        titleOptions.add(new SelectItem(titleStr, titleStr,
                                        titleStr));
        titleStr = (String) rb.getObject("msLabel");
        titleOptions.add(new SelectItem(titleStr, titleStr,
                                        titleStr));

        return titleOptions;
    }


    public void setTitleOptions(Collection newOptions) {
        titleOptions = new ArrayList(newOptions);
    }


    String title = null;


    public void setCurrentTitle(String newTitle) {
        title = newTitle;
    }


    public String getCurrentTitle() {
        return title;
    }


    public void setFirstName(String first) {
        firstName = first;
    }


    public String getFirstName() {
        return firstName;
    }


    public void setMiddleInitial(String mI) {
        middleInitial = mI;
    }


    public String getMiddleInitial() {
        return middleInitial;
    }


    public void setLastName(String last) {
        lastName = last;
    }


    public String getLastName() {
        return lastName;
    }


    public void setMailingAddress(String mA) {
        mailingAddress = mA;
    }


    public String getMailingAddress() {
        return mailingAddress;
    }


    public void setCity(String cty) {
        city = cty;
    }


    public String getCity() {
        return city;
    }


    public void setState(String sT) {
        state = sT;
    }


    public String getState() {
        return state;
    }


    public void setZip(String zipCode) {
        zip = zipCode;
    }


    public String getZip() {
        return zip;
    }


    public void setMonth(String mth) {
        month = mth;
    }


    public String getMonth() {
        return month;
    }


    public void setYear(String yr) {
        year = yr;
    }


    public String getYear() {
        return year;
    }
}
