/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */


package carstore;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

import java.util.Enumeration;
import java.util.ResourceBundle;

/**
 * <p>A helper class that customizes a CarBean for a set of options
 * in a package.</p>
 *
 * <p>This class reads its settings from a Properties file</p>
 */

public class CarCustomizer extends Object {

    protected static final Log log = LogFactory.getLog(CarCustomizer.class);

    //
    // Relationship Instance Variables
    //

    private ResourceBundle bundle = null;


    public CarCustomizer() {
        this.init(CarStore.DEFAULT_PACKAGE_PROPERTIES);
    }


    public CarCustomizer(String bundleName) {
        this.init(bundleName);
    }


    private void init(String bundleName) {
        FacesContext context = FacesContext.getCurrentInstance();

        if (log.isDebugEnabled()) {
            log.debug("Loading bundle: " + bundleName + ".");
        }
        bundle = ResourceBundle.getBundle(bundleName);
    }


    private String buttonStyle = null;


    public String getButtonStyle() {
        return buttonStyle;
    }


    public void setButtonStyle(String newButtonStyle) {
        buttonStyle = newButtonStyle;
    }


    public void customizeCar(CarBean toCustomize) {
        FacesContext context = FacesContext.getCurrentInstance();
        Enumeration keys = bundle.getKeys();
        String
            key = null,
            disabledStr = null,
            curSetting = null;
        Boolean disabled = null;
        UIComponent component = null;
        Converter converter = null;
        Object valueToSet = null;

        while (keys.hasMoreElements()) {
            key = (String) keys.nextElement();
            // skip null and secondary keys.
            if (key == null || -1 != key.indexOf("_")) {
                continue;
            }
            // skip null values
            if (null == (curSetting = bundle.getString(key))) {
                continue;
            }

            // skip null components
            if (null ==
                (component =
                (UIComponent) toCustomize.getComponents().get(key))) {
                continue;
            }

            // handle the disabled setting, if necessary
            disabled = null;
            try {
                if (null !=
                    (disabledStr = bundle.getString(key + "_disabled"))) {
                    disabled = Boolean.valueOf(disabledStr);
                }
            } catch (Throwable e) {
            }
            if (null != disabled) {
                component.getAttributes().put("disabled", disabled);
            }

            // set the value
            // If the component can and does have a converter
            if (component instanceof ValueHolder &&
                (null != (converter =
                ((ValueHolder) component).getConverter()))) {
                valueToSet = converter.getAsObject(context, component,
                                                   curSetting);
            } else {
                valueToSet = curSetting;
            }

            if (component instanceof ValueHolder) {
                ((ValueHolder) component).setValue(valueToSet);
            }
        }
    }
}
	
	
	
