/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.jndi.external.share;

import java.util.Properties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Iterator;
import javax.naming.*;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.BasicAttributes;


public class ExternalRepositoryImpl 
    implements ExternalRepository, Referenceable 
{

    private Properties properties;

    public ExternalRepositoryImpl(Properties properties) 
    {
        this.properties = properties;
    }

    public Reference getReference() 
    {
        Reference reference = null;
        try 
        {
            // Store the properties as an array of bytes.
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            properties.store(bytearrayoutputstream, null);
            // Create a reference to the itself.
            reference = new Reference(ExternalRepositoryImpl.class.getName(),
                                        new BinaryRefAddr("properties", bytearrayoutputstream.toByteArray()),
                                        ExternalRepositoryImplFactory.class.getName(),
                                        null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return reference;
    }

    public void storeObject(Object object, String objectName, Map map) 
    {
        try 
        {
            // Use the properties to establish an initial directory context.
	    DirContext dircontext = new InitialDirContext(properties);
            // Create an iterator contains all of the entries in the map.
            Iterator iterator = map.entrySet().iterator();
            // For each entry, create an attribute.
            BasicAttributes basicattributes = new BasicAttributes();
            while (iterator.hasNext()) 
            {
                Map.Entry entry = (Map.Entry)iterator.next();
                basicattributes.put(entry.getKey().toString(), entry.getValue().toString());
            }
            // Bind the object to the specified name.
	    dircontext.rebind("cn=" + objectName, object, basicattributes);
            // Close the context.
	    dircontext.close();
        }
        catch (Exception exception) {
            System.out.println("ExternalRepository::storeObject caught an exception");
            exception.printStackTrace();
        }
    }

    public Object retrieveObject(String objectName) 
    {
        Object object = null;
        try 
        {
            // Use the properties to establish an initial directory context.
	    DirContext dircontext = new InitialDirContext(properties);
            // Lookup the object using the specified name.
            object = dircontext.lookup("cn=" + objectName);
            // Close the context.
	    dircontext.close();
        } catch (NameNotFoundException nnfe) {
            System.out.println("ExternalRepository::retrieveObject caught a NameNotFoundException");
            System.out.println("Object: " + objectName + " is not stored in this repository");
            //nnfe.printStackTrace();
        } catch (Exception exception) {
            System.out.println("ExternalRepository::retrieveObject caught an exception");
            exception.printStackTrace();
        }
        return object;
    }
}
