/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.jdbc.simple.servlet; 

import java.io.*; 
import java.util.*; 
import javax.servlet.*; 
import javax.naming.*; 
import javax.servlet.http.*; 
import javax.ejb.*; 
import java.sql.*;
import javax.sql.*;

import samples.jdbc.simple.ejb.*; 

/**
 * This servlet is responsible for generating the pages which asks for a String input
 * It will invoke GreeterDB EJB to generate a Greeting and save it in a database.
 */

public class GreeterDBServlet extends HttpServlet {  

  /** 
    * The doGet method of the servlet. Handles all http GET request.  
	* Required by the servlet specification.  
	* @exception throws ServletException and IOException.  
	*/

  public void doGet (HttpServletRequest request,HttpServletResponse response) 
   throws ServletException, IOException { 
    javax.ejb.Handle beanHandle; 
    GreeterDBHome myGreeterDBHome; 
    GreeterDB myGreeterDBRemote;
    InitialContext initContext = null; 
    Hashtable env = new java.util.Hashtable(1); 
    ResourceBundle rb = ResourceBundle.getBundle("LocalStrings", Locale.getDefault());

    System.out.println("\n"+rb.getString("greeterDBServlet_is_executing")+"...");  

    System.out.println(rb.getString("retrieving_initial_context")+"..."); 
    try { 
      initContext = new javax.naming.InitialContext(); 
      System.out.println("- "+rb.getString("retrieved_initial_context_successfully"));
    }  
    catch (Exception e) { 
      System.out.println("- "+rb.getString("exception_creating_initial_context")+": " + e.toString()); 
      return; 
    } 
    
    try { 
      System.out.println(rb.getString("looking_up_dbGreeter")+"..."); 
      String JNDIName = "java:comp/env/ejb/jdbc-simple"; 
      System.out.println("- "+rb.getString("looking_up")+": " + JNDIName); 
      myGreeterDBHome = (GreeterDBHome)initContext.lookup(JNDIName);
      System.out.println("- "+rb.getString("looked_up_ejb_successfully")); 
    }  
    catch(Exception e) { 
      System.out.println("- "+rb.getString("greeter_bean_not_found")+" - " +  
       rb.getString("is_bean_registered_with_JNDI")+"?: " + e.toString()); 
      return; 
    } 
    try { 
      System.out.println(rb.getString("creating_dbGreeter_bean")+"..."); 
      myGreeterDBRemote = myGreeterDBHome.create(); 
      System.out.println("- "+rb.getString("created_ejb_successfully"));  
    } 
    catch(CreateException e) { 
      System.out.println("- "+rb.getString("could_not_create_dbGreeter_bean")+": " + e.toString()); 
      return; 
    }  

    System.out.println(rb.getString("getting_the_message")+"..."); 
    String theMessage = myGreeterDBRemote.getGreeting();  
    System.out.println("- "+rb.getString("got_the_message")+": " + theMessage);

    System.out.println(rb.getString("getting_the_name_input")+"...");
    String name = request.getParameter("name"); 
    System.out.println("- "+rb.getString("got_name")+": " + name); 

    System.out.println(rb.getString("recording_the_greeting")+"...");
    StringBuffer timeStamp = new StringBuffer();
    Calendar rightNow = Calendar.getInstance();
    timeStamp.append(rightNow.get(Calendar.MONTH)+1); timeStamp.append("/");
    timeStamp.append(rightNow.get(Calendar.DAY_OF_MONTH)); timeStamp.append("/");
    timeStamp.append(rightNow.get(Calendar.YEAR)); timeStamp.append(" ");
    timeStamp.append(rightNow.get(Calendar.HOUR_OF_DAY)); timeStamp.append(":");
    timeStamp.append(rightNow.get(Calendar.MINUTE)); timeStamp.append(":");
    timeStamp.append(rightNow.get(Calendar.SECOND)); timeStamp.append(":");
    timeStamp.append(rightNow.get(Calendar.MILLISECOND));

    StringBuffer query = new StringBuffer("insert into Greeting (timeStamp,name,message) values ");
    query.append("('");        
    query.append(timeStamp.toString()); query.append("','");
    query.append(name); query.append("','");
    query.append("Good " + theMessage); query.append("')");  
    try {
      System.out.println(rb.getString("getting_datasource")+"...");
      String dsName = "java:comp/env/jdbc/jdbc-simple";
      DataSource ds = (javax.sql.DataSource)initContext.lookup(dsName);
      System.out.println("- "+rb.getString("got_datasource_successfully"));
      
      System.out.println(rb.getString("getting_connection")+"...");
      Connection conn = ds.getConnection();
      System.out.println("- "+rb.getString("got_connection_successfully"));
      
      System.out.println(rb.getString("getting_statement")+"...");
      Statement stmt = conn.createStatement();
      System.out.println("- "+rb.getString("got_statement_successfully"));
      
      System.out.println(rb.getString("executing_query")+"...");
      int nRows = stmt.executeUpdate(query.toString());
      System.out.println("- "+rb.getString("executed_query_with_result")+": " + nRows);
      
      System.out.println(rb.getString("closing_statement")+"...");
      stmt.close();
      System.out.println("- "+rb.getString("closed_statement_successfully"));
      
      System.out.println(rb.getString("closing_connection")+"...");
      conn.close();
      System.out.println("- "+rb.getString("closed_connection_successfully"));
    }
    catch (Exception ex) {
      System.out.println("- "+rb.getString("could_not_interact_with_db"));
      System.out.println(rb.getString("excpetion")+": " + ex.toString()); 
    }
    
    System.out.println(rb.getString("storing_the_message_in_request_object")+"..."); 
    request.setAttribute("message", theMessage); 
    System.out.println("- "+rb.getString("stored_message_successfully"));

    System.out.println(rb.getString("dispatching_jsp_for_output")+"..."); 
    response.setContentType("text/html");  
    RequestDispatcher dispatcher = getServletContext().getRequestDispatcher 
     ("/GreeterDBView.jsp"); 
    dispatcher.include(request, response);
    System.out.println("- "+rb.getString("dispatched_jsp_successfully")); 
    System.out.println("\n"+rb.getString("greeterDBServlet_all_done")+"\n");
    return;  
  }  

  /** 
    * The doPost method of the servlet. Handles all http POST request.  
	* Required by the servlet specification.  
	* @exception throws ServletException and IOException.  
	*/

  public void doPost (HttpServletRequest request,HttpServletResponse response) 
   throws ServletException, IOException { 
    doGet(request,response); 
  } 

  /** 
    * Returns the servlet info as a String.  
	* @return returns the servlet info as a String.  
	*/
  public String getServletInfo() { 
    ResourceBundle rb = ResourceBundle.getBundle("LocalStrings", Locale.getDefault());
    return rb.getString("call_a_session_bean")+"."; 
  } 
} 
