/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.jdbc.simple.servlet; 

import java.io.*; 
import java.util.*; 
import javax.servlet.*; 
import javax.naming.*; 
import javax.servlet.http.*; 
import javax.ejb.*; 
import java.sql.*;
import javax.sql.*;

import samples.jdbc.simple.ejb.*; 

/**
  * This servlet is responsible for displaying the greetings stored in 
  * the database .
  */
  
public class GreeterDBLogDisplayServlet extends HttpServlet {  

  /** 
    * The doGet method of the servlet. Handles all http GET request.  
	* Required by the servlet specification.  
	* @exception throws ServletException and IOException.  
	*/
  public void doGet (HttpServletRequest request,HttpServletResponse response) 
   throws ServletException, IOException { 
    java.sql.ResultSet rs = null;
    java.sql.Connection conn = null;
    java.sql.Statement stmt = null;  
    ResourceBundle rb = ResourceBundle.getBundle("LocalStrings", Locale.getDefault());
    System.out.println("\n"+rb.getString("greeterDBServlet_is_executing")+"...");
    try {
      System.out.println(rb.getString("retrieving_initial_context"));
      InitialContext ctx = new InitialContext();
      System.out.println("- "+rb.getString("retrieved_initial_context_successfully"));
          
      System.out.println(rb.getString("getting_datasource")+"...");
      String dsName = "java:comp/env/jdbc/jdbc-simple";
      DataSource ds = (javax.sql.DataSource)ctx.lookup(dsName);
      System.out.println("- "+rb.getString("got_datasource_successfully"));

      System.out.println(rb.getString("getting_connection"));
      conn = ds.getConnection();
      System.out.println("- "+rb.getString("got_connection_successfully"));
      
      System.out.println(rb.getString("getting_statement"));
      stmt = conn.createStatement();
      System.out.println("- "+rb.getString("got_statement_successfully"));
         
      System.out.println(rb.getString("executing_query")+"...");
      StringBuffer query = new StringBuffer("select * from Greeting");
      rs = stmt.executeQuery(query.toString());
      System.out.println("- "+rb.getString("executed_query_successfully"));
    }
    catch (Exception ex) {
      System.out.println("- "+rb.getString("could_not_interact_with_db"));
      System.out.println("- "+rb.getString("exception")+": " + ex.toString()); 
    }
    System.out.println(rb.getString("storing_database")+"..."); 
    request.setAttribute("dbResults", rs); 
    System.out.println(rb.getString("results_stored"));
        
    System.out.println(rb.getString("dispatching_jsp_for_output")+"..."); 
    response.setContentType("text/html"); 
    RequestDispatcher dispatcher = getServletContext().getRequestDispatcher 
     ("/GreeterDBLogView.jsp"); 
        dispatcher.include(request, response); 
    System.out.println("- "+rb.getString("dispatched_jsp_successfully")); 
    try {
      System.out.println(rb.getString("closing_statement")+"...");
      stmt.close();
      System.out.println("- "+rb.getString("closed_statement_successfully"));
        
      System.out.println(rb.getString("closing_connection")+"...");
      conn.close();
      System.out.println("- "+rb.getString("closed_connection_successfully"));
    }
    catch (Exception ex) {
      System.out.println("- "+rb.getString("could_not_close_statement_and_connection"));
    }
    System.out.println("\n"+rb.getString("greeterDBLogDisplayServlet_all_done")+"\n");
    return;  
  }  

  /** 
    * The doPost method of the servlet. Handles all http POST request.  
    * Required by the servlet specification.  
    * @exception throws ServletException and IOException.  
    */
  public void doPost (HttpServletRequest request,HttpServletResponse response) 
   throws ServletException, IOException { 
    doGet(request,response); 
  } 

  /** 
    * Returns the servlet info as a String.  
	* @return returns the servlet info as a String.  
	*/

  public String getServletInfo() { 
    ResourceBundle rb = ResourceBundle.getBundle("LocalStrings", Locale.getDefault());
    return rb.getString("retrieve_greetings_from_db")+"."; 
  } 
} 




