/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.ejb.timersession.client;

import samples.ejb.timersession.ejb.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class TimerSessionClient {

   public static void main(String[] args) {
       try {
           Context initial = new InitialContext();
           Object objref = initial.lookup("java:comp/env/ejb/SimpleTimerSession");
           TimerSessionHome home = 
               (TimerSessionHome)PortableRemoteObject.narrow(objref, 
                TimerSessionHome.class);

           TimerSession timerSession = home.create();
           long intervalDuration = 30000;
           System.out.println("Creating a timer with an interval duration of " + intervalDuration + " ms.");
           timerSession.myCreateTimer(intervalDuration);
           timerSession.remove();

           System.exit(0);

       } catch (Exception ex) {
           System.err.println("Caught an unexpected exception!");
           ex.printStackTrace();
           System.exit(1);
       }
   } 
} 
