<%--
 Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 Use is subject to license terms.
--%>

<!--
 Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
-->
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<fmt:setBundle basename="LocalStrings"/>

<%@ page language="java" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collection" %>
<%@ page import="javax.ejb.ObjectNotFoundException" %>
<%@ page import="javax.naming.InitialContext" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalCustomer" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalCustomerHome" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalSubscription" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalSubscriptionHome" %>
<%@ page import='java.util.*' %>
 
<html>
<head><title> <fmt:message key="cmp_demo_title"/> </title></head>
<body bgcolor="white">
<center>
<h2> <fmt:message key="cmp_demo_title"/> </h2>

<fmt:message key="search_by_title"/> :
<p>
    <form method="get" action="/customer/searchSubscription.jsp">
    <input type="text" name="searchText" size="25">
    <p>
    <input type="submit" value= <fmt:message key="search"/> >
    </form>

<%
String text = request.getParameter("searchText");

LocalSubscription subscription = null;
if (text != null && !"".equals(text)) {
    try {
        InitialContext ic = new InitialContext();
        Object o = ic.lookup("java:comp/env/SubscriptionBeanRef");
        LocalSubscriptionHome home = (LocalSubscriptionHome) o;

        try {
          subscription = home.findByPrimaryKey(text);
        } catch (ObjectNotFoundException ex) {}

%>
<fmt:message key="results"/> : <p>
<%
if (subscription != null) {
%>
<%=subscription.getTitle()%> [<%=subscription.getType()%>] 
<p>
<fmt:message key="people_who_have_subscription"/> :
<p>
<%
ArrayList customers = subscription.getCustomerList();
for (int i = 0; i < customers.size(); i++) {
  LocalCustomer customer = (LocalCustomer)customers.get(i);
%>
  <a href="/customer/editCustomer.jsp?cid=<%=customer.getCustomerID()%>">
  <%=customer.getLastName()%>, <%=customer.getFirstName()%></a>
  <p>
<%
}
if (customers.size() == 0) {
%>
<fmt:message key="none"/> .
<%}%>
<p>
<%
}
%>
<%
    } catch(Exception e) {
        e.printStackTrace();
        out.println(e.toString());
    }
}
%>

<hr>
[<a href="/customer/index.html"><fmt:message key="home"/> </a>]
</center>
</body>
</html>
