<%--
 Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 Use is subject to license terms.
--%>

<!--
 Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
-->

<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<fmt:setBundle basename="LocalStrings"/>
<%@ page language="java" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="javax.naming.InitialContext" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalAddress" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalAddressHome" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalCustomer" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalCustomerHome" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalSubscription" %>
<%@ page import="samples.ejb.cmp.cmpcustomer.ejb.customer.LocalSubscriptionHome" %>
<%@ page import='java.util.*' %>
 
<html>

<head><title><fmt:message key="cmp_demo_title"/> </title></head>
<body bgcolor="white">
<center>
<h2><fmt:message key="cmp_demo_title"/> </h2>

<%
String cid = request.getParameter("cid");
LocalCustomer customer = null;

try {
    InitialContext ic = new InitialContext();
    Object o = ic.lookup("java:comp/env/CustomerBeanRef");
    LocalCustomerHome home = (LocalCustomerHome) o;
    customer = home.findByPrimaryKey(cid);
} catch(Exception e) {
    e.printStackTrace();
    out.println(e.toString());
}

String removeCustomer = request.getParameter("removeCustomer");
if ("Remove".equals(removeCustomer)) {
  customer.remove();
}
else {

String sub_title = request.getParameter("subscription");
String add = request.getParameter("addSubscription");
String remove = request.getParameter("removeSubscription");
if (sub_title != null && !"".equals(sub_title)) {
    try {
        if ("Add".equals(add)) {
          customer.addSubscription(sub_title);
        } 
        else if ("Remove".equals(remove)) {
          customer.removeSubscription(sub_title);
        }
        else {}
    } catch(Exception e) {
        e.printStackTrace();
        out.println(e.toString());
    }
}

String id = request.getParameter("id");
String street = request.getParameter("street");
String city = request.getParameter("city");
String zip = request.getParameter("zip");
String state = request.getParameter("state");

if (id != null && !"".equals(id)) {
    try {
        InitialContext ic = new InitialContext();
        Object o = ic.lookup("java:comp/env/AddressBeanRef");
        LocalAddressHome home = (LocalAddressHome) o;

        LocalAddress address = home.create(cid,id,street,city,zip,state);
    } catch(Exception e) {
        e.printStackTrace();
        out.println("Create new address FAILED : " + e.toString());
    }
}

ArrayList allSubscriptions = null;
try {
    InitialContext ic = new InitialContext();

    Object s = ic.lookup("java:comp/env/SubscriptionBeanRef");
    LocalSubscriptionHome sHome = (LocalSubscriptionHome) s;
    allSubscriptions = (ArrayList)sHome.findAllSubscriptions();
} catch(Exception e) {
    e.printStackTrace();
    out.println(e.toString());
}
%>

<table border=10>
  <tr>
    <td><fmt:message key="customer_id"/> : </td>
    <td><%=customer.getCustomerID()%></td>
  </tr>
  <tr>
    <td><fmt:message key="first_name"/> : </td>
    <td><%=customer.getFirstName()%></td>
  </tr>
  <tr>
    <td><fmt:message key="last_name"/> : </td>
    <td><%=customer.getLastName()%></td>
  </tr>

<%
ArrayList addresses = customer.getAddressList();
for (int i = 0; i < addresses.size(); i++) {
  LocalAddress address = (LocalAddress)addresses.get(i);
%>
<tr>
    <td>Address [<%=address.getAddressID()%>]</td>
    <td><%=address.getStreet()%></td>
</tr>
<%
}
%>
<%
ArrayList subscriptions = customer.getSubscriptionList();
for (int i = 0; i < subscriptions.size(); i++) {
  LocalSubscription subscription = (LocalSubscription)subscriptions.get(i);
%>
<tr>
    <td>Subscription [<%=subscription.getType()%>]</td>
    <td><%=subscription.getTitle()%></td>
</tr>
<%
}
%>
</table>

<p>

<form method="post" ation="/customer/editCustomer.jsp?cid=<%=cid%>">
<input type="submit" name="removeCustomer" value=<fmt:message key="remove"/> >
</form>

<p>

<fmt:message key="add_new_subscription"/> :
<form method="post" action="/customer/editCustomer.jsp?cid=<%=cid%>">
<table border="2">
<%
if (allSubscriptions.size() == 0) {
%>
<tr>
    <td><fmt:message key="subscription"/> </td>
    <td><fmt:message key="none_avaialable"/> . [<a href="/customer/createSubscription.jsp"><fmt:message key="create_here"/> .</a>]</td>
</tr>
<%
} else {
%>
<tr>
<td>
<select name="subscription">
<%
  for (int i = 0; i < allSubscriptions.size(); i++) {
    LocalSubscription subscription = (LocalSubscription)allSubscriptions.get(i);
%>
    <option value="<%=subscription.getTitle()%>">
    <%=subscription.getTitle()%>[<%=subscription.getType()%>]</option>
<%
  }
%>
</select>
</td>
<td><input type="submit" name="addSubscription" value=<fmt:message key="add"/> ></td>
<td><input type="submit" name="removeSubscription" value=<fmt:message key="remove"/> ></td>
</tr>
<p>

<%
}
%>
</table>
</form>

<fmt:message key="add_an_address"/> :
<p>
<form method="post" action="/customer/editCustomer.jsp?cid=<%=cid%>">
<table border=10>
  <tr>
    <td><fmt:message key="address_id"/> :</td>
    <td><input type="text" name="id" size="11" value=""></td>
  </tr>
  <tr>
    <td><fmt:message key="street"/> : </td>
    <td><input type="text" name="street" size="40" value=""></td>
  </tr>
  <tr>
    <td><fmt:message key="city"/> : </td>
    <td><input type="text" name="city" size="25" value=""></td>
  </tr>
  <tr>
    <td><fmt:message key="state"/> : </td>
    <td><input type="text" name="state" size="25" value=""></td>
  </tr>
  <tr>
    <td><fmt:message key="zip"/> : </td>
    <td><input type="text" name="zip" size="25" value=""></td>
  </tr>
</table>
<p>
<input type="submit" name="submit" value=<fmt:message key="add_address"/> >
<p>
</form>

<% } %>
<hr>
[<a href="/customer/index.html"><fmt:message key="home"/> </a>]
</center>
</body>
</html>
