/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.connectors.mailconnector.share;

import javax.resource.cci.*;
import java.beans.*;

import samples.connectors.mailconnector.api.*;

/**
 * This implementation class is used by an application component to pass
 * connection-specific info/properties to the getConnection method in the
 * JavaMailConnectionFactoryImpl class.
 * This class is implemented as a JavaBeans component.
 */

public class ConnectionSpecImpl implements ConnectionSpec 
{
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private String userName = null;
    private String password = null;
    private String folderName = null;
    private String serverName = null;
    private String protocol = null;

    /**
     * ConnectionSpecImpl constructor (no arguments).
     */

    public ConnectionSpecImpl() { }

    /**
     * Returns the user name value.
     *
     * @return   String containing the user name
     */

    public String getUserName() 
    {
        return this.userName;
    }

    /**
     * Returns the password value.
     *
     * @return   String containing the password
     */

    public String getPassword() 
    {
        return this.password;
    }

    /**
     * Returns the server name value.
     *
     * @return   String containing the server name
     */

    public String getServerName() 
    {
        return this.serverName;
    }

    /**
     * Returns the folder name value.
     *
     * @return   String containing the folder name
     */

    public String getFolderName() 
    {
        return this.folderName;
    }

    /**
     * Returns the protocol value.
     *
     * @return   String containing the protocol
     */

    public String getProtocol() 
    {
        return this.protocol;
    }

    /**
     * Sets the user name value.
     *
     * @param userName   the user name
     */

    public void setUserName(String userName) 
    {
        String oldName = this.userName;
        this.userName  = userName;
	changes.firePropertyChange("userName", oldName, userName);
    }

    /**
     * Sets the password value.
     *
     * @param password   the user password
     */

    public void setPassword(String password) 
    {
        String oldPass = this.password;
        this.password  = password;
	changes.firePropertyChange("password", oldPass, password);
    }

    /**
     * Sets the folder name value.
     *
     * @param folderName  the folder name
     */

    public void setFolderName(String folderName) 
    {
        String oldFolderName = this.folderName;
        this.folderName      = folderName;
	changes.firePropertyChange("folderName", oldFolderName, folderName);
    }

    /**
     * Sets the server name value.
     *
     * @param serverName  the server name
     */

    public void setServerName(String serverName) 
    {
        String oldServerName = this.serverName;
        this.serverName      = serverName;
	changes.firePropertyChange("serverName", oldServerName, serverName);
    }

    /**
     * Sets the protocol value.
     *
     * @param protocol  the server name
     */

    public void setProtocol(String protocol) 
    {
        String oldProtocol = this.protocol;
        this.protocol      = protocol;
	changes.firePropertyChange("protocol", oldProtocol, protocol);
    }

    /**
     * Associate PropertyChangeListener with the ConnectionSpecImpl in order to 
     * notify about properties changes.
     *
     * @param listener the listener to be associated with the connection spec
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) 
    {
        changes.addPropertyChangeListener(listener);
    }

    /**
     * Delete association of PropertyChangeListener with the 
     * ConnectionSpecImpl.
     *
     * @param listener the listener to be deleted
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) 
    {
        changes.removePropertyChangeListener(listener);
    }
}
